/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import java.io.IOException;
import net.sf.antcontrib.cpptasks.TargetHistoryTable;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.ProcessorConfiguration;
import net.sf.antcontrib.cpptasks.compiler.ProgressMonitor;

public class CCTaskProgressMonitor
implements ProgressMonitor {
    private ProcessorConfiguration config;
    private TargetHistoryTable history;
    private VersionInfo versionInfo;
    private long lastCommit = -1L;

    public CCTaskProgressMonitor(TargetHistoryTable history, VersionInfo versionInfo) {
        this.history = history;
        this.versionInfo = versionInfo;
    }

    @Override
    public void finish(ProcessorConfiguration config, boolean normal) {
        long current = System.currentTimeMillis();
        if (current - this.lastCommit > 120000L) {
            try {
                this.history.commit();
                this.lastCommit = System.currentTimeMillis();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void progress(String[] sources) {
        this.history.update(this.config, sources, this.versionInfo);
        long current = System.currentTimeMillis();
        if (current - this.lastCommit > 120000L) {
            try {
                this.history.commit();
                this.lastCommit = current;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void start(ProcessorConfiguration config) {
        if (this.lastCommit < 0L) {
            this.lastCommit = System.currentTimeMillis();
        }
        this.config = config;
    }
}

