/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks;

import net.sf.antcontrib.cpptasks.OSType;

public class Platform {
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_VERSION = System.getProperty("os.version");
    public static final OSType OS_TYPE = Platform.getOSTypeImpl(OS_NAME.toLowerCase(), false);

    private static final OSType getOSTypeImpl(String osLower, boolean isAndroid) throws RuntimeException {
        if (isAndroid) {
            return OSType.ANDROID;
        }
        if (osLower.startsWith("linux")) {
            return OSType.LINUX;
        }
        if (osLower.startsWith("freebsd")) {
            return OSType.FREEBSD;
        }
        if (osLower.startsWith("android")) {
            return OSType.ANDROID;
        }
        if (osLower.startsWith("mac os x") || osLower.startsWith("darwin")) {
            return OSType.MACOS;
        }
        if (osLower.startsWith("sunos")) {
            return OSType.SUNOS;
        }
        if (osLower.startsWith("windows")) {
            return OSType.WINDOWS;
        }
        if (osLower.startsWith("kd")) {
            return OSType.OPENKODE;
        }
        if (osLower.startsWith("ios")) {
            return OSType.IOS;
        }
        if (osLower.startsWith("hp-ux") || osLower.startsWith("hp") && osLower.indexOf("ux") >= 0) {
            return OSType.HPUX;
        }
        throw new RuntimeException("Please port OS detection to your platform (" + OS_NAME + ")");
    }
}

