/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.borland;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.borland.BorlandLinker;
import net.sf.antcontrib.cpptasks.borland.BorlandProcessor;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompiler;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.compiler.ProgressMonitor;
import net.sf.antcontrib.cpptasks.parser.CParser;
import net.sf.antcontrib.cpptasks.parser.Parser;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public class BorlandResourceCompiler
extends CommandLineCompiler {
    private static final BorlandResourceCompiler instance = new BorlandResourceCompiler(false, null);

    public static BorlandResourceCompiler getInstance() {
        return instance;
    }

    private BorlandResourceCompiler(boolean newEnvironment, Environment env) {
        super("brc32", "c:\\__bogus\\__bogus.rc", new String[]{".rc"}, new String[]{".h", ".hpp", ".inl"}, ".res", false, false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-r");
    }

    @Override
    protected void addWarningSwitch(Vector args, int level) {
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new BorlandResourceCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) throws BuildException {
        super.compile(task, outputDir, sourceFiles, args, endArgs, relentless, config, monitor);
    }

    @Override
    protected Parser createParser(File source) {
        return new CParser();
    }

    @Override
    protected int getArgumentCountPerInputFile() {
        return 2;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-d");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return BorlandProcessor.getEnvironmentPath("brc32", 'i', new String[]{"..\\include"});
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return BorlandProcessor.getIncludeDirSwitch("-i", includeDir);
    }

    @Override
    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (index == 0) {
            String[] outputFileNames = this.getOutputFileNames(filename, null);
            String fullOutputName = new File(outputDir, outputFileNames[0]).toString();
            return "-fo" + fullOutputName;
        }
        return filename;
    }

    @Override
    public Linker getLinker(LinkType type) {
        return BorlandLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    @Override
    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        String arg1 = this.getInputFileArgument(outputDir, inputFile, 0);
        String arg2 = this.getInputFileArgument(outputDir, inputFile, 1);
        return arg1.length() + arg2.length() + 2;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }
}

