/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compaq;

import java.util.Vector;
import net.sf.antcontrib.cpptasks.compaq.CompaqVisualFortranLibrarian;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.devstudio.DevStudioCompatibleLinker;

public final class CompaqVisualFortranLinker
extends DevStudioCompatibleLinker {
    private static final CompaqVisualFortranLinker dllLinker = new CompaqVisualFortranLinker(".dll");
    private static final CompaqVisualFortranLinker instance = new CompaqVisualFortranLinker(".exe");

    public static CompaqVisualFortranLinker getInstance() {
        return instance;
    }

    private CompaqVisualFortranLinker(String outputSuffix) {
        super("DF", "__bogus__.xxx", outputSuffix);
    }

    @Override
    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        args.addElement("/NOLOGO");
        boolean staticRuntime = linkType.isStaticRuntime();
        if (staticRuntime) {
            args.addElement("/libs:static");
        } else {
            args.addElement("/libs:dll");
        }
        if (debug) {
            args.addElement("/debug");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("/dll");
        } else {
            args.addElement("/exe");
        }
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary()) {
            return CompaqVisualFortranLibrarian.getInstance();
        }
        if (type.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    @Override
    public String[] getOutputFileSwitch(String outputFile) {
        StringBuffer buf = new StringBuffer("/OUT:");
        if (outputFile.indexOf(32) >= 0) {
            buf.append('\"');
            buf.append(outputFile);
            buf.append('\"');
        } else {
            buf.append(outputFile);
        }
        return new String[]{buf.toString()};
    }
}

