/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import net.sf.antcontrib.cpptasks.OSType;
import net.sf.antcontrib.cpptasks.Platform;
import net.sf.antcontrib.cpptasks.compiler.CaptureStreamHandler;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import org.apache.tools.ant.types.Environment;

public abstract class AbstractProcessor
implements Processor,
Cloneable {
    public static final int DEFAULT_DISCARD_BID = 1;
    public static final int DEFAULT_PROCESS_BID = 100;
    private final String[] headerExtensions;
    private final String[] sourceExtensions;

    protected static String getIdentifier(String[] command, String fallback) {
        String identifier = fallback;
        try {
            String[] cmdout = CaptureStreamHandler.run(command);
            if (cmdout.length > 0) {
                identifier = cmdout[0];
            }
        }
        catch (Throwable ex) {
            identifier = fallback + ":" + ex.toString();
        }
        return identifier;
    }

    protected AbstractProcessor(String[] sourceExtensions, String[] headerExtensions) {
        this.sourceExtensions = (String[])sourceExtensions.clone();
        this.headerExtensions = (String[])headerExtensions.clone();
    }

    protected AbstractProcessor(AbstractProcessor ap) {
        this.sourceExtensions = (String[])ap.sourceExtensions.clone();
        this.headerExtensions = (String[])ap.headerExtensions.clone();
    }

    @Override
    public int bid(String inputFile) {
        int i;
        String lower = inputFile.toLowerCase();
        for (i = 0; i < this.sourceExtensions.length; ++i) {
            if (!lower.endsWith(this.sourceExtensions[i])) continue;
            return 100;
        }
        for (i = 0; i < this.headerExtensions.length; ++i) {
            if (!lower.endsWith(this.headerExtensions[i])) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        return this;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String[] getHeaderExtensions() {
        return (String[])this.headerExtensions.clone();
    }

    @Override
    public abstract String getIdentifier();

    public String[] getSourceExtensions() {
        return (String[])this.sourceExtensions.clone();
    }

    protected boolean isDarwin() {
        return OSType.MACOS == Platform.OS_TYPE;
    }

    protected boolean isHPUX() {
        return OSType.HPUX == Platform.OS_TYPE;
    }

    protected boolean isWindows() {
        return OSType.WINDOWS == Platform.OS_TYPE;
    }

    public final String toString() {
        return this.getIdentifier();
    }
}

