/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.antcontrib.cpptasks.compiler.LineReader;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;

public class CaptureStreamHandler
implements ExecuteStreamHandler {
    private InputStream errorStream;
    private InputStream fromProcess;
    private String[] output;
    private LineReader outputReader;
    private LineReader errorReader;
    private Thread outputReaderThread;
    private Thread errorReaderThread;

    public static String[] run(String[] cmdline) {
        CaptureStreamHandler handler = new CaptureStreamHandler();
        Execute exec = new Execute((ExecuteStreamHandler)handler);
        exec.setCommandline(cmdline);
        try {
            exec.execute();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return handler.getOutput();
    }

    public String[] getOutput() {
        if (this.output != null) {
            return this.output;
        }
        return new String[0];
    }

    public void setProcessErrorStream(InputStream is) throws IOException {
        this.errorStream = is;
    }

    public void setProcessInputStream(OutputStream os) throws IOException {
        os.close();
    }

    public void setProcessOutputStream(InputStream is) throws IOException {
        this.fromProcess = is;
    }

    public void start() throws IOException {
        this.outputReader = new LineReader(this.fromProcess);
        this.errorReader = new LineReader(this.errorStream);
        this.outputReaderThread = new Thread(this.outputReader);
        this.errorReaderThread = new Thread(this.errorReader);
        this.outputReaderThread.start();
        this.errorReaderThread.start();
    }

    public void stop() {
        int i;
        try {
            if (this.outputReaderThread != null) {
                this.outputReaderThread.join();
            }
            if (this.errorReaderThread != null) {
                this.errorReaderThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String[] outputLines = null;
        String[] errorLines = null;
        outputLines = this.outputReader != null ? this.outputReader.getLines() : new String[]{};
        errorLines = this.errorReader != null ? this.errorReader.getLines() : new String[]{};
        this.output = new String[outputLines.length + errorLines.length];
        int pos = 0;
        for (i = 0; i < errorLines.length; ++i) {
            this.output[pos++] = errorLines[i];
        }
        for (i = 0; i < outputLines.length; ++i) {
            this.output[pos++] = outputLines[i];
        }
    }
}

