/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.compiler;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.LinkerDef;
import net.sf.antcontrib.cpptasks.ProcessorDef;
import net.sf.antcontrib.cpptasks.ProcessorParam;
import net.sf.antcontrib.cpptasks.TargetDef;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.AbstractLinker;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.LinkerConfiguration;
import net.sf.antcontrib.cpptasks.gcc.GccProcessor;
import net.sf.antcontrib.cpptasks.types.CommandLineArgument;
import net.sf.antcontrib.cpptasks.types.LibrarySet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public abstract class CommandLineLinker
extends AbstractLinker {
    private String command;
    private final Environment env = null;
    private String identifier;
    private final String identifierArg;
    private final boolean isLibtool;
    private final boolean isXcoderun;
    private String[] librarySets;
    private final CommandLineLinker libtoolLinker;
    private final boolean newEnvironment = false;
    private final String outputSuffix;
    private final boolean isGNU;
    private final boolean isCLANG;

    public CommandLineLinker(String command, String identifierArg, String[] extensions, String[] ignoredExtensions, String outputSuffix, boolean isXCoderun, boolean isLibtool, CommandLineLinker libtoolLinker) {
        super(extensions, ignoredExtensions);
        this.command = command;
        this.identifierArg = identifierArg;
        this.outputSuffix = outputSuffix;
        this.isLibtool = isLibtool;
        this.isXcoderun = isXCoderun;
        this.libtoolLinker = libtoolLinker;
        this.isGNU = "gcc".equals(command) || "g++".equals(command);
        this.isCLANG = "clang".equals(command);
    }

    public CommandLineLinker(CommandLineLinker ld, boolean isXCoderun) {
        super(ld);
        this.command = ld.command;
        this.identifierArg = ld.identifierArg;
        this.outputSuffix = ld.outputSuffix;
        this.isLibtool = ld.isLibtool;
        this.isXcoderun = isXCoderun;
        this.libtoolLinker = ld.libtoolLinker;
        this.isGNU = "gcc".equals(this.command) || "g++".equals(this.command);
        this.isCLANG = "clang".equals(this.command);
    }

    protected abstract void addBase(long var1, Vector var3);

    protected abstract void addFixed(Boolean var1, Vector var2);

    protected abstract void addImpliedArgs(boolean var1, LinkType var2, Vector var3);

    protected abstract void addIncremental(boolean var1, Vector var2);

    protected String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        return null;
    }

    protected abstract void addMap(boolean var1, Vector var2);

    protected abstract void addStack(int var1, Vector var2);

    protected abstract void addEntry(String var1, Vector var2);

    @Override
    protected LinkerConfiguration createConfiguration(CCTask task, LinkType linkType, ProcessorDef[] baseDefs, LinkerDef specificDef, TargetDef targetPlatform, VersionInfo versionInfo) {
        Vector preargs = new Vector();
        Vector midargs = new Vector();
        Vector endargs = new Vector();
        Vector[] args = new Vector[]{preargs, midargs, endargs};
        LinkerDef[] defaultProviders = new LinkerDef[baseDefs.length + 1];
        defaultProviders[0] = specificDef;
        for (int i = 0; i < baseDefs.length; ++i) {
            defaultProviders[i + 1] = (LinkerDef)baseDefs[i];
        }
        for (int i = defaultProviders.length - 1; i >= 0; --i) {
            CommandLineArgument[] commandArgs = defaultProviders[i].getActiveProcessorArgs();
            for (int j = 0; j < commandArgs.length; ++j) {
                args[commandArgs[j].getLocation()].addElement(commandArgs[j].getValue());
            }
        }
        Vector<ProcessorParam> params = new Vector<ProcessorParam>();
        for (int i = defaultProviders.length - 1; i >= 0; --i) {
            ProcessorParam[] paramArray = defaultProviders[i].getActiveProcessorParams();
            for (int j = 0; j < paramArray.length; ++j) {
                params.add(paramArray[j]);
            }
        }
        ProcessorParam[] paramArray = params.toArray(new ProcessorParam[params.size()]);
        boolean debug = specificDef.getDebug(baseDefs, 0);
        String startupObject = this.getStartupObject(linkType);
        this.addImpliedArgs(debug, linkType, preargs);
        this.addIncremental(specificDef.getIncremental(defaultProviders, 1), preargs);
        this.addFixed(specificDef.getFixed(defaultProviders, 1), preargs);
        this.addMap(specificDef.getMap(defaultProviders, 1), preargs);
        this.addBase(specificDef.getBase(defaultProviders, 1), preargs);
        this.addStack(specificDef.getStack(defaultProviders, 1), preargs);
        this.addEntry(specificDef.getEntry(defaultProviders, 1), preargs);
        String[] libnames = null;
        LibrarySet[] libsets = specificDef.getActiveLibrarySets(defaultProviders, 1);
        if (libsets.length > 0) {
            libnames = this.addLibrarySets(task, libsets, preargs, midargs, endargs);
        }
        StringBuffer buf = new StringBuffer(this.getIdentifier());
        for (int i = 0; i < 3; ++i) {
            Enumeration argenum = args[i].elements();
            while (argenum.hasMoreElements()) {
                buf.append(' ');
                buf.append(argenum.nextElement().toString());
            }
        }
        String configId = buf.toString();
        String[][] options = new String[][]{new String[args[0].size() + args[1].size()], new String[args[2].size()]};
        args[0].copyInto(options[0]);
        int offset = args[0].size();
        for (int i = 0; i < args[1].size(); ++i) {
            options[0][i + offset] = (String)args[1].elementAt(i);
        }
        args[2].copyInto(options[1]);
        boolean rebuild = specificDef.getRebuild(baseDefs, 0);
        boolean map = specificDef.getMap(defaultProviders, 1);
        return new CommandLineLinkerConfiguration(this, configId, options, paramArray, rebuild, map, debug, libnames, startupObject);
    }

    protected String decorateLinkerOption(StringBuffer buf, String arg) {
        return arg;
    }

    protected final String getCommand() {
        return this.command;
    }

    protected abstract String getCommandFileSwitch(String var1);

    @Override
    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.identifierArg == null ? CommandLineLinker.getIdentifier(new String[]{this.command}, this.command) : CommandLineLinker.getIdentifier(new String[]{this.command, this.identifierArg}, this.command);
        }
        return this.identifier;
    }

    public final CommandLineLinker getLibtoolLinker() {
        if (this.libtoolLinker != null) {
            return this.libtoolLinker;
        }
        return this;
    }

    protected abstract int getMaximumCommandLength();

    @Override
    public String getOutputFileName(String baseName, VersionInfo versionInfo) {
        return baseName + this.outputSuffix;
    }

    protected String[] getOutputFileSwitch(CCTask task, String outputFile) {
        return this.getOutputFileSwitch(outputFile);
    }

    protected abstract String[] getOutputFileSwitch(String var1);

    protected String getStartupObject(LinkType linkType) {
        return null;
    }

    protected final boolean getLibtool() {
        return this.isLibtool;
    }

    protected final boolean isXcodeRun() {
        return this.isXcoderun;
    }

    protected final boolean isGNU() {
        return this.isGNU;
    }

    protected final boolean isCLANG() {
        return this.isCLANG;
    }

    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        int retval;
        String parentPath;
        File parentDir = new File(outputFile.getParent());
        try {
            parentPath = parentDir.getCanonicalPath();
        }
        catch (IOException ex) {
            parentPath = parentDir.getAbsolutePath();
        }
        String[] execArgs = this.prepareArguments(task, parentPath, outputFile.getName(), sourceFiles, config);
        int commandLength = 0;
        for (int i = 0; i < execArgs.length; ++i) {
            commandLength += execArgs[i].length() + 1;
        }
        if (commandLength >= this.getMaximumCommandLength()) {
            try {
                execArgs = this.prepareResponseFile(outputFile, execArgs);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if ((retval = this.runCommand(task, parentDir, execArgs)) != 0) {
            throw new BuildException(this.getCommand() + " failed with return code " + retval, task.getLocation());
        }
    }

    protected String[] prepareArguments(CCTask task, String outputDir, String outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        int i;
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        String[] outputSwitch = this.getOutputFileSwitch(task, outputFile);
        boolean writeSONAME = task.getWriteSONAME() && task.isSharedLibrary() && (this.isGNU || this.isCLANG);
        int allArgsCount = preargs.length + 1 + outputSwitch.length + sourceFiles.length + endargs.length + (writeSONAME ? 1 : 0);
        if (this.isLibtool) {
            ++allArgsCount;
        }
        if (this.isXcoderun) {
            ++allArgsCount;
        }
        String[] allArgs = new String[allArgsCount];
        int index = 0;
        if (this.isLibtool) {
            allArgs[index++] = "libtool";
        }
        if (this.isXcoderun) {
            allArgs[index++] = "xcrun";
        }
        allArgs[index++] = this.getCommand();
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < preargs.length; ++i) {
            allArgs[index++] = this.decorateLinkerOption(buf, preargs[i]);
        }
        if (writeSONAME) {
            allArgs[index++] = this.isXcoderun ? "-Wl,-install_name," + GccProcessor.getEscapedOutputFile(outputFile) : "-Wl,-h," + GccProcessor.getEscapedOutputFile(outputFile);
        }
        for (i = 0; i < outputSwitch.length; ++i) {
            allArgs[index++] = outputSwitch[i];
        }
        for (i = 0; i < sourceFiles.length; ++i) {
            allArgs[index++] = this.prepareFilename(buf, outputDir, sourceFiles[i]);
        }
        for (i = 0; i < endargs.length; ++i) {
            allArgs[index++] = this.decorateLinkerOption(buf, endargs[i]);
        }
        return allArgs;
    }

    protected String prepareFilename(StringBuffer buf, String outputDir, String sourceFile) {
        String relativePath = CUtil.getRelativePath(outputDir, new File(sourceFile));
        return this.quoteFilename(buf, relativePath);
    }

    protected String[] prepareResponseFile(File outputFile, String[] args) throws IOException {
        int i;
        String baseName = outputFile.getName();
        File commandFile = new File(outputFile.getParent(), baseName + ".rsp");
        FileWriter writer = new FileWriter(commandFile);
        int execArgCount = 1;
        if (this.isLibtool) {
            ++execArgCount;
        }
        if (this.isXcoderun) {
            ++execArgCount;
        }
        String[] execArgs = new String[execArgCount + 1];
        for (i = 0; i < execArgCount; ++i) {
            execArgs[i] = args[i];
        }
        execArgs[execArgCount] = this.getCommandFileSwitch(commandFile.toString());
        for (i = execArgCount; i < args.length; ++i) {
            if (args[i].indexOf(" ") >= 0 && args[i].charAt(0) != '\"') {
                writer.write(34);
                writer.write(args[i]);
                writer.write("\"\n");
                continue;
            }
            writer.write(args[i]);
            writer.write(10);
        }
        writer.close();
        return execArgs;
    }

    protected String quoteFilename(StringBuffer buf, String filename) {
        if (filename.indexOf(32) >= 0) {
            buf.setLength(0);
            buf.append('\"');
            buf.append(filename);
            buf.append('\"');
            return buf.toString();
        }
        return filename;
    }

    protected int runCommand(CCTask task, File workingDir, String[] cmdline) throws BuildException {
        return CUtil.runCommand(task, workingDir, cmdline, false, this.env);
    }

    protected final void setCommand(String command) {
        this.command = command;
    }
}

