/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.devstudio;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.CompilerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.PrecompilingCommandLineCCompiler;
import net.sf.antcontrib.cpptasks.devstudio.DevStudioProcessor;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public abstract class DevStudioCompatibleCCompiler
extends PrecompilingCommandLineCCompiler {
    private static String[] mflags = new String[]{"/ML", "/MLd", null, null, "/MT", "/MTd", "/MD", "/MDd"};

    protected DevStudioCompatibleCCompiler(String command, String identifierArg, boolean newEnvironment, Environment env) {
        super(command, identifierArg, new String[]{".c", ".cc", ".cpp", ".cxx", ".c++"}, new String[]{".h", ".hpp", ".inl"}, ".obj", false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        boolean staticRuntime;
        args.addElement("/c");
        args.addElement("/nologo");
        if (exceptions) {
            args.addElement("/EHsc");
        }
        int mindex = 0;
        if (multithreaded) {
            mindex += 4;
        }
        if (!(staticRuntime = linkType.isStaticRuntime())) {
            mindex += 2;
        }
        if (debug) {
            ++mindex;
            this.addDebugSwitch(args);
        } else {
            if (optimization != null) {
                if (optimization.isSize()) {
                    args.addElement("/O1");
                }
                if (optimization.isSpeed()) {
                    args.addElement("/O2");
                }
            }
            args.addElement("/DNDEBUG");
        }
        String mflag = mflags[mindex];
        if (mflag == null) {
            throw new BuildException("multithread='false' and runtime='dynamic' not supported");
        }
        args.addElement(mflag);
        if (rtti != null && rtti.booleanValue()) {
            args.addElement("/GR");
        }
    }

    protected void addDebugSwitch(Vector args) {
        args.addElement("/Zi");
        args.addElement("/Od");
        args.addElement("/GZ");
        args.addElement("/D_DEBUG");
    }

    @Override
    protected void addWarningSwitch(Vector args, int level) {
        DevStudioProcessor.addWarningSwitch(args, level);
    }

    @Override
    protected CompilerConfiguration createPrecompileGeneratingConfig(CommandLineCompilerConfiguration baseConfig, File prototype, String lastInclude) {
        String[] additionalArgs = new String[]{"/Fp" + CUtil.getBasename(prototype) + ".pch", "/Yc"};
        return new CommandLineCompilerConfiguration(baseConfig, additionalArgs, null, true);
    }

    @Override
    protected CompilerConfiguration createPrecompileUsingConfig(CommandLineCompilerConfiguration baseConfig, File prototype, String lastInclude, String[] exceptFiles) {
        String[] additionalArgs = new String[]{"/Fp" + CUtil.getBasename(prototype) + ".pch", "/Yu" + lastInclude};
        return new CommandLineCompilerConfiguration(baseConfig, additionalArgs, exceptFiles, false);
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        DevStudioProcessor.getDefineSwitch(buffer, define, value);
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ";");
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return DevStudioProcessor.getIncludeDirSwitch(includeDir);
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
        DevStudioProcessor.getUndefineSwitch(buffer, define);
    }
}

