/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.devstudio;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.TargetMatcher;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.platforms.WindowsPlatform;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public abstract class DevStudioCompatibleLinker
extends CommandLineLinker {
    public DevStudioCompatibleLinker(String command, String identifierArg, String outputSuffix) {
        super(command, identifierArg, new String[]{".obj", ".lib", ".res"}, new String[]{".map", ".pdb", ".lnk", ".dll"}, outputSuffix, false, false, null);
    }

    @Override
    protected void addBase(long base, Vector args) {
        if (base >= 0L) {
            String baseAddr = Long.toHexString(base);
            args.addElement("/BASE:0x" + baseAddr);
        }
    }

    @Override
    protected void addFixed(Boolean fixed, Vector args) {
        if (fixed != null) {
            if (fixed.booleanValue()) {
                args.addElement("/FIXED");
            } else {
                args.addElement("/FIXED:NO");
            }
        }
    }

    @Override
    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        args.addElement("/NOLOGO");
        if (debug) {
            args.addElement("/DEBUG");
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("/DLL");
        }
        if (linkType.isSubsystemGUI()) {
            args.addElement("/SUBSYSTEM:WINDOWS");
        } else if (linkType.isSubsystemConsole()) {
            args.addElement("/SUBSYSTEM:CONSOLE");
        }
    }

    @Override
    protected void addIncremental(boolean incremental, Vector args) {
        if (incremental) {
            args.addElement("/INCREMENTAL:YES");
        } else {
            args.addElement("/INCREMENTAL:NO");
        }
    }

    @Override
    protected void addMap(boolean map, Vector args) {
        if (map) {
            args.addElement("/MAP");
        }
    }

    @Override
    protected void addStack(int stack, Vector args) {
        if (stack >= 0) {
            String stackStr = Integer.toHexString(stack);
            args.addElement("/STACK:0x" + stackStr);
        }
    }

    @Override
    protected void addEntry(String entry, Vector args) {
        if (entry != null) {
            args.addElement("/ENTRY:" + entry);
        }
    }

    @Override
    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    @Override
    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        StringBuffer buf = new StringBuffer();
        String[] patterns = new String[libnames.length];
        for (int i = 0; i < libnames.length; ++i) {
            buf.setLength(0);
            buf.append(libnames[i]);
            buf.append(".lib");
            patterns[i] = buf.toString();
        }
        return patterns;
    }

    @Override
    public int getMaximumCommandLength() {
        return Short.MAX_VALUE;
    }

    @Override
    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"/OUT:" + outputFile};
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public void addVersionFiles(VersionInfo versionInfo, LinkType linkType, File outputFile, boolean isDebug, File objDir, TargetMatcher matcher) throws IOException {
        WindowsPlatform.addVersionFiles(versionInfo, linkType, outputFile, isDebug, objDir, matcher);
    }
}

