/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.gcc.GccProcessor;
import net.sf.antcontrib.cpptasks.types.LibrarySet;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public abstract class AbstractLdLinker
extends CommandLineLinker {
    private final String outputPrefix;

    protected AbstractLdLinker(String command, String identifierArg, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isXCoderun, boolean isLibtool, AbstractLdLinker libtoolLinker) {
        super(command, identifierArg, extensions, ignoredExtensions, outputSuffix, isXCoderun, isLibtool, libtoolLinker);
        this.outputPrefix = outputPrefix;
    }

    protected AbstractLdLinker(AbstractLdLinker ld, boolean isXCoderun) {
        super(ld, isXCoderun);
        this.outputPrefix = ld.outputPrefix;
    }

    @Override
    public void addBase(long base, Vector args) {
        if (base >= 0L) {
            args.addElement("--image-base");
            args.addElement(Long.toHexString(base));
        }
    }

    @Override
    public void addFixed(Boolean fixed, Vector args) {
    }

    @Override
    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (debug) {
            args.addElement("-g");
        }
        if (this.isDarwin()) {
            if (linkType.isStaticRuntime()) {
                args.addElement("-static");
            }
            if (linkType.isStaticLibrary()) {
                args.addElement("-r");
            } else if (linkType.isPluginModule()) {
                args.addElement("-bundle");
            } else if (linkType.isSharedLibrary()) {
                args.addElement("-dynamiclib");
            }
        } else {
            if (linkType.isStaticRuntime()) {
                args.addElement("-static");
            }
            if (linkType.isStaticLibrary()) {
                args.addElement("-r");
            } else if (linkType.isPluginModule()) {
                args.addElement("-shared");
            } else if (linkType.isSharedLibrary()) {
                args.addElement("-shared");
            }
        }
    }

    @Override
    public void addIncremental(boolean incremental, Vector args) {
        if (incremental) {
            args.addElement("-i");
        }
    }

    protected int addLibraryPatterns(String[] libnames, StringBuffer buf, String prefix, String extension, String[] patterns, int offset) {
        for (int i = 0; i < libnames.length; ++i) {
            buf.setLength(0);
            buf.append(prefix);
            buf.append(libnames[i]);
            buf.append(extension);
            patterns[offset + i] = buf.toString();
        }
        return offset + libnames.length;
    }

    @Override
    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        Vector<String> libnames = new Vector<String>();
        super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        LibraryTypeEnum previousLibraryType = null;
        for (int i = 0; i < libsets.length; ++i) {
            LibrarySet set = libsets[i];
            File libdir = set.getDir(null);
            String[] libs = set.getLibs();
            if (libdir != null) {
                String relPath = libdir.getAbsolutePath();
                File outputFile = task.getOutfile();
                if (outputFile != null && outputFile.getParentFile() != null) {
                    relPath = CUtil.getRelativePath(outputFile.getParentFile().getAbsolutePath(), libdir);
                }
                if (set.getType() != null && "framework".equals(set.getType().getValue()) && this.isDarwin()) {
                    endargs.addElement("-F" + relPath);
                } else {
                    endargs.addElement("-L" + relPath);
                }
            }
            if (set.getType() != previousLibraryType) {
                if (set.getType() != null && "static".equals(set.getType().getValue())) {
                    endargs.addElement(this.getStaticLibFlag());
                    previousLibraryType = set.getType();
                } else if (set.getType() == null || !"framework".equals(set.getType().getValue()) || !this.isDarwin()) {
                    endargs.addElement(this.getDynamicLibFlag());
                    previousLibraryType = set.getType();
                }
            }
            StringBuffer buf = new StringBuffer("-l");
            if (set.getType() != null && "framework".equals(set.getType().getValue()) && this.isDarwin()) {
                buf.setLength(0);
                buf.append("-framework ");
            }
            int initialLength = buf.length();
            for (int j = 0; j < libs.length; ++j) {
                buf.setLength(initialLength);
                buf.append(libs[j]);
                libnames.addElement(libs[j]);
                endargs.addElement(buf.toString());
            }
        }
        String[] rc = new String[libnames.size()];
        for (int i = 0; i < libnames.size(); ++i) {
            rc[i] = (String)libnames.elementAt(i);
        }
        return rc;
    }

    @Override
    public void addMap(boolean map, Vector args) {
        if (map) {
            args.addElement("-M");
        }
    }

    @Override
    public void addStack(int stack, Vector args) {
        if (stack > 0) {
            args.addElement("--stack");
            args.addElement(Integer.toString(stack));
        }
    }

    @Override
    protected void addEntry(String entry, Vector args) {
        if (entry != null) {
            args.addElement("-e");
            args.addElement(entry);
        }
    }

    @Override
    public String getCommandFileSwitch(String commandFile) {
        throw new IllegalStateException("ld does not support command files");
    }

    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("LIB", ":");
    }

    @Override
    public String getLibraryKey(File libfile) {
        String libname = libfile.getName();
        int lastDot = libname.lastIndexOf(46);
        if (lastDot >= 0) {
            return libname.substring(0, lastDot);
        }
        return libname;
    }

    @Override
    public File[] getLibraryPath() {
        return new File[0];
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        StringBuffer buf = new StringBuffer();
        int patternCount = libnames.length;
        if (libType == null) {
            patternCount *= 2;
        }
        String[] patterns = new String[patternCount];
        int offset = 0;
        if (libType == null || "static".equals(libType.getValue())) {
            offset = this.addLibraryPatterns(libnames, buf, "lib", ".a", patterns, 0);
        }
        if (libType != null && "framework".equals(libType.getValue()) && this.isDarwin()) {
            for (int i = 0; i < libnames.length; ++i) {
                buf.setLength(0);
                buf.append(libnames[i]);
                buf.append(".framework/");
                buf.append(libnames[i]);
                patterns[offset++] = buf.toString();
            }
        } else if (libType == null || !"static".equals(libType.getValue())) {
            offset = this.isHPUX() ? this.addLibraryPatterns(libnames, buf, "lib", ".sl", patterns, offset) : (this.isWindows() ? this.addLibraryPatterns(libnames, buf, "", ".dll", patterns, offset) : this.addLibraryPatterns(libnames, buf, "lib", ".so", patterns, offset));
        }
        return patterns;
    }

    @Override
    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getOutputFileName(String baseName, VersionInfo versionInfo) {
        return this.outputPrefix + super.getOutputFileName(baseName, versionInfo);
    }

    @Override
    public String[] getOutputFileSwitch(String outputFile) {
        return GccProcessor.getOutputFileSwitch("-o", outputFile);
    }

    @Override
    public boolean isCaseSensitive() {
        return true;
    }

    @Override
    public String[] prepareArguments(CCTask task, String outputDir, String outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        String[] libnames = config.getLibraryNames();
        if (libnames == null || libnames.length == 0) {
            return super.prepareArguments(task, outputDir, outputFile, sourceFiles, config);
        }
        String[] localSources = (String[])sourceFiles.clone();
        int extra = 0;
        for (int i = 0; i < libnames.length; ++i) {
            String libname = libnames[i];
            for (int j = 0; j < localSources.length; ++j) {
                String extension;
                String filename;
                if (localSources[j] == null || localSources[j].indexOf(libname) <= 0) continue;
                if (!this.isWindows() && localSources[j].indexOf("lib") > 0) {
                    filename = new File(localSources[j]).getName();
                    if (!filename.startsWith("lib") || !filename.substring(3).startsWith(libname) || !(extension = filename.substring(libname.length() + 3)).equals(".a") && !extension.equals(".so") && !extension.equals(".sl")) continue;
                    localSources[j] = null;
                    ++extra;
                    continue;
                }
                if (!this.isWindows() || localSources[j].indexOf(".dll") <= 0 || !(filename = new File(localSources[j]).getName()).startsWith(libname) || !(extension = filename.substring(libname.length())).equals(".dll")) continue;
                localSources[j] = null;
                ++extra;
            }
        }
        if (extra == 0) {
            return super.prepareArguments(task, outputDir, outputFile, sourceFiles, config);
        }
        String[] finalSources = new String[localSources.length - extra];
        int index = 0;
        for (int i = 0; i < localSources.length; ++i) {
            if (localSources[i] == null) continue;
            finalSources[index++] = localSources[i];
        }
        return super.prepareArguments(task, outputDir, outputFile, finalSources, config);
    }

    protected String getDynamicLibFlag() {
        return "-Bdynamic";
    }

    protected String getStaticLibFlag() {
        return "-Bstatic";
    }
}

