/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCCompiler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import org.apache.tools.ant.types.Environment;

public abstract class GccCompatibleCCompiler
extends CommandLineCCompiler {
    private static final String[] headerExtensions = new String[]{".h", ".hpp", ".inl"};
    private static final String[] sourceExtensions = new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".i", ".f", ".for"};

    protected GccCompatibleCCompiler(GccCompatibleCCompiler cc, boolean isXcoderun) {
        super(cc, isXcoderun);
    }

    protected GccCompatibleCCompiler(String command, String identifierArg, boolean isXcoderun, boolean libtool, GccCompatibleCCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(command, identifierArg, sourceExtensions, headerExtensions, libtool ? ".fo" : ".o", isXcoderun, libtool, libtoolCompiler, newEnvironment, env);
    }

    protected GccCompatibleCCompiler(String command, String identifierArg, String[] sourceExtensions, String[] headerExtensions, boolean isXcoderun, boolean libtool, GccCompatibleCCompiler libtoolCompiler, boolean newEnvironment, Environment env) {
        super(command, identifierArg, sourceExtensions, headerExtensions, libtool ? ".fo" : ".o", isXcoderun, libtool, libtoolCompiler, newEnvironment, env);
    }

    @Override
    public void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        if (debug) {
            args.addElement("-g");
        } else if (optimization != null) {
            if (optimization.isSize()) {
                args.addElement("-Os");
            } else if (optimization.isSpeed()) {
                if ("full".equals(optimization.getValue())) {
                    args.addElement("-O2");
                } else if ("speed".equals(optimization.getValue())) {
                    args.addElement("-O1");
                } else {
                    args.addElement("-O3");
                }
            }
        }
        if (this.getIdentifier().indexOf("mingw") >= 0) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("-mconsole");
            }
            if (linkType.isSubsystemGUI()) {
                args.addElement("-mwindows");
            }
        }
        if (rtti != null && !rtti.booleanValue()) {
            args.addElement("-fno-rtti");
        }
    }

    public void addIncludePath(String path, Vector cmd) {
        cmd.addElement("-I" + path);
    }

    @Override
    public void addWarningSwitch(Vector args, int level) {
        switch (level) {
            case 0: {
                args.addElement("-w");
                break;
            }
            case 5: {
                args.addElement("-Werror");
            }
            case 4: {
                args.addElement("-W");
            }
            case 3: {
                args.addElement("-Wall");
            }
        }
    }

    @Override
    public void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-D");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ":");
    }

    @Override
    public String getIncludeDirSwitch(String includeDir) {
        return "-I" + includeDir;
    }

    @Override
    public void getUndefineSwitch(StringBuffer buffer, String define) {
        buffer.append("-U");
        buffer.append(define);
    }
}

