/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.AbstractLdLinker;
import net.sf.antcontrib.cpptasks.gcc.GccLibrarian;

public abstract class GnuLinker
extends AbstractLdLinker {
    static String[] darwinLinkerOptions = new String[]{"-arch", "-weak_framework", "-lazy_framework", "-weak_library"};
    static String[] clangLinkerOptions = new String[]{"-target"};
    protected File[] libDirs;

    public GnuLinker(String command, String identifierArg, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isXCoderun, boolean isLibtool, AbstractLdLinker libtoolLinker) {
        super(command, identifierArg, extensions, ignoredExtensions, outputPrefix, outputSuffix, isXCoderun, isLibtool, libtoolLinker);
    }

    public GnuLinker(AbstractLdLinker ld, boolean isXCoderun) {
        super(ld, isXCoderun);
    }

    protected abstract String[] getStaticLinkerOptions();

    protected abstract GnuLinker getStaticDllLinker();

    protected abstract GnuLinker getStaticDllClangLinker();

    protected abstract GnuLinker getStaticArLinker();

    protected abstract GnuLinker getStaticArClangLinker();

    protected abstract GnuLinker getStaticClangInstance();

    protected abstract GnuLinker getStaticXcodeClangInstance();

    protected abstract GnuLinker getStaticMachBundleLinker();

    protected abstract GnuLinker getStaticMachClangBundleLinker();

    protected abstract GnuLinker getStaticXcodeMachClangBundleLinker();

    protected abstract GnuLinker getStaticMachDllLinker();

    protected abstract GnuLinker getStaticMachDllClangLinker();

    protected abstract GnuLinker getStaticXcodeMachDllClangLinker();

    protected abstract GnuLinker getStaticMachArLinker();

    protected abstract GnuLinker getStaticMachArClangLinker();

    protected abstract GnuLinker getStaticXcodeMachArClangLinker();

    protected abstract GnuLinker getStaticInstance();

    @Override
    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        super.addImpliedArgs(debug, linkType, args);
        if (this.getIdentifier().indexOf("mingw") >= 0) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("-mconsole");
            }
            if (linkType.isSubsystemGUI()) {
                args.addElement("-mwindows");
            }
        }
    }

    @Override
    public String decorateLinkerOption(StringBuffer buf, String arg) {
        if (arg.startsWith("--sysroot")) {
            return arg;
        }
        if (arg.startsWith("-nostdlib")) {
            return arg;
        }
        String decoratedArg = arg;
        if (arg.length() > 1 && arg.charAt(0) == '-') {
            switch (arg.charAt(1)) {
                case 'F': 
                case 'L': 
                case 'O': 
                case 'W': 
                case 'f': 
                case 'g': 
                case 'l': 
                case 'm': 
                case 'u': 
                case 'v': {
                    break;
                }
                default: {
                    boolean known = false;
                    HashSet<String> allLinkerOptions = new HashSet<String>();
                    allLinkerOptions.addAll(Arrays.asList(this.getStaticLinkerOptions()));
                    if (this.isCLANG()) {
                        allLinkerOptions.addAll(Arrays.asList(clangLinkerOptions));
                    }
                    if (this.isDarwin()) {
                        allLinkerOptions.addAll(Arrays.asList(darwinLinkerOptions));
                    }
                    if (known = allLinkerOptions.contains(arg)) break;
                    buf.setLength(0);
                    buf.append("-Wl,");
                    buf.append(arg);
                    decoratedArg = buf.toString();
                }
            }
        }
        return decoratedArg;
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary() && !type.getUseHighlevelTool()) {
            return GccLibrarian.getInstance();
        }
        if (type.isStaticLibrary()) {
            if (this.isDarwin()) {
                return this.isGNU() ? this.getStaticMachArLinker() : (this.isXcodeRun() ? this.getStaticXcodeMachArClangLinker() : this.getStaticMachArClangLinker());
            }
            return this.isGNU() ? this.getStaticArLinker() : this.getStaticArClangLinker();
        }
        if (type.isPluginModule()) {
            if (this.isDarwin()) {
                return this.isGNU() ? this.getStaticMachBundleLinker() : (this.isXcodeRun() ? this.getStaticXcodeMachClangBundleLinker() : this.getStaticMachClangBundleLinker());
            }
            return this.isGNU() ? this.getStaticDllLinker() : this.getStaticDllClangLinker();
        }
        if (type.isSharedLibrary()) {
            if (this.isDarwin()) {
                return this.isGNU() ? this.getStaticMachDllLinker() : (this.isXcodeRun() ? this.getStaticXcodeMachDllClangLinker() : this.getStaticMachDllClangLinker());
            }
            return this.isGNU() ? this.getStaticDllLinker() : this.getStaticDllClangLinker();
        }
        return this.isGNU() ? this.getStaticInstance() : (this.isXcodeRun() ? this.getStaticXcodeClangInstance() : this.getStaticClangInstance());
    }
}

