/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CaptureStreamHandler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.gcc.GnuLinker;
import net.sf.antcontrib.cpptasks.types.LibrarySet;

public class GppLinker
extends GnuLinker {
    protected static final String[] discardFiles = new String[0];
    protected static final String[] objFiles = new String[]{".o", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String libPrefix = "libraries: =";
    private static final String[] libtoolObjFiles = new String[]{".fo", ".a", ".lib", ".dll", ".so", ".sl"};
    private static String[] linkerOptions = new String[]{"-bundle", "-dylib", "-dynamic", "-dynamiclib", "-nostartfiles", "-nostdlib", "-prebind", "-s", "-static", "-shared", "-symbolic", "-Xlinker"};
    private static final GppLinker instance = new GppLinker("gcc", objFiles, discardFiles, "", "", false, false, null);
    private static final GppLinker clangInstance = new GppLinker("clang", objFiles, discardFiles, "", "", false, false, null);
    private static final GppLinker xcodeClangInstance = new GppLinker(clangInstance, true);
    private static final GppLinker dllLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".so", false, false, new GppLinker("gcc", objFiles, discardFiles, "lib", ".so", false, true, null));
    private static final GppLinker dllClangLinker = new GppLinker("clang", objFiles, discardFiles, "lib", ".so", false, false, new GppLinker("clang", objFiles, discardFiles, "lib", ".so", false, true, null));
    private static final GppLinker arLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".a", false, false, new GppLinker("gcc", objFiles, discardFiles, "lib", ".a", false, true, null));
    private static final GppLinker arClangLinker = new GppLinker("clang", objFiles, discardFiles, "lib", ".a", false, false, new GppLinker("clang", objFiles, discardFiles, "lib", ".a", false, true, null));
    private static final GppLinker machBundleLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".bundle", false, false, null);
    private static final GppLinker machClangBundleLinker = new GppLinker("clang", objFiles, discardFiles, "lib", ".bundle", false, false, null);
    private static final GppLinker xcodeMachClangBundleLinker = new GppLinker(machClangBundleLinker, true);
    private static final GppLinker machDllLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".dylib", false, false, null);
    private static final GppLinker machDllClangLinker = new GppLinker("clang", objFiles, discardFiles, "lib", ".dylib", false, false, null);
    private static final GppLinker xcodeMachDllClangLinker = new GppLinker(machDllClangLinker, true);
    private static final GppLinker machArLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".a", false, false, null);
    private static final GppLinker machArClangLinker = new GppLinker("clang", objFiles, discardFiles, "lib", ".a", false, false, null);
    private static final GppLinker xcodeMachArClangLinker = new GppLinker(machArClangLinker, true);
    private String runtimeLibrary;

    public static GppLinker getInstance() {
        return instance;
    }

    public static GppLinker getClangInstance() {
        return clangInstance;
    }

    public static GppLinker getXcodeClangInstance() {
        return xcodeClangInstance;
    }

    protected GppLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isXCoderun, boolean isLibtool, GppLinker libtoolLinker) {
        super(command, "-dumpversion", extensions, ignoredExtensions, outputPrefix, outputSuffix, false, isLibtool, libtoolLinker);
    }

    protected GppLinker(GppLinker ld, boolean isXCoderun) {
        super(ld, isXCoderun);
    }

    @Override
    protected final String[] getStaticLinkerOptions() {
        return linkerOptions;
    }

    @Override
    protected final GnuLinker getStaticDllLinker() {
        return dllLinker;
    }

    @Override
    protected final GnuLinker getStaticDllClangLinker() {
        return dllClangLinker;
    }

    @Override
    protected final GnuLinker getStaticArLinker() {
        return arLinker;
    }

    @Override
    protected final GnuLinker getStaticArClangLinker() {
        return arClangLinker;
    }

    @Override
    protected final GnuLinker getStaticClangInstance() {
        return clangInstance;
    }

    @Override
    protected final GnuLinker getStaticXcodeClangInstance() {
        return xcodeClangInstance;
    }

    @Override
    protected final GnuLinker getStaticMachBundleLinker() {
        return machBundleLinker;
    }

    @Override
    protected final GnuLinker getStaticMachClangBundleLinker() {
        return machClangBundleLinker;
    }

    @Override
    protected final GnuLinker getStaticXcodeMachClangBundleLinker() {
        return xcodeMachClangBundleLinker;
    }

    @Override
    protected final GnuLinker getStaticMachDllLinker() {
        return machDllLinker;
    }

    @Override
    protected final GnuLinker getStaticMachDllClangLinker() {
        return machDllClangLinker;
    }

    @Override
    protected final GnuLinker getStaticXcodeMachDllClangLinker() {
        return xcodeMachDllClangLinker;
    }

    @Override
    protected final GnuLinker getStaticMachArLinker() {
        return machArLinker;
    }

    @Override
    protected final GnuLinker getStaticMachArClangLinker() {
        return machArClangLinker;
    }

    @Override
    protected final GnuLinker getStaticXcodeMachArClangLinker() {
        return xcodeMachArClangLinker;
    }

    @Override
    protected final GnuLinker getStaticInstance() {
        return instance;
    }

    @Override
    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        String[] cmdin;
        String[] cmdout;
        super.addImpliedArgs(debug, linkType, args);
        this.runtimeLibrary = linkType.isStaticRuntime() ? ((cmdout = CaptureStreamHandler.run(cmdin = new String[]{"g++", "-print-file-name=libstdc++.a"})).length > 0 ? cmdout[0] : null) : "-lstdc++";
    }

    @Override
    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        String[] rs = super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        if (this.runtimeLibrary != null) {
            endargs.addElement(this.runtimeLibrary);
        }
        return rs;
    }

    @Override
    public File[] getLibraryPath() {
        if (this.libDirs == null) {
            Vector<String> dirs = new Vector<String>();
            String[] args = new String[]{"g++", "-print-search-dirs"};
            String[] cmdout = CaptureStreamHandler.run(args);
            for (int i = 0; i < cmdout.length; ++i) {
                int prefixIndex = cmdout[i].indexOf(libPrefix);
                if (prefixIndex < 0) continue;
                int s = prefixIndex + libPrefix.length();
                int t = cmdout[i].indexOf(59, s);
                while (t > 0) {
                    dirs.addElement(cmdout[i].substring(s, t));
                    s = t + 1;
                    t = cmdout[i].indexOf(59, s);
                }
                dirs.addElement(cmdout[i].substring(s));
                ++i;
                while (i < cmdout.length) {
                    dirs.addElement(cmdout[i]);
                    ++i;
                }
            }
            Object[] libpath = new String[dirs.size()];
            dirs.copyInto(libpath);
            int count = CUtil.checkDirectoryArray((String[])libpath);
            this.libDirs = new File[count];
            int index = 0;
            for (int i = 0; i < libpath.length; ++i) {
                if (libpath[i] == null) continue;
                this.libDirs[index++] = new File((String)libpath[i]);
            }
        }
        return this.libDirs;
    }
}

