/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc.cross;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.LinkerParam;
import net.sf.antcontrib.cpptasks.compiler.CaptureStreamHandler;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.AbstractLdLinker;
import net.sf.antcontrib.cpptasks.gcc.cross.GccLibrarian;
import net.sf.antcontrib.cpptasks.gcc.cross.GccProcessor;
import net.sf.antcontrib.cpptasks.types.LibrarySet;
import org.apache.tools.ant.BuildException;

public class GppLinker
extends AbstractLdLinker {
    protected static final String[] discardFiles = new String[0];
    protected static final String[] objFiles = new String[]{".o", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final GppLinker arLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".a", false, new GppLinker("gcc", objFiles, discardFiles, "lib", ".a", true, null));
    private static final GppLinker dllLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".so", false, new GppLinker("gcc", objFiles, discardFiles, "lib", ".so", true, null));
    private static final String libPrefix = "libraries: =";
    protected static final String[] libtoolObjFiles = new String[]{".fo", ".a", ".lib", ".dll", ".so", ".sl"};
    private static String[] linkerOptions = new String[]{"-bundle", "-dylib", "-dynamic", "-dynamiclib", "-nostartfiles", "-nostdlib", "-prebind", "-s", "-static", "-shared", "-symbolic", "-Xlinker"};
    private static final GppLinker instance = new GppLinker("gcc", objFiles, discardFiles, "", "", false, null);
    private static final GppLinker machArLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".a", false, null);
    private static final GppLinker machDllLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".dylib", false, null);
    private static final GppLinker machPluginLinker = new GppLinker("gcc", objFiles, discardFiles, "lib", ".bundle", false, null);
    private File[] libDirs;
    private String runtimeLibrary;

    public static GppLinker getInstance() {
        return instance;
    }

    protected GppLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isLibtool, GppLinker libtoolLinker) {
        super(command, "-dumpversion", extensions, ignoredExtensions, outputPrefix, outputSuffix, false, isLibtool, libtoolLinker);
    }

    @Override
    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        String[] cmdin;
        String[] cmdout;
        super.addImpliedArgs(debug, linkType, args);
        if (this.getIdentifier().indexOf("mingw") >= 0) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("-mconsole");
            }
            if (linkType.isSubsystemGUI()) {
                args.addElement("-mwindows");
            }
        }
        this.runtimeLibrary = linkType.isStaticRuntime() ? ((cmdout = CaptureStreamHandler.run(cmdin = new String[]{"g++", "-print-file-name=libstdc++.a"})).length > 0 ? cmdout[0] : null) : "-lstdc++";
    }

    @Override
    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        String[] rs = super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        if (this.runtimeLibrary != null) {
            endargs.addElement(this.runtimeLibrary);
        }
        return rs;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        GppLinker clone = (GppLinker)super.clone();
        return clone;
    }

    @Override
    public String decorateLinkerOption(StringBuffer buf, String arg) {
        String decoratedArg = arg;
        if (arg.length() > 1 && arg.charAt(0) == '-') {
            switch (arg.charAt(1)) {
                case 'F': 
                case 'L': 
                case 'O': 
                case 'W': 
                case 'f': 
                case 'g': 
                case 'l': 
                case 'm': 
                case 'u': {
                    break;
                }
                default: {
                    boolean known = false;
                    for (int i = 0; i < linkerOptions.length; ++i) {
                        if (!linkerOptions[i].equals(arg)) continue;
                        known = true;
                        break;
                    }
                    if (known) break;
                    buf.setLength(0);
                    buf.append("-Wl,");
                    buf.append(arg);
                    decoratedArg = buf.toString();
                }
            }
        }
        return decoratedArg;
    }

    @Override
    public File[] getLibraryPath() {
        if (this.libDirs == null) {
            Vector<String> dirs = new Vector<String>();
            String[] args = new String[]{"g++", "-print-search-dirs"};
            String[] cmdout = CaptureStreamHandler.run(args);
            for (int i = 0; i < cmdout.length; ++i) {
                int prefixIndex = cmdout[i].indexOf(libPrefix);
                if (prefixIndex < 0) continue;
                int s = prefixIndex + libPrefix.length();
                int t = cmdout[i].indexOf(59, s);
                while (t > 0) {
                    dirs.addElement(cmdout[i].substring(s, t));
                    s = t + 1;
                    t = cmdout[i].indexOf(59, s);
                }
                dirs.addElement(cmdout[i].substring(s));
                ++i;
                while (i < cmdout.length) {
                    dirs.addElement(cmdout[i]);
                    ++i;
                }
            }
            Object[] libpath = new String[dirs.size()];
            dirs.copyInto(libpath);
            int count = CUtil.checkDirectoryArray((String[])libpath);
            this.libDirs = new File[count];
            int index = 0;
            for (int i = 0; i < libpath.length; ++i) {
                if (libpath[i] == null) continue;
                this.libDirs[index++] = new File((String)libpath[i]);
            }
        }
        return this.libDirs;
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary() && !type.getUseHighlevelTool()) {
            return GccLibrarian.getInstance();
        }
        if (type.isStaticLibrary()) {
            if (this.isDarwin()) {
                return machArLinker;
            }
            return arLinker;
        }
        if (type.isPluginModule()) {
            if (GccProcessor.getMachine().indexOf("darwin") >= 0) {
                return machPluginLinker;
            }
            return dllLinker;
        }
        if (type.isSharedLibrary()) {
            if (GccProcessor.getMachine().indexOf("darwin") >= 0) {
                return machDllLinker;
            }
            return dllLinker;
        }
        return instance;
    }

    @Override
    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        try {
            GppLinker clone = (GppLinker)this.clone();
            LinkerParam param = config.getParam("target");
            if (param != null) {
                clone.setCommand(param.getValue() + "-" + this.getCommand());
            }
            clone.superlink(task, outputFile, sourceFiles, config);
        }
        catch (CloneNotSupportedException e) {
            this.superlink(task, outputFile, sourceFiles, config);
        }
    }

    private void superlink(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        super.link(task, outputFile, sourceFiles, config);
    }
}

