/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.gcc.cross;

import java.io.File;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.LinkerParam;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.gcc.AbstractLdLinker;
import net.sf.antcontrib.cpptasks.gcc.cross.GccLibrarian;
import org.apache.tools.ant.BuildException;

public final class LdLinker
extends AbstractLdLinker {
    private static final String[] libtoolObjFiles = new String[]{".fo", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String[] objFiles = new String[]{".o", ".a", ".lib", ".dll", ".so", ".sl"};
    private static final String[] discardFiles = new String[0];
    private static final LdLinker arLinker = new LdLinker("ld", objFiles, discardFiles, "lib", ".a", false, new LdLinker("ld", objFiles, discardFiles, "lib", ".a", true, null));
    private static final LdLinker dllLinker = new LdLinker("ld", objFiles, discardFiles, "lib", ".so", false, new LdLinker("ld", objFiles, discardFiles, "lib", ".so", true, null));
    private static final LdLinker instance = new LdLinker("ld", objFiles, discardFiles, "", "", false, null);
    private File[] libDirs;

    public static LdLinker getInstance() {
        return instance;
    }

    private LdLinker(String command, String[] extensions, String[] ignoredExtensions, String outputPrefix, String outputSuffix, boolean isLibtool, LdLinker libtoolLinker) {
        super(command, "-version", extensions, ignoredExtensions, outputPrefix, outputSuffix, false, isLibtool, libtoolLinker);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LdLinker clone = (LdLinker)super.clone();
        return clone;
    }

    @Override
    public Linker getLinker(LinkType type) {
        if (type.isStaticLibrary() && !type.getUseHighlevelTool()) {
            return GccLibrarian.getInstance();
        }
        if (type.isStaticLibrary()) {
            return arLinker;
        }
        if (type.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    @Override
    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        try {
            LdLinker clone = (LdLinker)this.clone();
            LinkerParam param = config.getParam("target");
            if (param != null) {
                clone.setCommand(param.getValue() + "-" + this.getCommand());
            }
            clone.superlink(task, outputFile, sourceFiles, config);
        }
        catch (CloneNotSupportedException e) {
            this.superlink(task, outputFile, sourceFiles, config);
        }
    }

    private void superlink(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) throws BuildException {
        super.link(task, outputFile, sourceFiles, config);
    }
}

