/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.ide;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.TargetInfo;
import net.sf.antcontrib.cpptasks.ide.CommentDef;
import net.sf.antcontrib.cpptasks.ide.DependencyDef;
import net.sf.antcontrib.cpptasks.ide.ProjectWriter;
import net.sf.antcontrib.cpptasks.ide.ProjectWriterEnum;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;

public final class ProjectDef
extends DataType {
    private String ifProp;
    private String unlessProp;
    private File outFile;
    private String name;
    private boolean failOnError = true;
    private boolean overwrite = true;
    private ProjectWriter projectWriter;
    private File objDir;
    private List dependencies = new ArrayList();
    private List comments = new ArrayList();

    public void setType(ProjectWriterEnum value) {
        this.projectWriter = value.getProjectWriter();
    }

    public void setOutfile(File outfile) {
        if (outfile == null || outfile.toString().length() > 0) {
            this.outFile = outfile;
        }
    }

    public void setFailonerror(boolean value) {
        this.failOnError = value;
    }

    public void setOverwrite(boolean value) {
        this.overwrite = value;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public boolean isActive() {
        Project project = this.getProject();
        return CUtil.isActive(project, this.ifProp, this.unlessProp);
    }

    public void setClassname(String className) {
        Object proc = null;
        try {
            Class<?> implClass = ProjectDef.class.getClassLoader().loadClass(className);
            try {
                Method getInstance = implClass.getMethod("getInstance", new Class[0]);
                proc = getInstance.invoke(null, new Object[0]);
            }
            catch (Exception ex) {
                proc = implClass.newInstance();
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
        this.projectWriter = (ProjectWriter)proc;
    }

    public void setIf(String propName) {
        this.ifProp = propName;
    }

    public void setUnless(String propName) {
        this.unlessProp = propName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public void execute(CCTask task, List sources, Hashtable targets, TargetInfo linkTarget) {
        try {
            this.projectWriter.writeProject(this.outFile, task, this, sources, targets, linkTarget);
        }
        catch (BuildException ex) {
            if (this.failOnError) {
                throw ex;
            }
            task.log(ex.toString());
        }
        catch (Exception ex) {
            if (this.failOnError) {
                throw new BuildException((Throwable)ex);
            }
            task.log(ex.toString());
        }
    }

    public File getObjdir() {
        return this.objDir;
    }

    public void getObjdir(File oDir) {
        this.objDir = oDir;
    }

    public void addDependency(DependencyDef dependency) {
        this.dependencies.add(dependency);
    }

    public List getDependencies() {
        return new ArrayList(this.dependencies);
    }

    public void addComment(CommentDef comment) {
        this.comments.add(comment);
    }

    public List getComments() {
        return new ArrayList(this.comments);
    }

    public void execute() {
        throw new BuildException("Not an actual task, but looks like one for documentation purposes");
    }
}

