/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.openwatcom;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinkerConfiguration;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.openwatcom.OpenWatcomCLinker;
import net.sf.antcontrib.cpptasks.openwatcom.OpenWatcomProcessor;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public final class OpenWatcomLibrarian
extends CommandLineLinker {
    private static final OpenWatcomLibrarian INSTANCE = new OpenWatcomLibrarian();

    public static OpenWatcomLibrarian getInstance() {
        return INSTANCE;
    }

    private OpenWatcomLibrarian() {
        super("wlib", null, new String[]{".obj"}, new String[0], ".lib", false, false, null);
    }

    @Override
    protected void addBase(long base, Vector args) {
    }

    @Override
    protected void addEntry(String entry, Vector args) {
    }

    @Override
    protected void addFixed(Boolean fixed, Vector args) {
    }

    @Override
    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
    }

    @Override
    protected void addIncremental(boolean incremental, Vector args) {
    }

    @Override
    protected void addMap(boolean map, Vector args) {
    }

    @Override
    protected void addStack(int stack, Vector args) {
    }

    @Override
    protected String getCommandFileSwitch(String cmdFile) {
        return OpenWatcomProcessor.getCommandFileSwitch(cmdFile);
    }

    @Override
    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return OpenWatcomProcessor.getLibraryPatterns(libnames, libType);
    }

    @Override
    public Linker getLinker(LinkType type) {
        return OpenWatcomCLinker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    public String[] getOutputFileSwitch(String outFile) {
        return OpenWatcomProcessor.getOutputFileSwitch(outFile);
    }

    @Override
    public boolean isCaseSensitive() {
        return OpenWatcomProcessor.isCaseSensitive();
    }

    @Override
    public void link(CCTask task, File outputFile, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        outputFile.delete();
        super.link(task, outputFile, sourceFiles, config);
    }

    @Override
    protected String[] prepareArguments(CCTask task, String outputDir, String outputName, String[] sourceFiles, CommandLineLinkerConfiguration config) {
        int i;
        String[] preargs = config.getPreArguments();
        String[] endargs = config.getEndArguments();
        StringBuffer buf = new StringBuffer();
        Vector<String> execArgs = new Vector<String>(preargs.length + endargs.length + 10 + sourceFiles.length);
        execArgs.addElement(this.getCommand());
        String outputFileName = new File(outputDir, outputName).toString();
        execArgs.addElement(this.quoteFilename(buf, outputFileName));
        for (int i2 = 0; i2 < preargs.length; ++i2) {
            execArgs.addElement(preargs[i2]);
        }
        int objBytes = 0;
        for (i = 0; i < sourceFiles.length; ++i) {
            String last4 = sourceFiles[i].substring(sourceFiles[i].length() - 4).toLowerCase();
            if (last4.equals(".def") || last4.equals(".res") || last4.equals(".lib")) continue;
            execArgs.addElement("+" + this.quoteFilename(buf, sourceFiles[i]));
            objBytes = (int)((long)objBytes + new File(sourceFiles[i]).length());
        }
        for (i = 0; i < endargs.length; ++i) {
            execArgs.addElement(endargs[i]);
        }
        Object[] execArguments = new String[execArgs.size()];
        execArgs.copyInto(execArguments);
        return execArguments;
    }
}

