/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.openwatcom;

import java.io.File;
import java.io.IOException;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.TargetMatcher;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.openwatcom.OpenWatcomProcessor;
import net.sf.antcontrib.cpptasks.platforms.WindowsPlatform;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public abstract class OpenWatcomLinker
extends CommandLineLinker {
    protected OpenWatcomLinker(String command, String outputSuffix) {
        super(command, "-r", new String[]{".obj", ".lib", ".res"}, new String[]{".map", ".pdb", ".lnk"}, outputSuffix, false, false, null);
    }

    @Override
    protected final void addBase(long base, Vector args) {
    }

    @Override
    protected final void addEntry(String entry, Vector args) {
    }

    @Override
    protected final void addFixed(Boolean fixed, Vector args) {
    }

    @Override
    protected final void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (linkType.isExecutable()) {
            if (linkType.isSubsystemConsole()) {
                args.addElement("/bc");
            } else if (linkType.isSubsystemGUI()) {
                args.addElement("/bg");
            }
        }
        if (linkType.isSharedLibrary()) {
            args.addElement("/bd");
        }
    }

    @Override
    protected final void addIncremental(boolean incremental, Vector args) {
    }

    @Override
    protected final void addMap(boolean map, Vector args) {
        if (map) {
            args.addElement("/fm");
        }
    }

    @Override
    protected final void addStack(int stack, Vector args) {
        if (stack >= 0) {
            String stackStr = Integer.toString(stack);
            args.addElement("/k" + stackStr);
        }
    }

    @Override
    public final void addVersionFiles(VersionInfo versionInfo, LinkType linkType, File outputFile, boolean isDebug, File objDir, TargetMatcher matcher) throws IOException {
        WindowsPlatform.addVersionFiles(versionInfo, linkType, outputFile, isDebug, objDir, matcher);
    }

    @Override
    public final String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    @Override
    public final File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public final String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return OpenWatcomProcessor.getLibraryPatterns(libnames, libType);
    }

    @Override
    public final int getMaximumCommandLength() {
        return 1024;
    }

    @Override
    public final String[] getOutputFileSwitch(String outFile) {
        return OpenWatcomProcessor.getOutputFileSwitch(outFile);
    }

    @Override
    public final boolean isCaseSensitive() {
        return OpenWatcomProcessor.isCaseSensitive();
    }
}

