/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.os390;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.CompilerDef;
import net.sf.antcontrib.cpptasks.OptimizationEnum;
import net.sf.antcontrib.cpptasks.compiler.AbstractCompiler;
import net.sf.antcontrib.cpptasks.compiler.CommandLineCCompiler;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.compiler.Processor;
import net.sf.antcontrib.cpptasks.os390.OS390Linker;
import net.sf.antcontrib.cpptasks.os390.OS390Processor;
import net.sf.antcontrib.cpptasks.types.DefineArgument;
import net.sf.antcontrib.cpptasks.types.UndefineArgument;
import org.apache.tools.ant.types.Environment;

public class OS390CCompiler
extends CommandLineCCompiler {
    private static final AbstractCompiler instance = new OS390CCompiler(false, null);

    public static AbstractCompiler getInstance() {
        return instance;
    }

    private OS390CCompiler(boolean newEnvironment, Environment env) {
        super("cxx", null, new String[]{".c", ".cc", ".cpp", ".cxx", ".c++", ".s"}, new String[]{".h", ".hpp"}, ".o", false, false, null, newEnvironment, env);
    }

    @Override
    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-c");
        args.addElement("-W");
        args.addElement("c,NOEXPMAC,NOSHOWINC");
        if (debug) {
            args.addElement("-g");
            args.addElement("-D");
            args.addElement("_DEBUG");
        } else {
            args.addElement("-D");
            args.addElement("NEBUG");
        }
    }

    @Override
    protected void addWarningSwitch(Vector args, int level) {
        OS390Processor.addWarningSwitch(args, level);
    }

    @Override
    protected void buildDefineArguments(CompilerDef[] defs, Vector args) {
        UndefineArgument[] merged = defs[0].getActiveDefines();
        for (int i = 1; i < defs.length; ++i) {
            merged = DefineArgument.merge(defs[i].getActiveDefines(), merged);
        }
        StringBuffer buf = new StringBuffer(30);
        for (int i = 0; i < merged.length; ++i) {
            buf.setLength(0);
            UndefineArgument current = merged[i];
            if (current.isDefine()) {
                args.addElement("-D");
                buf.append(current.getName());
                if (current.getValue() != null && current.getValue().length() > 0) {
                    buf.append('=');
                    buf.append(current.getValue());
                }
                args.addElement(buf.toString());
                continue;
            }
            args.addElement("-U");
            args.addElement(current.getName());
        }
    }

    @Override
    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new OS390CCompiler(newEnvironment, env);
        }
        return this;
    }

    @Override
    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
    }

    @Override
    protected File[] getEnvironmentIncludePath() {
        return CUtil.getPathFromEnvironment("INCLUDE", ":");
    }

    @Override
    protected String getIncludeDirSwitch(String includeDir) {
        return OS390Processor.getIncludeDirSwitch(includeDir);
    }

    @Override
    public Linker getLinker(LinkType type) {
        return OS390Linker.getInstance().getLinker(type);
    }

    @Override
    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected int getMaximumInputFilesPerCommand() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }
}

