/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.cpptasks.sun;

import java.io.File;
import java.util.Vector;
import net.sf.antcontrib.cpptasks.CCTask;
import net.sf.antcontrib.cpptasks.CUtil;
import net.sf.antcontrib.cpptasks.VersionInfo;
import net.sf.antcontrib.cpptasks.compiler.CommandLineLinker;
import net.sf.antcontrib.cpptasks.compiler.LinkType;
import net.sf.antcontrib.cpptasks.compiler.Linker;
import net.sf.antcontrib.cpptasks.sun.C89Processor;
import net.sf.antcontrib.cpptasks.types.LibrarySet;
import net.sf.antcontrib.cpptasks.types.LibraryTypeEnum;

public final class C89Linker
extends CommandLineLinker {
    private static final C89Linker dllLinker = new C89Linker("lib", ".so");
    private static final C89Linker instance = new C89Linker("", "");
    private final String outputPrefix;

    public static C89Linker getInstance() {
        return instance;
    }

    private C89Linker(String outputPrefix, String outputSuffix) {
        super("ld", "/bogus", new String[]{".o", ".a", ".lib", ".x"}, new String[0], outputSuffix, false, false, null);
        this.outputPrefix = outputPrefix;
    }

    @Override
    protected void addBase(long base, Vector args) {
    }

    @Override
    protected void addFixed(Boolean fixed, Vector args) {
    }

    @Override
    protected void addImpliedArgs(boolean debug, LinkType linkType, Vector args) {
        if (linkType.isSharedLibrary()) {
            args.addElement("-G");
        }
    }

    @Override
    protected void addIncremental(boolean incremental, Vector args) {
    }

    @Override
    public String[] addLibrarySets(CCTask task, LibrarySet[] libsets, Vector preargs, Vector midargs, Vector endargs) {
        super.addLibrarySets(task, libsets, preargs, midargs, endargs);
        StringBuffer buf = new StringBuffer("-l");
        for (int i = 0; i < libsets.length; ++i) {
            LibrarySet set = libsets[i];
            File libdir = set.getDir(null);
            String[] libs = set.getLibs();
            if (libdir != null) {
                endargs.addElement("-L");
                endargs.addElement(libdir.getAbsolutePath());
            }
            for (int j = 0; j < libs.length; ++j) {
                buf.setLength(2);
                buf.append(libs[j]);
                endargs.addElement(buf.toString());
            }
        }
        return null;
    }

    @Override
    protected void addMap(boolean map, Vector args) {
    }

    @Override
    protected void addStack(int stack, Vector args) {
    }

    @Override
    protected void addEntry(String entry, Vector args) {
    }

    @Override
    public String getCommandFileSwitch(String commandFile) {
        return "@" + commandFile;
    }

    @Override
    public File[] getLibraryPath() {
        return CUtil.getPathFromEnvironment("LIB", ";");
    }

    @Override
    public String[] getLibraryPatterns(String[] libnames, LibraryTypeEnum libType) {
        return C89Processor.getLibraryPatterns(libnames, libType);
    }

    @Override
    public Linker getLinker(LinkType linkType) {
        if (linkType.isSharedLibrary()) {
            return dllLinker;
        }
        return instance;
    }

    @Override
    public int getMaximumCommandLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public String getOutputFileName(String baseName, VersionInfo versionInfo) {
        return this.outputPrefix + super.getOutputFileName(baseName, versionInfo);
    }

    @Override
    public String[] getOutputFileSwitch(String outputFile) {
        return new String[]{"-o", outputFile};
    }

    @Override
    public boolean isCaseSensitive() {
        return C89Processor.isCaseSensitive();
    }
}

