/*
 * Decompiled with CFR 0.152.
 */
package japicmp.cmp;

import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiClassType;
import japicmp.util.ClassHelper;
import japicmp.util.ModifierHelper;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javassist.CtClass;

public class ClassesComparator {
    private List<JApiClass> classes = new LinkedList<JApiClass>();
    private final JarArchiveComparator jarArchiveComparator;
    private final JarArchiveComparatorOptions options;

    public ClassesComparator(JarArchiveComparator jarArchiveComparator, JarArchiveComparatorOptions options) {
        this.jarArchiveComparator = jarArchiveComparator;
        this.options = options;
    }

    public void compare(List<CtClass> oldClassesArg, List<CtClass> newClassesArg) {
        this.classes = new LinkedList<JApiClass>();
        Map<String, CtClass> oldClassesMap = this.createClassMap(oldClassesArg);
        Map<String, CtClass> newClassesMap = this.createClassMap(newClassesArg);
        this.sortIntoLists(oldClassesMap, newClassesMap);
    }

    private void sortIntoLists(Map<String, CtClass> oldClassesMap, Map<String, CtClass> newClassesMap) {
        for (CtClass oldCtClass : oldClassesMap.values()) {
            JApiClassType.ClassType newType;
            CtClass newCtClass = newClassesMap.get(oldCtClass.getName());
            if (newCtClass == null) {
                JApiClassType classType = new JApiClassType(Optional.of(ClassHelper.getType(oldCtClass)), Optional.empty(), JApiChangeStatus.REMOVED);
                JApiClass jApiClass = new JApiClass(this.jarArchiveComparator, oldCtClass.getName(), Optional.of(oldCtClass), Optional.empty(), JApiChangeStatus.REMOVED, classType);
                if (!this.includeClass(jApiClass)) continue;
                this.classes.add(jApiClass);
                continue;
            }
            JApiChangeStatus changeStatus = JApiChangeStatus.UNCHANGED;
            JApiClassType.ClassType oldType = ClassHelper.getType(oldCtClass);
            if (oldType != (newType = ClassHelper.getType(newCtClass))) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            JApiClassType classType = new JApiClassType(Optional.of(oldType), Optional.of(newType), changeStatus);
            JApiClass jApiClass = new JApiClass(this.jarArchiveComparator, oldCtClass.getName(), Optional.of(oldCtClass), Optional.of(newCtClass), changeStatus, classType);
            if (!this.includeClass(jApiClass)) continue;
            this.classes.add(jApiClass);
        }
        for (CtClass newCtClass : newClassesMap.values()) {
            CtClass oldCtClass = oldClassesMap.get(newCtClass.getName());
            if (oldCtClass != null) continue;
            JApiClassType.ClassType newType = ClassHelper.getType(newCtClass);
            JApiClassType classType = new JApiClassType(Optional.empty(), Optional.of(newType), JApiChangeStatus.NEW);
            JApiClass jApiClass = new JApiClass(this.jarArchiveComparator, newCtClass.getName(), Optional.empty(), Optional.of(newCtClass), JApiChangeStatus.NEW, classType);
            if (!this.includeClass(jApiClass)) continue;
            this.classes.add(jApiClass);
        }
    }

    private boolean includeClass(JApiClass jApiClass) {
        return ModifierHelper.matchesModifierLevel(jApiClass, this.options.getAccessModifier());
    }

    private Map<String, CtClass> createClassMap(List<CtClass> oldClassesArg) {
        HashMap<String, CtClass> oldClassesMap = new HashMap<String, CtClass>();
        for (CtClass ctClass : oldClassesArg) {
            oldClassesMap.put(ctClass.getName(), ctClass);
        }
        return oldClassesMap;
    }

    public List<JApiClass> getClasses() {
        return this.classes;
    }
}

