/*
 * Decompiled with CFR 0.152.
 */
package japicmp.cmp;

import japicmp.cmp.ClassesComparator;
import japicmp.cmp.JApiCmpArchive;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.cmp.ReducibleClassPool;
import japicmp.compat.CompatibilityChanges;
import japicmp.exception.JApiCmpException;
import japicmp.filter.AnnotationFilterBase;
import japicmp.filter.Filter;
import japicmp.filter.Filters;
import japicmp.filter.JavadocLikePackageFilter;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibilityChangeType;
import japicmp.model.JavaObjectSerializationCompatibility;
import japicmp.output.OutputFilter;
import japicmp.util.AnnotationHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class JarArchiveComparator {
    private static final Logger LOGGER = Logger.getLogger(JarArchiveComparator.class.getName());
    private ReducibleClassPool commonClassPool;
    private ReducibleClassPool oldClassPool;
    private ReducibleClassPool newClassPool;
    private String commonClassPathAsString = "";
    private String oldClassPathAsString = "";
    private String newClassPathAsString = "";
    private final JarArchiveComparatorOptions options;

    public JarArchiveComparator(JarArchiveComparatorOptions options) {
        this.options = options;
        this.setupClasspaths();
        this.setupCompatibilityChanges(options);
    }

    private void setupCompatibilityChanges(JarArchiveComparatorOptions options) {
        for (JApiCompatibilityChangeType jApiCompatibility : JApiCompatibilityChangeType.values()) {
            jApiCompatibility.resetOverrides();
        }
        for (JarArchiveComparatorOptions.OverrideCompatibilityChange change : options.getOverrideCompatibilityChanges()) {
            JApiCompatibilityChangeType compatibilityChange = change.getCompatibilityChange();
            for (JApiCompatibilityChangeType jApiCompatibility : JApiCompatibilityChangeType.values()) {
                if (jApiCompatibility != compatibilityChange) continue;
                jApiCompatibility.setBinaryCompatible(change.isBinaryCompatible());
                jApiCompatibility.setSourceCompatible(change.isSourceCompatible());
                jApiCompatibility.setSemanticVersionLevel(change.getSemanticVersionLevel());
            }
        }
    }

    public List<JApiClass> compare(JApiCmpArchive oldArchive, JApiCmpArchive newArchive) {
        return this.compare(Collections.singletonList(oldArchive), Collections.singletonList(newArchive));
    }

    public List<JApiClass> compare(List<JApiCmpArchive> oldArchives, List<JApiCmpArchive> newArchives) {
        return this.createAndCompareClassLists(oldArchives, newArchives);
    }

    private void checkJavaObjectSerializationCompatibility(List<JApiClass> jApiClasses) {
        JavaObjectSerializationCompatibility javaObjectSerializationCompatibility = new JavaObjectSerializationCompatibility();
        javaObjectSerializationCompatibility.evaluate(jApiClasses);
    }

    private void setupClasspaths() {
        if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH) {
            this.commonClassPool = new ReducibleClassPool();
            this.commonClassPathAsString = this.setupClasspath(this.commonClassPool, this.options.getClassPathEntries());
        } else if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS) {
            this.oldClassPool = new ReducibleClassPool();
            this.oldClassPathAsString = this.setupClasspath(this.oldClassPool, this.options.getOldClassPath());
            this.newClassPool = new ReducibleClassPool();
            this.newClassPathAsString = this.setupClasspath(this.newClassPool, this.options.getNewClassPath());
        } else {
            throw new JApiCmpException(JApiCmpException.Reason.IllegalState, "Unknown classpath mode: " + (Object)((Object)this.options.getClassPathMode()));
        }
    }

    private String setupClasspath(ClassPool classPool, List<String> classPathEntries) {
        String classPathAsString = this.appendUserDefinedClassPathEntries(classPool, classPathEntries);
        return this.appendSystemClassPath(classPool, classPathAsString);
    }

    private String appendSystemClassPath(ClassPool classPool, String classPathAsString) {
        String retVal = classPathAsString;
        classPool.appendSystemPath();
        if (!retVal.isEmpty() && !retVal.endsWith(File.pathSeparator)) {
            retVal = retVal + File.pathSeparator;
        }
        return retVal;
    }

    private String appendUserDefinedClassPathEntries(ClassPool classPool, List<String> classPathEntries) {
        StringBuilder classPathAsString = new StringBuilder();
        for (String classPathEntry : classPathEntries) {
            try {
                classPool.appendClassPath(classPathEntry);
                if (!classPathAsString.toString().endsWith(File.pathSeparator)) {
                    classPathAsString.append(File.pathSeparator);
                }
                classPathAsString.append(classPathEntry);
            }
            catch (NotFoundException e) {
                throw JApiCmpException.forClassLoading(e, classPathEntry, this);
            }
        }
        return classPathAsString.toString();
    }

    public String getCommonClasspathAsString() {
        return this.commonClassPathAsString;
    }

    public String getOldClassPathAsString() {
        return this.oldClassPathAsString;
    }

    public String getNewClassPathAsString() {
        return this.newClassPathAsString;
    }

    private void checkBinaryCompatibility(List<JApiClass> classList) {
        CompatibilityChanges compatibilityChanges = new CompatibilityChanges(this);
        compatibilityChanges.evaluate(classList);
    }

    private List<JApiClass> createAndCompareClassLists(List<JApiCmpArchive> oldArchives, List<JApiCmpArchive> newArchives) {
        if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH) {
            List<CtClass> oldClasses = this.createListOfCtClasses(oldArchives, this.commonClassPool);
            List<CtClass> newClasses = this.createListOfCtClasses(newArchives, this.commonClassPool);
            return this.compareClassLists(this.options, oldClasses, newClasses);
        }
        if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS) {
            List<CtClass> oldClasses = this.createListOfCtClasses(oldArchives, this.oldClassPool);
            List<CtClass> newClasses = this.createListOfCtClasses(newArchives, this.newClassPool);
            return this.compareClassLists(this.options, oldClasses, newClasses);
        }
        throw new JApiCmpException(JApiCmpException.Reason.IllegalState, "Unknown classpath mode: " + (Object)((Object)this.options.getClassPathMode()));
    }

    List<JApiClass> compareClassLists(JarArchiveComparatorOptions options, List<CtClass> oldClasses, List<CtClass> newClasses) {
        ClassesComparator classesComparator = new ClassesComparator(this, options);
        classesComparator.compare(oldClasses, newClasses);
        List<JApiClass> classList = classesComparator.getClasses();
        if (LOGGER.isLoggable(Level.FINE)) {
            for (JApiClass jApiClass : classList) {
                LOGGER.fine(jApiClass.toString());
            }
        }
        this.checkBinaryCompatibility(classList);
        this.checkJavaObjectSerializationCompatibility(classList);
        OutputFilter.sortClassesAndMethods(classList);
        return classList;
    }

    private List<CtClass> createListOfCtClasses(List<JApiCmpArchive> archives, ReducibleClassPool classPool) {
        List<CtClass> ctClasses = archives.stream().flatMap(archive -> this.toCtClassStream((JApiCmpArchive)archive, classPool)).collect(Collectors.toList());
        ctClasses = this.filterClasses(ctClasses, classPool, false);
        return ctClasses;
    }

    private Stream<CtClass> toCtClassStream(JApiCmpArchive archive, ReducibleClassPool classPool) {
        if (archive.getFile() != null) {
            Stream<CtClass> stream;
            JarFile jarFile = new JarFile(archive.getFile());
            try {
                stream = jarFile.stream().map(jarEntry -> this.ctClass(classPool, jarFile, (JarEntry)jarEntry)).filter(Objects::nonNull).collect(Collectors.toList()).stream();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JApiCmpException(JApiCmpException.Reason.IoException, "Failed to load archive from file: " + e.getMessage(), e);
                }
            }
            jarFile.close();
            return stream;
        }
        if (archive.getBytes() != null) {
            return JarArchiveComparator.bytesToCtClasses(archive, classPool);
        }
        throw new JApiCmpException(JApiCmpException.Reason.IllegalArgument, JApiCmpArchive.class.getSimpleName() + " has no file and no bytes: " + archive);
    }

    private static Stream<CtClass> bytesToCtClasses(JApiCmpArchive archive, ReducibleClassPool classPool) {
        ArrayList<CtClass> ctClasses = new ArrayList<CtClass>();
        try (JarInputStream jarInputStream = new JarInputStream(new ByteArrayInputStream(archive.getBytes()));){
            JarEntry nextJarEntry = jarInputStream.getNextJarEntry();
            while (nextJarEntry != null) {
                if (!nextJarEntry.isDirectory() && nextJarEntry.getName().endsWith(".class")) {
                    byte[] byteArray = JarArchiveComparator.getJarEntryContent(jarInputStream);
                    CtClass ctClass = classPool.makeClass(new ByteArrayInputStream(byteArray));
                    ctClasses.add(ctClass);
                }
                nextJarEntry = jarInputStream.getNextJarEntry();
            }
        }
        catch (IOException e) {
            throw new JApiCmpException(JApiCmpException.Reason.IoException, "Failed to load archive from byte array: " + e.getMessage(), e);
        }
        return ctClasses.stream();
    }

    private static byte[] getJarEntryContent(JarInputStream jarInputStream) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((len = jarInputStream.read(buffer)) > 0) {
            baos.write(buffer, 0, len);
        }
        return baos.toByteArray();
    }

    private CtClass ctClass(ClassPool classPool, JarFile jarFile, JarEntry jarEntry) {
        String name = jarEntry.getName();
        if (name.endsWith(".class")) {
            CtClass ctClass;
            try (InputStream classFile = jarFile.getInputStream(jarEntry);){
                ctClass = classPool.makeClass(classFile);
            }
            catch (Exception e) {
                throw new JApiCmpException(JApiCmpException.Reason.IoException, String.format("Failed to load file from jar '%s' as class file: %s.", name, e.getMessage()), e);
            }
            return ctClass;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Skipping file '%s' because filename does not end with '.class'.", name));
        }
        return null;
    }

    public List<CtClass> filterClasses(List<CtClass> ctClasses, ReducibleClassPool classPool, boolean ignorePackageFilters) {
        boolean packageFilterEncountered = false;
        LinkedList<CtClass> classes = new LinkedList<CtClass>();
        for (CtClass ctClass : ctClasses) {
            if (!packageFilterEncountered) {
                if (this.options.getFilters().includeClass(ctClass)) {
                    classes.add(ctClass);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Adding class '%s' with jar name '%s' to list.", ctClass.getName(), ctClass.getName()));
                    }
                } else {
                    classPool.remove(ctClass);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(String.format("Ignoring class '%s' with jar name '%s'.", ctClass.getName(), ctClass.getName()));
                    }
                }
            }
            if (ignorePackageFilters || !ctClass.getName().endsWith("package-info") || !(packageFilterEncountered |= this.updatePackageFilter(ctClass))) continue;
            classes.forEach(classPool::remove);
            classes.clear();
        }
        return packageFilterEncountered ? this.filterClasses(ctClasses, classPool, true) : classes;
    }

    private boolean updatePackageFilter(CtClass ctClass) {
        String className;
        boolean filtersUpdated = false;
        Filters filters = this.options.getFilters();
        LinkedList<JavadocLikePackageFilter> newFilters = new LinkedList<JavadocLikePackageFilter>();
        for (Filter filter : filters.getIncludes()) {
            if (!(filter instanceof AnnotationFilterBase)) continue;
            className = ((AnnotationFilterBase)((Object)filter)).getClassName();
            if (!AnnotationHelper.hasAnnotation(ctClass.getClassFile(), className)) continue;
            newFilters.add(new JavadocLikePackageFilter(ctClass.getPackageName(), false));
        }
        if (!newFilters.isEmpty()) {
            filters.getIncludes().addAll(newFilters);
            newFilters.clear();
            filtersUpdated = true;
        }
        for (Filter filter : filters.getExcludes()) {
            if (!(filter instanceof AnnotationFilterBase)) continue;
            className = ((AnnotationFilterBase)((Object)filter)).getClassName();
            if (!AnnotationHelper.hasAnnotation(ctClass.getClassFile(), className)) continue;
            newFilters.add(new JavadocLikePackageFilter(ctClass.getPackageName(), false));
        }
        if (!newFilters.isEmpty()) {
            filters.getExcludes().addAll(newFilters);
            newFilters.clear();
            filtersUpdated = true;
        }
        return filtersUpdated;
    }

    public JarArchiveComparatorOptions getJarArchiveComparatorOptions() {
        return this.options;
    }

    public ReducibleClassPool getCommonClassPool() {
        return this.commonClassPool;
    }

    public ClassPool getOldClassPool() {
        return this.oldClassPool;
    }

    public ClassPool getNewClassPool() {
        return this.newClassPool;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Optional<CtClass> loadClass(ArchiveType archiveType, String name) {
        Optional<CtClass> loadedClass = Optional.empty();
        if (this.options.getClassPathMode() == JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH) {
            try {
                return Optional.of(this.commonClassPool.get(name));
            }
            catch (NotFoundException e) {
                if (this.options.getIgnoreMissingClasses().ignoreClass(e.getMessage())) return loadedClass;
                throw JApiCmpException.forClassLoading(e, name, this);
            }
        }
        if (this.options.getClassPathMode() != JarArchiveComparatorOptions.ClassPathMode.TWO_SEPARATE_CLASSPATHS) throw new JApiCmpException(JApiCmpException.Reason.IllegalState, "Unknown classpath mode: " + (Object)((Object)this.options.getClassPathMode()));
        if (archiveType == ArchiveType.OLD) {
            try {
                return Optional.of(this.oldClassPool.get(name));
            }
            catch (NotFoundException e) {
                if (this.options.getIgnoreMissingClasses().ignoreClass(e.getMessage())) return loadedClass;
                throw JApiCmpException.forClassLoading(e, name, this);
            }
        }
        if (archiveType != ArchiveType.NEW) throw new JApiCmpException(JApiCmpException.Reason.IllegalState, "Unknown archive type: " + (Object)((Object)archiveType));
        try {
            return Optional.of(this.newClassPool.get(name));
        }
        catch (NotFoundException e) {
            if (this.options.getIgnoreMissingClasses().ignoreClass(e.getMessage())) return loadedClass;
            throw JApiCmpException.forClassLoading(e, name, this);
        }
    }

    public static enum ArchiveType {
        OLD,
        NEW;

    }
}

