/*
 * Decompiled with CFR 0.152.
 */
package japicmp.compat;

import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.cmp.ReducibleClassPool;
import japicmp.exception.JApiCmpException;
import japicmp.model.AbstractModifier;
import japicmp.model.AccessModifier;
import japicmp.model.FinalModifier;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiAnnotationElement;
import japicmp.model.JApiBehavior;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiClassType;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiCompatibilityChangeType;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiException;
import japicmp.model.JApiField;
import japicmp.model.JApiGenericTemplate;
import japicmp.model.JApiHasAbstractModifier;
import japicmp.model.JApiHasAnnotations;
import japicmp.model.JApiHasGenericTemplates;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiMethod;
import japicmp.model.JApiModifier;
import japicmp.model.JApiParameter;
import japicmp.model.JApiSuperclass;
import japicmp.model.JApiType;
import japicmp.model.StaticModifier;
import japicmp.model.TransientModifier;
import japicmp.model.VarargsModifier;
import japicmp.model.VolatileModifier;
import japicmp.util.ClassHelper;
import japicmp.util.ModifierHelper;
import japicmp.util.SignatureParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class CompatibilityChanges {
    private final JarArchiveComparator jarArchiveComparator;

    public CompatibilityChanges(JarArchiveComparator jarArchiveComparator) {
        this.jarArchiveComparator = jarArchiveComparator;
    }

    public void evaluate(List<JApiClass> classes) {
        Map<String, JApiClass> classMap = this.buildClassMap(classes);
        for (JApiClass clazz : classes) {
            this.evaluateBinaryCompatibility(clazz, classMap);
        }
    }

    private Map<String, JApiClass> buildClassMap(List<JApiClass> classes) {
        HashMap<String, JApiClass> classMap = new HashMap<String, JApiClass>();
        for (JApiClass clazz : classes) {
            classMap.put(clazz.getFullyQualifiedName(), clazz);
        }
        return classMap;
    }

    private void evaluateBinaryCompatibility(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        if (jApiClass.getAccessModifier().hasChangedTo(AccessModifier.PUBLIC)) {
            return;
        }
        if (jApiClass.getChangeStatus() == JApiChangeStatus.REMOVED) {
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.CLASS_REMOVED);
        } else if (jApiClass.getChangeStatus() == JApiChangeStatus.MODIFIED) {
            if (jApiClass.getAbstractModifier().hasChangedFromTo(AbstractModifier.NON_ABSTRACT, AbstractModifier.ABSTRACT)) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.CLASS_NOW_ABSTRACT);
            }
            if (jApiClass.getFinalModifier().hasChangedFromTo(FinalModifier.NON_FINAL, FinalModifier.FINAL)) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.CLASS_NOW_FINAL);
            }
            if (jApiClass.getAccessModifier().hasChangedFrom(AccessModifier.PUBLIC)) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.CLASS_NO_LONGER_PUBLIC);
            }
        }
        this.checkIfSuperclassesOrInterfacesChangedIncompatible(jApiClass, classMap);
        this.checkIfMethodsHaveChangedIncompatible(jApiClass, classMap);
        this.checkIfConstructorsHaveChangedIncompatible(jApiClass, classMap);
        this.checkIfFieldsHaveChangedIncompatible(jApiClass, classMap);
        if (jApiClass.getClassType().getChangeStatus() == JApiChangeStatus.MODIFIED) {
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.CLASS_TYPE_CHANGED);
        }
        this.checkIfAnnotationsChanged(jApiClass, classMap);
        if (ModifierHelper.hasModifierLevelDecreased(jApiClass)) {
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.CLASS_LESS_ACCESSIBLE);
        }
        if (jApiClass.getChangeStatus().isNotNewOrRemoved()) {
            this.checkIfGenericTemplatesHaveChanged(jApiClass);
        }
    }

    private void checkIfGenericTemplatesHaveChanged(JApiHasGenericTemplates jApiHasGenericTemplates) {
        for (JApiGenericTemplate jApiGenericTemplate : jApiHasGenericTemplates.getGenericTemplates()) {
            if (jApiGenericTemplate.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
            this.addCompatibilityChange(jApiHasGenericTemplates, JApiCompatibilityChangeType.CLASS_GENERIC_TEMPLATE_CHANGED);
            break;
        }
        for (JApiGenericTemplate jApiGenericTemplate : jApiHasGenericTemplates.getGenericTemplates()) {
            JApiChangeStatus changeStatus = jApiGenericTemplate.getChangeStatus();
            if (changeStatus != JApiChangeStatus.MODIFIED && changeStatus != JApiChangeStatus.UNCHANGED || SignatureParser.equalGenericTypes(jApiGenericTemplate.getOldGenericTypes(), jApiGenericTemplate.getNewGenericTypes())) continue;
            this.addCompatibilityChange(jApiGenericTemplate, JApiCompatibilityChangeType.CLASS_GENERIC_TEMPLATE_GENERICS_CHANGED);
            this.addCompatibilityChange(jApiHasGenericTemplates, JApiCompatibilityChangeType.CLASS_GENERIC_TEMPLATE_GENERICS_CHANGED);
            break;
        }
    }

    private void checkIfFieldsHaveChangedIncompatible(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        for (JApiField field : jApiClass.getFields()) {
            ArrayList returnValues;
            if (field.getVolatileModifier().hasChangedFromTo(VolatileModifier.NON_VOLATILE, VolatileModifier.VOLATILE)) {
                this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_NOW_VOLATILE);
            }
            if (field.getVolatileModifier().hasChangedFromTo(VolatileModifier.VOLATILE, VolatileModifier.NON_VOLATILE)) {
                this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_NO_LONGER_VOLATILE);
            }
            if (ModifierHelper.isNotPrivate(field) && field.getChangeStatus() == JApiChangeStatus.REMOVED) {
                returnValues = new ArrayList();
                this.forAllSuperclasses(jApiClass, classMap, returnValues, (superclass, classMap1, changeStatusOfSuperclass) -> {
                    int movedToSuperclass = 0;
                    for (JApiField superclassField : superclass.getFields()) {
                        if (!superclassField.getName().equals(field.getName()) || !this.fieldTypeMatches(superclassField, field) || !ModifierHelper.isNotPrivate(superclassField)) continue;
                        movedToSuperclass = 1;
                    }
                    return movedToSuperclass;
                });
                boolean movedToSuperclass = false;
                for (Integer returnValue : returnValues) {
                    if (returnValue != 1) continue;
                    movedToSuperclass = true;
                    break;
                }
                if (!movedToSuperclass) {
                    this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_REMOVED);
                }
            }
            if (ModifierHelper.hasModifierLevelDecreased(field)) {
                this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_LESS_ACCESSIBLE);
            }
            if (ModifierHelper.isNotPrivate(field) && field.getChangeStatus() == JApiChangeStatus.NEW) {
                returnValues = new ArrayList();
                this.forAllSuperclasses(jApiClass, classMap, returnValues, (superclass, classMap12, changeStatusOfSuperclass) -> {
                    int changedIncompatible = 0;
                    for (JApiField superclassField : superclass.getFields()) {
                        if (!superclassField.getName().equals(field.getName()) || !this.fieldTypeMatches(superclassField, field)) continue;
                        boolean superclassFieldIsStatic = false;
                        boolean subclassFieldIsStatic = false;
                        boolean accessModifierSubclassLess = false;
                        if (field.getStaticModifier().getNewModifier().isPresent() && field.getStaticModifier().getNewModifier().get() == StaticModifier.STATIC) {
                            subclassFieldIsStatic = true;
                        }
                        if (superclassField.getStaticModifier().getNewModifier().isPresent() && superclassField.getStaticModifier().getNewModifier().get() == StaticModifier.STATIC && superclassField.getChangeStatus() != JApiChangeStatus.NEW) {
                            superclassFieldIsStatic = true;
                        }
                        if (field.getAccessModifier().getNewModifier().isPresent() && superclassField.getAccessModifier().getNewModifier().isPresent() && field.getAccessModifier().getNewModifier().get().getLevel() < superclassField.getAccessModifier().getNewModifier().get().getLevel() && superclassField.getChangeStatus() != JApiChangeStatus.NEW) {
                            accessModifierSubclassLess = true;
                        }
                        if (superclassFieldIsStatic && subclassFieldIsStatic) {
                            changedIncompatible = 1;
                        }
                        if (!accessModifierSubclassLess) continue;
                        changedIncompatible = 2;
                    }
                    return changedIncompatible;
                });
                Iterator iterator = returnValues.iterator();
                while (iterator.hasNext()) {
                    int returnValue = (Integer)iterator.next();
                    if (returnValue == 1) {
                        this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_STATIC_AND_OVERRIDES_STATIC);
                        continue;
                    }
                    if (returnValue != 2) continue;
                    this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_LESS_ACCESSIBLE_THAN_IN_SUPERCLASS);
                }
            }
            if (ModifierHelper.isNotPrivate(field) && field.getFinalModifier().hasChangedFromTo(FinalModifier.NON_FINAL, FinalModifier.FINAL)) {
                this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_NOW_FINAL);
            }
            if (ModifierHelper.isNotPrivate(field)) {
                if (field.getStaticModifier().hasChangedFromTo(StaticModifier.NON_STATIC, StaticModifier.STATIC)) {
                    this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_NOW_STATIC);
                }
                if (field.getStaticModifier().hasChangedFromTo(StaticModifier.STATIC, StaticModifier.NON_STATIC)) {
                    this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_NO_LONGER_STATIC);
                }
            }
            if (field.getTransientModifier().hasChangedFromTo(TransientModifier.NON_TRANSIENT, TransientModifier.TRANSIENT)) {
                this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_NOW_TRANSIENT);
            }
            if (field.getTransientModifier().hasChangedFromTo(TransientModifier.TRANSIENT, TransientModifier.NON_TRANSIENT)) {
                this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_NO_LONGER_TRANSIENT);
            }
            if (ModifierHelper.isNotPrivate(field) && field.getType().hasChanged()) {
                this.addCompatibilityChange(field, JApiCompatibilityChangeType.FIELD_TYPE_CHANGED);
            }
            this.checkIfAnnotationsChanged(field, classMap);
            this.checkIfFieldGenericsChanged(field);
        }
    }

    private <T> void forAllSuperclasses(JApiClass jApiClass, Map<String, JApiClass> classMap, List<T> returnValues, OnSuperclassCallback<T> onSuperclassCallback) {
        JApiSuperclass superclass = jApiClass.getSuperclass();
        if (superclass.getNewSuperclassName().isPresent()) {
            String newSuperclassName = superclass.getNewSuperclassName().get();
            JApiClass foundClass = classMap.get(newSuperclassName);
            if (foundClass == null) {
                Optional<JApiClass> superclassJApiClassOptional = superclass.getJApiClass();
                if (superclassJApiClassOptional.isPresent()) {
                    foundClass = superclassJApiClassOptional.get();
                } else {
                    foundClass = this.loadClass(newSuperclassName, EnumSet.of(Classpath.NEW_CLASSPATH));
                    this.evaluate(Collections.singletonList(foundClass));
                }
                classMap.put(foundClass.getFullyQualifiedName(), foundClass);
            }
            superclass.setJApiClass(foundClass);
            T returnValue = onSuperclassCallback.callback(foundClass, classMap, superclass.getChangeStatus());
            returnValues.add(returnValue);
            this.forAllSuperclasses(foundClass, classMap, returnValues, onSuperclassCallback);
        }
    }

    private JApiClass loadClass(String newSuperclassName, EnumSet<Classpath> classpaths) {
        Optional<Object> oldClassOptional = Optional.empty();
        Optional<Object> newClassOptional = Optional.empty();
        JarArchiveComparatorOptions.ClassPathMode classPathMode = this.jarArchiveComparator.getJarArchiveComparatorOptions().getClassPathMode();
        if (classPathMode == JarArchiveComparatorOptions.ClassPathMode.ONE_COMMON_CLASSPATH) {
            ReducibleClassPool classPool = this.jarArchiveComparator.getCommonClassPool();
            try {
                oldClassOptional = Optional.of(classPool.get(newSuperclassName));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            try {
                newClassOptional = Optional.of(classPool.get(newSuperclassName));
            }
            catch (NotFoundException notFoundException) {}
        } else {
            if (classpaths.contains((Object)Classpath.OLD_CLASSPATH)) {
                ClassPool oldClassPool = this.jarArchiveComparator.getOldClassPool();
                try {
                    oldClassOptional = Optional.of(oldClassPool.get(newSuperclassName));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
            if (classpaths.contains((Object)Classpath.NEW_CLASSPATH)) {
                ClassPool newClassPool = this.jarArchiveComparator.getNewClassPool();
                try {
                    newClassOptional = Optional.of(newClassPool.get(newSuperclassName));
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
        if (!(oldClassOptional.isPresent() || newClassOptional.isPresent() || this.jarArchiveComparator.getJarArchiveComparatorOptions().getIgnoreMissingClasses().ignoreClass(newSuperclassName))) {
            throw JApiCmpException.forClassLoading(newSuperclassName, this.jarArchiveComparator);
        }
        JApiChangeStatus changeStatus = JApiChangeStatus.UNCHANGED;
        JApiClassType classType = oldClassOptional.isPresent() && newClassOptional.isPresent() ? new JApiClassType(Optional.of(ClassHelper.getType((CtClass)oldClassOptional.get())), Optional.of(ClassHelper.getType((CtClass)newClassOptional.get())), JApiChangeStatus.UNCHANGED) : (oldClassOptional.isPresent() && !newClassOptional.isPresent() ? new JApiClassType(Optional.of(ClassHelper.getType((CtClass)oldClassOptional.get())), Optional.empty(), JApiChangeStatus.REMOVED) : (!oldClassOptional.isPresent() && newClassOptional.isPresent() ? new JApiClassType(Optional.empty(), Optional.of(ClassHelper.getType((CtClass)newClassOptional.get())), JApiChangeStatus.NEW) : new JApiClassType(Optional.empty(), Optional.empty(), JApiChangeStatus.UNCHANGED)));
        JApiClass foundClass = new JApiClass(this.jarArchiveComparator, newSuperclassName, oldClassOptional, newClassOptional, changeStatus, classType);
        return foundClass;
    }

    private boolean fieldTypeMatches(JApiField field1, JApiField field2) {
        boolean matches = true;
        JApiType type1 = field1.getType();
        JApiType type2 = field2.getType();
        if (type1.getNewTypeOptional().isPresent() && type2.getNewTypeOptional().isPresent() && !type1.getNewTypeOptional().get().equals(type2.getNewTypeOptional().get())) {
            matches = false;
        }
        return matches;
    }

    private void checkIfConstructorsHaveChangedIncompatible(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        for (JApiConstructor constructor : jApiClass.getConstructors()) {
            if (ModifierHelper.isNotPrivate(constructor) && constructor.getChangeStatus() == JApiChangeStatus.REMOVED) {
                this.addCompatibilityChange(constructor, JApiCompatibilityChangeType.CONSTRUCTOR_REMOVED);
            }
            if (ModifierHelper.hasModifierLevelDecreased(constructor) && (CompatibilityChanges.isNotFinal(jApiClass) || constructor.getAccessModifier().hasChangedFrom(AccessModifier.PUBLIC))) {
                this.addCompatibilityChange(constructor, JApiCompatibilityChangeType.CONSTRUCTOR_LESS_ACCESSIBLE);
            }
            this.checkIfExceptionIsNowChecked(constructor);
            this.checkIfAnnotationsChanged(constructor, classMap);
            this.checkIfVarargsChanged(constructor);
            this.checkIfParametersGenericsChanged(constructor);
            if (!jApiClass.getChangeStatus().isNotNewOrRemoved()) continue;
            this.checkIfGenericTemplatesHaveChanged(constructor);
        }
    }

    private static boolean isNotFinal(JApiClass jApiClass) {
        return !jApiClass.getFinalModifier().getNewModifier().isPresent() || jApiClass.getFinalModifier().getNewModifier().get() != FinalModifier.FINAL;
    }

    private void checkIfMethodsHaveChangedIncompatible(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        for (JApiMethod method : jApiClass.getMethods()) {
            ArrayList<Integer> returnValues;
            if (ModifierHelper.isNotPrivate(method) && method.getChangeStatus() == JApiChangeStatus.REMOVED) {
                returnValues = new ArrayList<Integer>();
                this.forAllSuperclasses(jApiClass, classMap, returnValues, (superclass, classMap12, changeStatusOfSuperclass) -> {
                    for (JApiMethod superMethod : superclass.getMethods()) {
                        if (!superMethod.getName().equals(method.getName()) || !superMethod.hasSameSignature(method)) continue;
                        return 1;
                    }
                    return 0;
                });
                this.checkIfMethodHasBeenPulledUp(jApiClass, classMap, method, returnValues);
                boolean superclassHasSameMethod = false;
                for (Integer returnValue : returnValues) {
                    if (returnValue != 1) continue;
                    superclassHasSameMethod = true;
                    break;
                }
                if (!superclassHasSameMethod) {
                    this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_REMOVED);
                }
            }
            if (!this.isInterface(jApiClass) && method.getChangeStatus() == JApiChangeStatus.NEW && method.getAccessModifier().getNewModifier().get().getLevel() == AccessModifier.PUBLIC.getLevel()) {
                this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_ADDED_TO_PUBLIC_CLASS);
            }
            if (ModifierHelper.hasModifierLevelDecreased(method)) {
                this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_LESS_ACCESSIBLE);
            }
            if (ModifierHelper.isNotPrivate(method) && method.getChangeStatus() == JApiChangeStatus.NEW) {
                returnValues = new ArrayList();
                this.forAllSuperclasses(jApiClass, classMap, returnValues, (superclass, classMap13, changeStatusOfSuperclass) -> {
                    for (JApiMethod superMethod : superclass.getMethods()) {
                        if (!superMethod.getName().equals(method.getName()) || !superMethod.hasSameSignature(method)) continue;
                        if (superMethod.getAccessModifier().getNewModifier().isPresent() && method.getAccessModifier().getNewModifier().isPresent() && superMethod.getAccessModifier().getNewModifier().get().getLevel() > method.getAccessModifier().getNewModifier().get().getLevel()) {
                            return 1;
                        }
                        if (!superMethod.getStaticModifier().getNewModifier().isPresent() || !method.getStaticModifier().getNewModifier().isPresent() || superMethod.getStaticModifier().getNewModifier().get() != StaticModifier.NON_STATIC || method.getStaticModifier().getNewModifier().get() != StaticModifier.STATIC) continue;
                        return 2;
                    }
                    return 0;
                });
                for (Integer returnValue : returnValues) {
                    if (returnValue == 1) {
                        this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_LESS_ACCESSIBLE_THAN_IN_SUPERCLASS);
                        continue;
                    }
                    if (returnValue != 2) continue;
                    this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_IS_STATIC_AND_OVERRIDES_NOT_STATIC);
                }
            }
            this.checkIfReturnTypeChanged(method);
            if (ModifierHelper.isNotPrivate(method) && method.getAbstractModifier().hasChangedFromTo(AbstractModifier.NON_ABSTRACT, AbstractModifier.ABSTRACT)) {
                this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_NOW_ABSTRACT);
            }
            if (ModifierHelper.isNotPrivate(method) && method.getFinalModifier().hasChangedFromTo(FinalModifier.NON_FINAL, FinalModifier.FINAL) && jApiClass.getFinalModifier().getOldModifier().isPresent() && jApiClass.getFinalModifier().getOldModifier().get() != FinalModifier.FINAL && (!method.getStaticModifier().getOldModifier().isPresent() || method.getStaticModifier().getOldModifier().get() != StaticModifier.STATIC)) {
                this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_NOW_FINAL);
            }
            if (ModifierHelper.isNotPrivate(method) && method.getChangeStatus() == JApiChangeStatus.REMOVED) {
                returnValues = new ArrayList();
                this.forAllSuperclasses(jApiClass, classMap, returnValues, (superclass, classMap1, changeStatusOfSuperclass) -> {
                    for (JApiMethod superMethod : superclass.getMethods()) {
                        if (!CompatibilityChanges.areMatching(superMethod, method) || !method.getFinalModifier().getOldModifier().isPresent() || method.getFinalModifier().getOldModifier().get() != FinalModifier.NON_FINAL || !superMethod.getFinalModifier().getNewModifier().isPresent() || superMethod.getFinalModifier().getNewModifier().get() != FinalModifier.FINAL) continue;
                        this.addCompatibilityChange(superMethod, JApiCompatibilityChangeType.METHOD_NOW_FINAL);
                        return 1;
                    }
                    return 0;
                });
                if (returnValues.stream().anyMatch(value -> value == 1)) {
                    this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_NOW_FINAL);
                    this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_MOVED_TO_SUPERCLASS);
                }
            }
            if (ModifierHelper.isNotPrivate(method) && !this.isInterface(method.getjApiClass())) {
                if (method.getStaticModifier().hasChangedFromTo(StaticModifier.NON_STATIC, StaticModifier.STATIC)) {
                    this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_NOW_STATIC);
                }
                if (method.getStaticModifier().hasChangedFromTo(StaticModifier.STATIC, StaticModifier.NON_STATIC)) {
                    this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_NO_LONGER_STATIC);
                }
            }
            this.checkAbstractMethod(jApiClass, classMap, method);
            this.checkIfExceptionIsNowChecked(method);
            this.checkIfAnnotationsChanged(method, classMap);
            this.checkIfVarargsChanged(method);
            this.checkIfParametersGenericsChanged(method);
            if (!method.getChangeStatus().isNotNewOrRemoved()) continue;
            this.checkIfGenericTemplatesHaveChanged(method);
        }
    }

    private void checkIfReturnTypeChanged(JApiMethod method) {
        if (method.getReturnType().getChangeStatus() == JApiChangeStatus.MODIFIED) {
            JApiCompatibilityChange change = this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_RETURN_TYPE_CHANGED);
            if (method.getAccessModifier().hasChangedToMoreVisible()) {
                change.setSourceCompatible(true);
                change.setBinaryCompatible(true);
            }
        }
        if (!(method.getChangeStatus() != JApiChangeStatus.MODIFIED && method.getChangeStatus() != JApiChangeStatus.UNCHANGED || SignatureParser.equalGenericTypes(method.getReturnType().getOldGenericTypes(), method.getReturnType().getNewGenericTypes()))) {
            this.addCompatibilityChange(method.getReturnType(), JApiCompatibilityChangeType.METHOD_RETURN_TYPE_GENERICS_CHANGED);
        }
    }

    private void checkIfParametersGenericsChanged(JApiBehavior jApiBehavior) {
        if (jApiBehavior.getChangeStatus() == JApiChangeStatus.MODIFIED || jApiBehavior.getChangeStatus() == JApiChangeStatus.UNCHANGED) {
            for (JApiParameter jApiParameter : jApiBehavior.getParameters()) {
                if (SignatureParser.equalGenericTypes(jApiParameter.getOldGenericTypes(), jApiParameter.getNewGenericTypes())) continue;
                this.addCompatibilityChange(jApiParameter, JApiCompatibilityChangeType.METHOD_PARAMETER_GENERICS_CHANGED);
            }
        }
    }

    private void checkIfFieldGenericsChanged(JApiField jApiField) {
        if (!(jApiField.getChangeStatus() != JApiChangeStatus.MODIFIED && jApiField.getChangeStatus() != JApiChangeStatus.UNCHANGED || SignatureParser.equalGenericTypes(jApiField.getOldGenericTypes(), jApiField.getNewGenericTypes()))) {
            this.addCompatibilityChange(jApiField, JApiCompatibilityChangeType.FIELD_GENERICS_CHANGED);
        }
    }

    private void checkIfAnnotationsChanged(JApiHasAnnotations jApiHasAnnotations, Map<String, JApiClass> classMap) {
        boolean isNoAnnotations = this.jarArchiveComparator.getJarArchiveComparatorOptions().isNoAnnotations();
        if (!isNoAnnotations) {
            for (JApiAnnotation annotation : jApiHasAnnotations.getAnnotations()) {
                JApiChangeStatus status = annotation.getChangeStatus();
                if (status == JApiChangeStatus.REMOVED) {
                    this.addCompatibilityChange(jApiHasAnnotations, JApiCompatibilityChangeType.ANNOTATION_REMOVED);
                    continue;
                }
                boolean isDeprecated = annotation.getFullyQualifiedName().equals(Deprecated.class.getName());
                if (isDeprecated && status == JApiChangeStatus.NEW) {
                    this.addCompatibilityChange(jApiHasAnnotations, JApiCompatibilityChangeType.ANNOTATION_DEPRECATED_ADDED);
                    continue;
                }
                JApiClass annotationClass = classMap.computeIfAbsent(annotation.getFullyQualifiedName(), fqn -> this.loadClass((String)fqn, EnumSet.allOf(Classpath.class)));
                annotation.setJApiClass(annotationClass);
                if (status == JApiChangeStatus.NEW) {
                    this.addCompatibilityChange(jApiHasAnnotations, JApiCompatibilityChangeType.ANNOTATION_ADDED);
                    continue;
                }
                for (JApiAnnotationElement annotationElement : annotation.getElements()) {
                    if (annotationElement.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                    this.addCompatibilityChange(jApiHasAnnotations, JApiCompatibilityChangeType.ANNOTATION_MODIFIED);
                }
            }
        }
    }

    private void checkIfVarargsChanged(JApiBehavior behavior) {
        if (behavior.getVarargsModifier().hasChangedFromTo(VarargsModifier.VARARGS, VarargsModifier.NON_VARARGS)) {
            this.addCompatibilityChange(behavior, JApiCompatibilityChangeType.METHOD_NO_LONGER_VARARGS);
        }
        if (behavior.getVarargsModifier().hasChangedFromTo(VarargsModifier.NON_VARARGS, VarargsModifier.VARARGS)) {
            this.addCompatibilityChange(behavior, JApiCompatibilityChangeType.METHOD_NOW_VARARGS);
        }
    }

    private void checkAbstractMethod(JApiClass jApiClass, Map<String, JApiClass> classMap, JApiMethod method) {
        if (this.isInterface(jApiClass)) {
            if (jApiClass.getChangeStatus() != JApiChangeStatus.NEW) {
                if (method.getChangeStatus() == JApiChangeStatus.NEW && !ModifierHelper.isSynthetic(method)) {
                    List<JApiMethod> methodsWithSameSignature = this.getMethodsInImplementedInterfacesWithSameSignature(jApiClass, classMap, method);
                    if (methodsWithSameSignature.isEmpty()) {
                        if (method.getAbstractModifier().getNewModifier().get() == AbstractModifier.NON_ABSTRACT) {
                            if (method.getStaticModifier().getNewModifier().get() == StaticModifier.STATIC) {
                                this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_NEW_STATIC_ADDED_TO_INTERFACE);
                            } else {
                                this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_NEW_DEFAULT);
                            }
                        } else {
                            this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_ADDED_TO_INTERFACE);
                        }
                    } else {
                        boolean allNew = true;
                        for (JApiMethod jApiMethod : methodsWithSameSignature) {
                            if (jApiMethod.getChangeStatus() == JApiChangeStatus.NEW) continue;
                            allNew = false;
                            break;
                        }
                        if (allNew) {
                            this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_ADDED_TO_INTERFACE);
                        }
                    }
                } else if (method.getChangeStatus() == JApiChangeStatus.MODIFIED || method.getChangeStatus() == JApiChangeStatus.UNCHANGED) {
                    JApiModifier<StaticModifier> staticModifier;
                    JApiModifier<AbstractModifier> abstractModifier = method.getAbstractModifier();
                    if (abstractModifier.getOldModifier().isPresent() && abstractModifier.getOldModifier().get() == AbstractModifier.ABSTRACT && abstractModifier.getNewModifier().isPresent() && abstractModifier.getNewModifier().get() == AbstractModifier.NON_ABSTRACT) {
                        this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_ABSTRACT_NOW_DEFAULT);
                    }
                    if ((staticModifier = method.getStaticModifier()).hasChangedFromTo(StaticModifier.NON_STATIC, StaticModifier.STATIC)) {
                        this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_NON_STATIC_IN_INTERFACE_NOW_STATIC);
                    } else if (staticModifier.hasChangedFromTo(StaticModifier.STATIC, StaticModifier.NON_STATIC)) {
                        this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_STATIC_IN_INTERFACE_NO_LONGER_STATIC);
                    }
                }
            }
        } else if (this.isAbstract(method) && jApiClass.getChangeStatus() != JApiChangeStatus.NEW && method.getChangeStatus() == JApiChangeStatus.NEW && !ModifierHelper.isSynthetic(method)) {
            List<JApiMethod> overriddenMethods = this.getOverriddenMethods(jApiClass, classMap, method);
            boolean overridesAbstract = false;
            for (JApiMethod jApiMethod : overriddenMethods) {
                if (!this.isAbstract(jApiMethod) || jApiMethod.getChangeStatus() == JApiChangeStatus.NEW) continue;
                overridesAbstract = true;
            }
            List<JApiMethod> implementedMethods = this.getMethodsInImplementedInterfacesWithSameSignature(jApiClass, classMap, method);
            if (!implementedMethods.isEmpty()) {
                overridesAbstract = true;
            }
            if (!overridesAbstract) {
                this.addCompatibilityChange(method, JApiCompatibilityChangeType.METHOD_ABSTRACT_ADDED_TO_CLASS);
            }
        }
    }

    private List<JApiMethod> getOverriddenMethods(JApiClass jApiClass, Map<String, JApiClass> classMap, JApiMethod method) {
        ArrayList<JApiMethod> jApiMethods = new ArrayList<JApiMethod>();
        this.forAllSuperclasses(jApiClass, classMap, jApiMethods, (superclass, classMap1, changeStatusOfSuperclass) -> {
            for (JApiMethod jApiMethod : superclass.getMethods()) {
                if (!this.isAbstract(jApiMethod) || !jApiMethod.getName().equals(method.getName()) || !jApiMethod.hasSameSignature(method)) continue;
                return jApiMethod;
            }
            return null;
        });
        return this.removeNullValues(jApiMethods);
    }

    private List<JApiMethod> removeNullValues(ArrayList<JApiMethod> jApiMethods) {
        ArrayList<JApiMethod> returnValues = new ArrayList<JApiMethod>();
        for (JApiMethod jApiMethod : jApiMethods) {
            if (jApiMethod == null) continue;
            returnValues.add(jApiMethod);
        }
        return returnValues;
    }

    private List<JApiMethod> getMethodsInImplementedInterfacesWithSameSignature(JApiClass jApiClass, Map<String, JApiClass> classMap, JApiMethod method) {
        ArrayList<JApiMethod> jApiMethods = new ArrayList<JApiMethod>();
        this.forAllImplementedInterfaces(jApiClass, classMap, jApiMethods, new ArrayList<JApiImplementedInterface>(), (implementedInterface, classMap1) -> {
            for (JApiMethod jApiMethod : implementedInterface.getMethods()) {
                if (!jApiMethod.getName().equals(method.getName()) || !jApiMethod.hasSameSignature(method)) continue;
                return jApiMethod;
            }
            return null;
        });
        return this.removeNullValues(jApiMethods);
    }

    private boolean isAbstract(JApiHasAbstractModifier jApiHasAbstractModifier) {
        if (jApiHasAbstractModifier.getAbstractModifier().getNewModifier().isPresent()) {
            AbstractModifier abstractModifier = jApiHasAbstractModifier.getAbstractModifier().getNewModifier().get();
            return abstractModifier == AbstractModifier.ABSTRACT;
        }
        return false;
    }

    private void checkIfExceptionIsNowChecked(JApiBehavior behavior) {
        for (JApiException exception : behavior.getExceptions()) {
            if (exception.getChangeStatus() == JApiChangeStatus.NEW && exception.isCheckedException() && behavior.getChangeStatus() != JApiChangeStatus.NEW) {
                this.addCompatibilityChange(behavior, JApiCompatibilityChangeType.METHOD_NOW_THROWS_CHECKED_EXCEPTION);
            }
            if (exception.getChangeStatus() != JApiChangeStatus.REMOVED || !exception.isCheckedException() || behavior.getChangeStatus() == JApiChangeStatus.REMOVED) continue;
            this.addCompatibilityChange(behavior, JApiCompatibilityChangeType.METHOD_NO_LONGER_THROWS_CHECKED_EXCEPTION);
        }
    }

    private boolean isClass(JApiClass jApiClass) {
        return jApiClass.getClassType().getNewTypeOptional().isPresent() && jApiClass.getClassType().getNewTypeOptional().get() == JApiClassType.ClassType.CLASS;
    }

    private boolean isInterface(JApiClass jApiClass) {
        return jApiClass.getClassType().getNewTypeOptional().isPresent() && jApiClass.getClassType().getNewTypeOptional().get() == JApiClassType.ClassType.INTERFACE;
    }

    private boolean isAnnotation(JApiClass jApiClass) {
        return jApiClass.getClassType().getNewTypeOptional().isPresent() && jApiClass.getClassType().getNewTypeOptional().get() == JApiClassType.ClassType.ANNOTATION;
    }

    private boolean isEnum(JApiClass jApiClass) {
        return jApiClass.getClassType().getNewTypeOptional().isPresent() && jApiClass.getClassType().getNewTypeOptional().get() == JApiClassType.ClassType.ENUM;
    }

    private void checkIfMethodHasBeenPulledUp(JApiClass jApiClass, Map<String, JApiClass> classMap, JApiMethod method, List<Integer> returnValues) {
        this.forAllImplementedInterfaces(jApiClass, classMap, returnValues, new ArrayList<JApiImplementedInterface>(), (implementedInterface, classMap1) -> {
            for (JApiMethod superMethod : implementedInterface.getMethods()) {
                if (!superMethod.getName().equals(method.getName()) || !superMethod.hasSameSignature(method)) continue;
                return 1;
            }
            return 0;
        });
    }

    private <T> void forAllImplementedInterfaces(JApiClass jApiClass, Map<String, JApiClass> classMap, List<T> returnValues, List<JApiImplementedInterface> visited, OnImplementedInterfaceCallback<T> onImplementedInterfaceCallback) {
        List<JApiImplementedInterface> interfaces = jApiClass.getInterfaces();
        for (JApiImplementedInterface implementedInterface : interfaces) {
            String fullyQualifiedName = implementedInterface.getFullyQualifiedName();
            JApiClass foundClass = classMap.get(fullyQualifiedName);
            if (foundClass == null || !visited.stream().noneMatch(v -> v.getFullyQualifiedName().equals(implementedInterface.getFullyQualifiedName()))) continue;
            T returnValue = onImplementedInterfaceCallback.callback(foundClass, classMap);
            returnValues.add(returnValue);
            visited.add(implementedInterface);
            this.forAllImplementedInterfaces(foundClass, classMap, returnValues, visited, onImplementedInterfaceCallback);
        }
    }

    private boolean isImplemented(JApiMethod jApiMethod, JApiClass aClass) {
        while (aClass != null) {
            for (JApiMethod method : aClass.getMethods()) {
                if (!jApiMethod.getName().equals(method.getName()) || !jApiMethod.hasSameParameter(method) || this.isAbstract(method) || method.getChangeStatus() == JApiChangeStatus.REMOVED || !ModifierHelper.isNotPrivate(method)) continue;
                return true;
            }
            if (aClass.getSuperclass() != null && aClass.getSuperclass().getJApiClass().isPresent()) {
                aClass = aClass.getSuperclass().getJApiClass().get();
                continue;
            }
            aClass = null;
        }
        return false;
    }

    private void checkIfSuperclassesOrInterfacesChangedIncompatible(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        JApiSuperclass superclass = jApiClass.getSuperclass();
        if (superclass.getChangeStatus() == JApiChangeStatus.UNCHANGED || superclass.getChangeStatus() == JApiChangeStatus.MODIFIED || superclass.getChangeStatus() == JApiChangeStatus.REMOVED) {
            ArrayList<JApiMethod> implementedMethods = new ArrayList<JApiMethod>();
            ArrayList removedAndNotOverriddenMethods = new ArrayList();
            ArrayList<JApiField> fields = new ArrayList<JApiField>();
            ArrayList removedAndNotOverriddenFields = new ArrayList();
            for (JApiMethod jApiMethod : jApiClass.getMethods()) {
                if (this.isAbstract(jApiMethod) || jApiMethod.getChangeStatus() == JApiChangeStatus.REMOVED || !ModifierHelper.isNotPrivate(jApiMethod)) continue;
                implementedMethods.add(jApiMethod);
            }
            for (JApiField jApiField : jApiClass.getFields()) {
                if (jApiField.getChangeStatus() == JApiChangeStatus.REMOVED || !ModifierHelper.isNotPrivate(jApiField)) continue;
                fields.add(jApiField);
            }
            this.forAllSuperclasses(jApiClass, classMap, new ArrayList(), (superclass1, classMap1, changeStatusOfSuperclass) -> {
                for (JApiMethod jApiMethod : superclass1.getMethods()) {
                    if (!this.isAbstract(jApiMethod) && jApiMethod.getChangeStatus() != JApiChangeStatus.REMOVED && ModifierHelper.isNotPrivate(jApiMethod)) {
                        implementedMethods.add(jApiMethod);
                    }
                    removedAndNotOverriddenMethods.removeIf(removedAndNotOverriddenMethod -> jApiMethod.getName().equals(removedAndNotOverriddenMethod.getName()) && jApiMethod.hasSameSignature((JApiMethod)removedAndNotOverriddenMethod));
                }
                for (JApiField jApiField : superclass1.getFields()) {
                    if (jApiField.getChangeStatus() != JApiChangeStatus.REMOVED && ModifierHelper.isNotPrivate(jApiField)) {
                        fields.add(jApiField);
                    }
                    removedAndNotOverriddenFields.removeIf(removedAndNotOverriddenField -> jApiField.getName().equals(removedAndNotOverriddenField.getName()) && this.hasSameType(jApiField, (JApiField)removedAndNotOverriddenField));
                }
                for (JApiMethod jApiMethod : superclass1.getMethods()) {
                    if (jApiMethod.getChangeStatus() != JApiChangeStatus.REMOVED || this.isImplemented(jApiMethod, jApiMethod.getjApiClass())) continue;
                    boolean implemented = false;
                    for (JApiMethod implementedMethod : implementedMethods) {
                        if (!jApiMethod.getName().equals(implementedMethod.getName()) || !jApiMethod.hasSameSignature(implementedMethod)) continue;
                        implemented = true;
                        break;
                    }
                    if (implemented) continue;
                    removedAndNotOverriddenMethods.add(jApiMethod);
                }
                for (JApiField jApiField : superclass1.getFields()) {
                    if (jApiField.getChangeStatus() != JApiChangeStatus.REMOVED) continue;
                    boolean overridden = false;
                    for (JApiField field : fields) {
                        if (!field.getName().equals(jApiField.getName()) || !this.hasSameType(jApiField, field)) continue;
                        overridden = true;
                    }
                    if (overridden) continue;
                    removedAndNotOverriddenFields.add(jApiField);
                }
                return 0;
            });
            if (!removedAndNotOverriddenMethods.isEmpty()) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.METHOD_REMOVED_IN_SUPERCLASS);
            }
            if (!removedAndNotOverriddenFields.isEmpty()) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.FIELD_REMOVED_IN_SUPERCLASS);
            }
            if (superclass.getOldSuperclassName().isPresent() && superclass.getNewSuperclassName().isPresent()) {
                if (!superclass.getOldSuperclassName().get().equals(superclass.getNewSuperclassName().get())) {
                    boolean superClassChangedToObject = false;
                    boolean superClassChangedFromObject = false;
                    if (!superclass.getOldSuperclassName().get().equals("java.lang.Object") && superclass.getNewSuperclassName().get().equals("java.lang.Object")) {
                        superClassChangedToObject = true;
                    }
                    if (superclass.getOldSuperclassName().get().equals("java.lang.Object") && !superclass.getNewSuperclassName().get().equals("java.lang.Object")) {
                        superClassChangedFromObject = true;
                    }
                    if (superClassChangedToObject) {
                        this.addCompatibilityChange(superclass, JApiCompatibilityChangeType.SUPERCLASS_REMOVED);
                    } else if (superClassChangedFromObject) {
                        this.addCompatibilityChange(superclass, JApiCompatibilityChangeType.SUPERCLASS_ADDED);
                    } else {
                        ArrayList ancestors = new ArrayList();
                        ArrayList matchingAncestors = new ArrayList();
                        this.forAllSuperclasses(jApiClass, classMap, ancestors, (clazz, classMap12, changeStatusOfSuperclass) -> {
                            JApiSuperclass ancestor = clazz.getSuperclass();
                            if (ancestor.getNewSuperclassName().isPresent() && ancestor.getNewSuperclassName().get().equals(superclass.getOldSuperclassName().get())) {
                                matchingAncestors.add(ancestor);
                            }
                            return ancestor;
                        });
                        if (matchingAncestors.isEmpty()) {
                            this.addCompatibilityChange(superclass, JApiCompatibilityChangeType.SUPERCLASS_REMOVED);
                        } else {
                            this.addCompatibilityChange(superclass, JApiCompatibilityChangeType.SUPERCLASS_ADDED);
                        }
                    }
                }
            } else if (superclass.getOldSuperclassName().isPresent()) {
                this.addCompatibilityChange(superclass, JApiCompatibilityChangeType.SUPERCLASS_REMOVED);
            } else if (superclass.getNewSuperclassName().isPresent()) {
                this.addCompatibilityChange(superclass, JApiCompatibilityChangeType.SUPERCLASS_ADDED);
            }
        }
        for (JApiImplementedInterface implementedInterface : jApiClass.getInterfaces()) {
            if (implementedInterface.getChangeStatus() == JApiChangeStatus.REMOVED) {
                this.addCompatibilityChange(implementedInterface, JApiCompatibilityChangeType.INTERFACE_REMOVED);
                continue;
            }
            JApiClass interfaceClass = classMap.get(implementedInterface.getFullyQualifiedName());
            if (interfaceClass == null) {
                interfaceClass = this.loadClass(implementedInterface.getFullyQualifiedName(), EnumSet.allOf(Classpath.class));
            }
            implementedInterface.setJApiClass(interfaceClass);
            if (implementedInterface.getChangeStatus() == JApiChangeStatus.MODIFIED || implementedInterface.getChangeStatus() == JApiChangeStatus.UNCHANGED) {
                this.checkIfMethodsHaveChangedIncompatible(interfaceClass, classMap);
                this.checkIfFieldsHaveChangedIncompatible(interfaceClass, classMap);
                continue;
            }
            if (implementedInterface.getChangeStatus() != JApiChangeStatus.NEW) continue;
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.INTERFACE_ADDED);
            if (interfaceClass.getMethods().isEmpty() || this.isAbstract(jApiClass) || this.isInterface(jApiClass) || this.isAnnotation(jApiClass) || this.isEnum(jApiClass)) continue;
            boolean allInterfaceMethodsImplemented = true;
            for (JApiMethod interfaceMethod : interfaceClass.getMethods()) {
                boolean interfaceMethodImplemented = false;
                if (ModifierHelper.isSynthetic(interfaceMethod) || !this.isAbstract(interfaceMethod)) continue;
                if (this.isImplemented(interfaceMethod, jApiClass)) {
                    interfaceMethodImplemented = true;
                    break;
                }
                if (interfaceMethodImplemented) continue;
                allInterfaceMethodsImplemented = false;
                break;
            }
            if (allInterfaceMethodsImplemented) continue;
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.METHOD_ABSTRACT_ADDED_IN_IMPLEMENTED_INTERFACE);
        }
        this.checkIfClassNowCheckedException(jApiClass);
        this.checkIfAbstractMethodAddedInSuperclass(jApiClass, classMap);
        this.checkIfAbstractMethodAdded(jApiClass);
    }

    private boolean hasSameType(JApiField field, JApiField otherField) {
        boolean hasSameNewType = false;
        if (field.getType().getNewTypeOptional().isPresent() && otherField.getType().getNewTypeOptional().isPresent()) {
            hasSameNewType = field.getType().getNewTypeOptional().get().equals(otherField.getType().getNewTypeOptional().get());
        } else if (field.getType().getOldTypeOptional().isPresent() && otherField.getType().getNewTypeOptional().isPresent()) {
            hasSameNewType = field.getType().getOldTypeOptional().get().equals(otherField.getType().getNewTypeOptional().get());
        } else if (field.getType().getOldTypeOptional().isPresent() && otherField.getType().getOldTypeOptional().isPresent()) {
            hasSameNewType = field.getType().getOldTypeOptional().get().equals(otherField.getType().getOldTypeOptional().get());
        } else if (field.getType().getNewTypeOptional().isPresent() && otherField.getType().getOldTypeOptional().isPresent()) {
            hasSameNewType = field.getType().getNewTypeOptional().get().equals(otherField.getType().getOldTypeOptional().get());
        }
        return hasSameNewType;
    }

    private void checkIfAbstractMethodAdded(JApiClass jApiClass) {
        if (jApiClass.getChangeStatus() == JApiChangeStatus.NEW || !this.isAbstract(jApiClass)) {
            // empty if block
        }
    }

    private void checkIfAbstractMethodAddedInSuperclass(JApiClass jApiClass, Map<String, JApiClass> classMap) {
        if (jApiClass.getChangeStatus() != JApiChangeStatus.NEW && this.isClass(jApiClass)) {
            ArrayList<JApiMethod> abstractMethods = new ArrayList<JApiMethod>();
            ArrayList<JApiMethod> defaultMethods = new ArrayList<JApiMethod>();
            ArrayList<JApiMethod> implementedMethods = new ArrayList<JApiMethod>();
            ArrayList<JApiImplementedInterface> implementedInterfaces = new ArrayList<JApiImplementedInterface>();
            for (JApiMethod jApiMethod : jApiClass.getMethods()) {
                if (this.isAbstract(jApiMethod)) continue;
                implementedMethods.add(jApiMethod);
            }
            this.forAllSuperclasses(jApiClass, classMap, new ArrayList(), (superclass, classMap1, changeStatusOfSuperclass) -> {
                for (JApiMethod jApiMethod : superclass.getMethods()) {
                    if (this.isAbstract(jApiMethod)) continue;
                    implementedMethods.add(jApiMethod);
                }
                for (JApiMethod jApiMethod : superclass.getMethods()) {
                    if (!this.isAbstract(jApiMethod)) continue;
                    boolean isImplemented = false;
                    for (JApiMethod implementedMethod : implementedMethods) {
                        if (!jApiMethod.getName().equals(implementedMethod.getName()) || !jApiMethod.hasSameSignature(implementedMethod)) continue;
                        isImplemented = true;
                        break;
                    }
                    if (isImplemented || jApiMethod.getChangeStatus() != JApiChangeStatus.NEW && changeStatusOfSuperclass != JApiChangeStatus.NEW && changeStatusOfSuperclass != JApiChangeStatus.MODIFIED || !jApiMethod.getAbstractModifier().getNewModifier().isPresent()) continue;
                    AbstractModifier abstractModifier = jApiMethod.getAbstractModifier().getNewModifier().get();
                    if (abstractModifier == AbstractModifier.ABSTRACT) {
                        abstractMethods.add(jApiMethod);
                        continue;
                    }
                    defaultMethods.add(jApiMethod);
                }
                implementedInterfaces.addAll(superclass.getInterfaces());
                return 0;
            });
            implementedInterfaces.addAll(jApiClass.getInterfaces());
            if (!abstractMethods.isEmpty()) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.METHOD_ABSTRACT_ADDED_IN_SUPERCLASS);
            }
            abstractMethods.clear();
            for (JApiImplementedInterface jApiImplementedInterface : implementedInterfaces) {
                JApiClass interfaceClass = this.getJApiClass(jApiImplementedInterface, classMap);
                for (JApiMethod interfaceMethod : interfaceClass.getMethods()) {
                    boolean isImplemented = false;
                    for (JApiMethod implementedMethod : implementedMethods) {
                        if (!CompatibilityChanges.areMatching(interfaceMethod, implementedMethod)) continue;
                        isImplemented = true;
                        break;
                    }
                    if (isImplemented || interfaceMethod.getChangeStatus() != JApiChangeStatus.NEW && jApiImplementedInterface.getChangeStatus() != JApiChangeStatus.NEW || !interfaceMethod.getAbstractModifier().getNewModifier().isPresent()) continue;
                    AbstractModifier abstractModifier = interfaceMethod.getAbstractModifier().getNewModifier().get();
                    if (abstractModifier == AbstractModifier.ABSTRACT) {
                        abstractMethods.add(interfaceMethod);
                        continue;
                    }
                    defaultMethods.add(interfaceMethod);
                }
            }
            ArrayList<JApiMethod> abstractMethodsWithDefaultInInterface = new ArrayList<JApiMethod>();
            for (JApiMethod abstractMethod : abstractMethods) {
                for (JApiImplementedInterface implementedInterface : implementedInterfaces) {
                    JApiClass interfaceClass = this.getJApiClass(implementedInterface, classMap);
                    for (JApiMethod defaultMethodCandidate : interfaceClass.getMethods()) {
                        if (this.isAbstract(defaultMethodCandidate) || !CompatibilityChanges.areMatching(abstractMethod, defaultMethodCandidate)) continue;
                        for (JApiImplementedInterface extendedInterface : interfaceClass.getInterfaces()) {
                            JApiClass extendedInterfaceClass = this.getJApiClass(extendedInterface, classMap);
                            if (!abstractMethod.getjApiClass().equals(extendedInterfaceClass)) continue;
                            abstractMethodsWithDefaultInInterface.add(abstractMethod);
                        }
                    }
                }
            }
            abstractMethods.removeAll(abstractMethodsWithDefaultInInterface);
            if (!abstractMethods.isEmpty()) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.METHOD_ABSTRACT_ADDED_IN_IMPLEMENTED_INTERFACE);
            }
            if (!defaultMethods.isEmpty()) {
                this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.METHOD_DEFAULT_ADDED_IN_IMPLEMENTED_INTERFACE);
            }
        }
    }

    private static boolean areMatching(JApiMethod left, JApiMethod right) {
        return left.getName().equals(right.getName()) && left.hasSameSignature(right);
    }

    private JApiClass getJApiClass(JApiImplementedInterface implementedInterface, Map<String, JApiClass> classMap) {
        String fullyQualifiedName = implementedInterface.getFullyQualifiedName();
        JApiClass interfaceClass = classMap.get(fullyQualifiedName);
        if (interfaceClass == null) {
            interfaceClass = this.loadClass(fullyQualifiedName, EnumSet.allOf(Classpath.class));
        }
        return interfaceClass;
    }

    private void checkIfClassNowCheckedException(JApiClass jApiClass) {
        String fqn;
        JApiSuperclass jApiClassSuperclass = jApiClass.getSuperclass();
        if (jApiClassSuperclass.getChangeStatus() == JApiChangeStatus.MODIFIED && jApiClassSuperclass.getNewSuperclassName().isPresent() && "java.lang.Exception".equals(fqn = jApiClassSuperclass.getNewSuperclassName().get())) {
            this.addCompatibilityChange(jApiClass, JApiCompatibilityChangeType.CLASS_NOW_CHECKED_EXCEPTION);
        }
    }

    private JApiCompatibilityChange addCompatibilityChange(JApiCompatibility binaryCompatibility, JApiCompatibilityChangeType changeType) {
        JApiCompatibilityChange change = new JApiCompatibilityChange(changeType);
        List<JApiCompatibilityChange> compatibilityChanges = binaryCompatibility.getCompatibilityChanges();
        Optional<JApiCompatibilityChange> first = compatibilityChanges.stream().filter(cc -> cc.equals(change)).findFirst();
        if (!first.isPresent()) {
            compatibilityChanges.add(change);
            return change;
        }
        return first.get();
    }

    private static enum Classpath {
        OLD_CLASSPATH,
        NEW_CLASSPATH;

    }

    private static interface OnImplementedInterfaceCallback<T> {
        public T callback(JApiClass var1, Map<String, JApiClass> var2);
    }

    private static interface OnSuperclassCallback<T> {
        public T callback(JApiClass var1, Map<String, JApiClass> var2, JApiChangeStatus var3);
    }
}

