/*
 * Decompiled with CFR 0.152.
 */
package japicmp.config;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IgnoreMissingClasses {
    private boolean ignoreAllMissingClasses = false;
    private List<Pattern> ignoreMissingClassRegularExpression = new ArrayList<Pattern>();

    public boolean isIgnoreAllMissingClasses() {
        return this.ignoreAllMissingClasses;
    }

    public List<Pattern> getIgnoreMissingClassRegularExpression() {
        return this.ignoreMissingClassRegularExpression;
    }

    public void setIgnoreAllMissingClasses(boolean ignoreAllMissingClasses) {
        this.ignoreAllMissingClasses = ignoreAllMissingClasses;
    }

    public void setIgnoreMissingClassRegularExpression(List<Pattern> ignoreMissingClassRegularExpression) {
        this.ignoreMissingClassRegularExpression = ignoreMissingClassRegularExpression;
    }

    public boolean ignoreClass(String className) {
        if (this.ignoreAllMissingClasses) {
            return true;
        }
        if (!this.ignoreMissingClassRegularExpression.isEmpty()) {
            for (Pattern pattern : this.ignoreMissingClassRegularExpression) {
                Matcher matcher = pattern.matcher(className);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }
}

