/*
 * Decompiled with CFR 0.152.
 */
package japicmp.filter;

import japicmp.filter.AnnotationBehaviorFilter;
import japicmp.filter.AnnotationFilterBase;
import japicmp.filter.ClassFilter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CtClass;
import javassist.NotFoundException;

public class AnnotationClassFilter
extends AnnotationFilterBase
implements ClassFilter {
    private static final Logger LOGGER = Logger.getLogger(AnnotationBehaviorFilter.class.getName());

    public AnnotationClassFilter(String filterString) {
        super(filterString.substring(1));
    }

    @Override
    public boolean matches(CtClass ctClass) {
        boolean matches = ctClass.hasAnnotation(this.annotationClassName);
        if (!matches) {
            try {
                CtClass declaringClass = ctClass.getDeclaringClass();
                if (declaringClass != null) {
                    matches = declaringClass.hasAnnotation(this.annotationClassName);
                }
            }
            catch (NotFoundException e) {
                LOGGER.log(Level.FINE, "Failed to load class '" + ctClass.getName() + "': " + e.getLocalizedMessage(), e);
            }
        }
        return matches;
    }

    public String toString() {
        return "@" + this.annotationClassName;
    }
}

