/*
 * Decompiled with CFR 0.152.
 */
package japicmp.filter;

import japicmp.filter.AnnotationBehaviorFilter;
import japicmp.filter.AnnotationFilterBase;
import japicmp.filter.FieldFilter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AttributeInfo;

public class AnnotationFieldFilter
extends AnnotationFilterBase
implements FieldFilter {
    private static final Logger LOGGER = Logger.getLogger(AnnotationBehaviorFilter.class.getName());

    public AnnotationFieldFilter(String filterString) {
        super(filterString.substring(1));
    }

    @Override
    public boolean matches(CtField ctField) {
        CtClass declaringClass;
        List<AttributeInfo> attributes = ctField.getFieldInfo().getAttributes();
        boolean hasAnnotation = this.hasAnnotation(attributes);
        if (!hasAnnotation && !(hasAnnotation = this.hasAnnotation((declaringClass = ctField.getDeclaringClass()).getClassFile().getAttributes()))) {
            try {
                declaringClass = declaringClass.getDeclaringClass();
                if (declaringClass != null) {
                    hasAnnotation = this.hasAnnotation(declaringClass.getClassFile().getAttributes());
                }
            }
            catch (NotFoundException e) {
                LOGGER.log(Level.FINE, "Failed to load class '" + declaringClass.getName() + "': " + e.getLocalizedMessage(), e);
            }
        }
        return hasAnnotation;
    }

    public String toString() {
        return "@" + this.annotationClassName;
    }
}

