/*
 * Decompiled with CFR 0.152.
 */
package japicmp.filter;

import japicmp.filter.BehaviorFilter;
import japicmp.filter.ClassFilter;
import japicmp.filter.FieldFilter;
import japicmp.filter.Filter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;

public class Filters {
    private static final Logger LOGGER = Logger.getLogger(Filters.class.getName());
    private final List<Filter> includes = new ArrayList<Filter>();
    private final List<Filter> excludes = new ArrayList<Filter>();

    public List<Filter> getIncludes() {
        return this.includes;
    }

    public List<Filter> getExcludes() {
        return this.excludes;
    }

    /*
     * WARNING - void declaration
     */
    public boolean includeClass(CtClass ctClass) {
        String name = ctClass.getName();
        for (Filter filter : this.excludes) {
            ClassFilter classFilter;
            if (!(filter instanceof ClassFilter) || !(classFilter = (ClassFilter)filter).matches(ctClass)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Excluding class '" + name + "' because class filter '" + filter + "' matches.");
            }
            return false;
        }
        int includeCount = 0;
        for (Filter filter : this.includes) {
            ++includeCount;
            if (filter instanceof BehaviorFilter) {
                void var11_16;
                CtConstructor[] constructors;
                BehaviorFilter behaviorFilter = (BehaviorFilter)filter;
                CtMethod[] methods = ctClass.getDeclaredMethods();
                for (CtMember ctMember : methods) {
                    if (!behaviorFilter.matches((CtBehavior)ctMember)) continue;
                    return true;
                }
                CtConstructor[] ctConstructorArray = constructors = ctClass.getDeclaredConstructors();
                int n = ctConstructorArray.length;
                boolean bl = false;
                while (var11_16 < n) {
                    CtConstructor constructor = ctConstructorArray[var11_16];
                    if (behaviorFilter.matches(constructor)) {
                        return true;
                    }
                    ++var11_16;
                }
                continue;
            }
            if (filter instanceof FieldFilter) {
                FieldFilter fieldFilter = (FieldFilter)filter;
                CtField[] fields = ctClass.getDeclaredFields();
                for (CtMember ctMember : fields) {
                    if (!fieldFilter.matches((CtField)ctMember)) continue;
                    return true;
                }
                continue;
            }
            ClassFilter classFilter = (ClassFilter)filter;
            if (!classFilter.matches(ctClass)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Including class '" + name + "' because class filter '" + filter + "' matches.");
            }
            return true;
        }
        if (includeCount > 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Excluding class '" + name + "' because no include matched.");
            }
            return false;
        }
        return true;
    }

    public boolean includeBehavior(CtBehavior ctMethod) {
        for (Filter filter : this.excludes) {
            BehaviorFilter behaviorFilter;
            if (!(filter instanceof BehaviorFilter) || !(behaviorFilter = (BehaviorFilter)filter).matches(ctMethod)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Excluding method '" + ctMethod.getLongName() + "' because exclude method filter did match.");
            }
            return false;
        }
        int includesCount = 0;
        for (Filter filter : this.includes) {
            if (!(filter instanceof BehaviorFilter)) continue;
            ++includesCount;
            BehaviorFilter behaviorFilter = (BehaviorFilter)filter;
            if (!behaviorFilter.matches(ctMethod)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Including method '" + ctMethod.getLongName() + "' because include method filter matched.");
            }
            return true;
        }
        if (includesCount > 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Excluding method '" + ctMethod.getLongName() + "' because no include matched.");
            }
            return false;
        }
        return true;
    }

    public boolean includeField(CtField ctField) {
        for (Filter filter : this.excludes) {
            FieldFilter fieldFilter;
            if (!(filter instanceof FieldFilter) || !(fieldFilter = (FieldFilter)filter).matches(ctField)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Excluding field '" + ctField.getName() + "' because exclude field filter did match.");
            }
            return false;
        }
        int includesCount = 0;
        for (Filter filter : this.includes) {
            if (!(filter instanceof FieldFilter)) continue;
            FieldFilter fieldFilter = (FieldFilter)filter;
            ++includesCount;
            if (!fieldFilter.matches(ctField)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Including field '" + ctField.getName() + "' because include field filter matched.");
            }
            return true;
        }
        if (includesCount > 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Excluding field '" + ctField.getName() + "' because no include matched.");
            }
            return false;
        }
        return true;
    }
}

