/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import com.google.common.xml.XmlEscapers;
import japicmp.model.JApiAnnotationElement;
import japicmp.util.OptionalHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

public class JApiAnnotationElementValue {
    private final String fullyQualifiedName;
    private final Type type;
    private final Object value;
    private Optional<String> name = Optional.empty();

    public JApiAnnotationElementValue(Type type, Object value, String fullyQualifiedName) {
        this.type = type;
        this.value = value;
        this.fullyQualifiedName = fullyQualifiedName;
    }

    @XmlTransient
    public Type getType() {
        return this.type;
    }

    @XmlAttribute(name="type")
    public String getTypeString() {
        return this.type.name();
    }

    @XmlTransient
    public Object getValue() {
        return this.value;
    }

    @XmlAttribute(name="value")
    public String getValueString() {
        if (this.type != Type.Array && this.type != Type.Annotation) {
            return XmlEscapers.xmlAttributeEscaper().escape(this.value.toString());
        }
        return "n.a.";
    }

    @XmlElementWrapper(name="values")
    @XmlElement(name="value")
    public List<JApiAnnotationElementValue> getValues() {
        ArrayList<JApiAnnotationElementValue> values;
        block4: {
            Annotation annotation;
            Set<String> memberNames;
            block3: {
                MemberValue[] memberValues;
                values = new ArrayList<JApiAnnotationElementValue>();
                if (this.type != Type.Array) break block3;
                if (!(this.value instanceof MemberValue[])) break block4;
                for (MemberValue memberValue : memberValues = (MemberValue[])this.value) {
                    JApiAnnotationElementValue elementValue = JApiAnnotationElement.getMemberValue(memberValue);
                    values.add(elementValue);
                }
                break block4;
            }
            if (this.type == Type.Annotation && this.value instanceof Annotation && (memberNames = (annotation = (Annotation)this.value).getMemberNames()) != null) {
                for (String memberName : memberNames) {
                    MemberValue memberValue = annotation.getMemberValue(memberName);
                    JApiAnnotationElementValue elementValue = JApiAnnotationElement.getMemberValue(memberValue);
                    elementValue.setName(Optional.of(memberName));
                    values.add(elementValue);
                }
            }
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JApiAnnotationElementValue that = (JApiAnnotationElementValue)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.type == Type.Array || this.type == Type.Annotation) {
            List<JApiAnnotationElementValue> values = this.getValues();
            List<JApiAnnotationElementValue> thatValues = that.getValues();
            if (values.size() != thatValues.size()) {
                return false;
            }
            for (int i = 0; i < values.size(); ++i) {
                if (values.get(i).equals(thatValues.get(i))) continue;
                return false;
            }
        } else if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.fullyQualifiedName != null ? this.fullyQualifiedName.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    @XmlAttribute(name="fullyQualifiedName")
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    @XmlTransient
    public Optional<String> getName() {
        return this.name;
    }

    @XmlAttribute(name="name")
    public String getNameString() {
        return OptionalHelper.optionalToString(this.name);
    }

    public void setName(Optional<String> name) {
        this.name = name;
    }

    public static enum Type {
        Double,
        Char,
        Long,
        Integer,
        Float,
        Byte,
        Enum,
        Annotation,
        Class,
        Short,
        Boolean,
        UnsupportedType,
        Array,
        String;

    }
}

