/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.model.AbstractModifier;
import japicmp.model.AccessModifier;
import japicmp.model.BridgeModifier;
import japicmp.model.FinalModifier;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiAttribute;
import japicmp.model.JApiCanBeSynthetic;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiException;
import japicmp.model.JApiGenericTemplate;
import japicmp.model.JApiHasAbstractModifier;
import japicmp.model.JApiHasAccessModifier;
import japicmp.model.JApiHasAnnotations;
import japicmp.model.JApiHasBridgeModifier;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasFinalModifier;
import japicmp.model.JApiHasGenericTemplates;
import japicmp.model.JApiHasLineNumber;
import japicmp.model.JApiHasModifiers;
import japicmp.model.JApiHasStaticModifier;
import japicmp.model.JApiMethod;
import japicmp.model.JApiModifier;
import japicmp.model.JApiParameter;
import japicmp.model.StaticModifier;
import japicmp.model.SyntheticAttribute;
import japicmp.model.SyntheticModifier;
import japicmp.model.VarargsModifier;
import japicmp.util.AnnotationHelper;
import japicmp.util.GenericTemplateHelper;
import japicmp.util.ModifierHelper;
import japicmp.util.OptionalHelper;
import japicmp.util.SignatureParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javassist.CtBehavior;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ExceptionsAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

public abstract class JApiBehavior
implements JApiHasModifiers,
JApiHasChangeStatus,
JApiHasAccessModifier,
JApiHasStaticModifier,
JApiHasFinalModifier,
JApiHasAbstractModifier,
JApiCompatibility,
JApiHasAnnotations,
JApiHasBridgeModifier,
JApiCanBeSynthetic,
JApiHasLineNumber,
JApiHasGenericTemplates {
    protected final JApiClass jApiClass;
    private final String name;
    private final JarArchiveComparator jarArchiveComparator;
    private final List<JApiParameter> parameters = new LinkedList<JApiParameter>();
    private final List<JApiAnnotation> annotations = new LinkedList<JApiAnnotation>();
    private final JApiModifier<AccessModifier> accessModifier;
    private final JApiModifier<FinalModifier> finalModifier;
    private final JApiModifier<StaticModifier> staticModifier;
    private final JApiModifier<AbstractModifier> abstractModifier;
    private final JApiModifier<BridgeModifier> bridgeModifier;
    private final JApiModifier<SyntheticModifier> syntheticModifier;
    private final JApiAttribute<SyntheticAttribute> syntheticAttribute;
    private final JApiModifier<VarargsModifier> varargsModifier;
    private final List<JApiException> exceptions;
    protected JApiChangeStatus changeStatus;
    private final Optional<Integer> oldLineNumber;
    private final Optional<Integer> newLineNumber;
    private final List<JApiCompatibilityChange> compatibilityChanges = new ArrayList<JApiCompatibilityChange>();
    private final List<JApiGenericTemplate> genericTemplates;

    public JApiBehavior(JApiClass jApiClass, String name, Optional<? extends CtBehavior> oldBehavior, Optional<? extends CtBehavior> newBehavior, JApiChangeStatus changeStatus, JarArchiveComparator jarArchiveComparator) {
        this.jApiClass = jApiClass;
        this.name = name;
        this.jarArchiveComparator = jarArchiveComparator;
        this.computeAnnotationChanges(this.annotations, oldBehavior, newBehavior, jarArchiveComparator.getJarArchiveComparatorOptions());
        this.genericTemplates = this.computeGenericTemplateChanges(oldBehavior, newBehavior);
        this.accessModifier = this.extractAccessModifier(oldBehavior, newBehavior);
        this.finalModifier = this.extractFinalModifier(oldBehavior, newBehavior);
        this.staticModifier = this.extractStaticModifier(oldBehavior, newBehavior);
        this.abstractModifier = this.extractAbstractModifier(oldBehavior, newBehavior);
        this.bridgeModifier = this.extractBridgeModifier(oldBehavior, newBehavior);
        this.syntheticModifier = this.extractSyntheticModifier(oldBehavior, newBehavior);
        this.syntheticAttribute = this.extractSyntheticAttribute(oldBehavior, newBehavior);
        this.varargsModifier = this.extractVarargsModifier(oldBehavior, newBehavior);
        this.exceptions = this.computeExceptionChanges(oldBehavior, newBehavior);
        this.changeStatus = this.evaluateChangeStatus(changeStatus);
        this.oldLineNumber = this.getLineNumber(oldBehavior);
        this.newLineNumber = this.getLineNumber(newBehavior);
    }

    public void setChangeStatus(JApiChangeStatus changeStatus) {
        this.changeStatus = changeStatus;
    }

    private List<JApiGenericTemplate> computeGenericTemplateChanges(final Optional<? extends CtBehavior> oldBehavior, final Optional<? extends CtBehavior> newBehavior) {
        return GenericTemplateHelper.computeGenericTemplateChanges(new GenericTemplateHelper.SignatureParserCallback(){

            @Override
            public boolean isOldAndNewPresent() {
                return oldBehavior.isPresent() && newBehavior.isPresent();
            }

            @Override
            public boolean isOldPresent() {
                return oldBehavior.isPresent();
            }

            @Override
            public boolean isNewPresent() {
                return newBehavior.isPresent();
            }

            @Override
            public SignatureParser oldSignatureParser() {
                SignatureParser signatureParser = new SignatureParser();
                signatureParser.parse(((CtBehavior)oldBehavior.get()).getGenericSignature());
                return signatureParser;
            }

            @Override
            public SignatureParser newSignatureParser() {
                SignatureParser signatureParser = new SignatureParser();
                signatureParser.parse(((CtBehavior)newBehavior.get()).getGenericSignature());
                return signatureParser;
            }
        });
    }

    private List<JApiException> computeExceptionChanges(Optional<? extends CtBehavior> oldMethodOptional, Optional<? extends CtBehavior> newMethodOptional) {
        ArrayList<JApiException> exceptionList;
        block6: {
            block7: {
                block5: {
                    exceptionList = new ArrayList<JApiException>();
                    if (!oldMethodOptional.isPresent() || !newMethodOptional.isPresent()) break block5;
                    List<String> oldExceptions = this.extractExceptions(oldMethodOptional);
                    List<String> newExceptions = this.extractExceptions(newMethodOptional);
                    for (String oldException : oldExceptions) {
                        if (newExceptions.contains(oldException)) {
                            exceptionList.add(new JApiException(this.jarArchiveComparator, oldException, this.jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.NEW, oldException), JApiChangeStatus.UNCHANGED));
                            newExceptions.remove(oldException);
                            continue;
                        }
                        exceptionList.add(new JApiException(this.jarArchiveComparator, oldException, this.jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.OLD, oldException), JApiChangeStatus.REMOVED));
                    }
                    for (String newException : newExceptions) {
                        exceptionList.add(new JApiException(this.jarArchiveComparator, newException, this.jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.NEW, newException), JApiChangeStatus.NEW));
                    }
                    break block6;
                }
                if (!oldMethodOptional.isPresent()) break block7;
                List<String> exceptions = this.extractExceptions(oldMethodOptional);
                for (String exception : exceptions) {
                    exceptionList.add(new JApiException(this.jarArchiveComparator, exception, this.jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.OLD, exception), JApiChangeStatus.REMOVED));
                }
                break block6;
            }
            if (!newMethodOptional.isPresent()) break block6;
            List<String> exceptions = this.extractExceptions(newMethodOptional);
            for (String exception : exceptions) {
                exceptionList.add(new JApiException(this.jarArchiveComparator, exception, this.jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.NEW, exception), JApiChangeStatus.NEW));
            }
        }
        return exceptionList;
    }

    private List<String> extractExceptions(Optional<? extends CtBehavior> methodOptional) {
        if (methodOptional.isPresent()) {
            ExceptionsAttribute exceptionsAttribute = null;
            try {
                exceptionsAttribute = methodOptional.get().getMethodInfo().getExceptionsAttribute();
            }
            catch (NullPointerException ex) {
                return Collections.emptyList();
            }
            String[] exceptions = exceptionsAttribute != null && exceptionsAttribute.getExceptions() != null ? exceptionsAttribute.getExceptions() : new String[]{};
            ArrayList<String> list = new ArrayList<String>(exceptions.length);
            Collections.addAll(list, exceptions);
            return list;
        }
        return Collections.emptyList();
    }

    private Optional<Integer> getLineNumber(Optional<? extends CtBehavior> methodOptional) {
        CtBehavior ctMethod;
        int lineNumber;
        Optional<Integer> lineNumberOptional = Optional.empty();
        if (methodOptional.isPresent() && (lineNumber = (ctMethod = methodOptional.get()).getMethodInfo().getLineNumber(0)) >= 0) {
            lineNumberOptional = Optional.of(lineNumber);
        }
        return lineNumberOptional;
    }

    private void computeAnnotationChanges(List<JApiAnnotation> annotations, Optional<? extends CtBehavior> oldBehavior, Optional<? extends CtBehavior> newBehavior, JarArchiveComparatorOptions options) {
        if (oldBehavior.isPresent()) {
            CtBehavior ctBehavior = oldBehavior.get();
            if (ctBehavior instanceof CtMethod) {
                this.computeAnnotationChangesMethod(annotations, oldBehavior, newBehavior, options);
            } else if (ctBehavior instanceof CtConstructor) {
                this.computeAnnotationChangesConstructor(annotations, oldBehavior, newBehavior, options);
            }
        } else if (newBehavior.isPresent()) {
            CtBehavior ctBehavior = newBehavior.get();
            if (ctBehavior instanceof CtMethod) {
                this.computeAnnotationChangesMethod(annotations, oldBehavior, newBehavior, options);
            } else if (ctBehavior instanceof CtConstructor) {
                this.computeAnnotationChangesConstructor(annotations, oldBehavior, newBehavior, options);
            }
        }
    }

    private void computeAnnotationChangesMethod(List<JApiAnnotation> annotations, Optional<CtMethod> oldBehavior, Optional<CtMethod> newBehavior, JarArchiveComparatorOptions options) {
        AnnotationHelper.computeAnnotationChanges(annotations, oldBehavior, newBehavior, options, new AnnotationHelper.AnnotationsAttributeCallback<CtMethod>(){

            @Override
            public AnnotationsAttribute getAnnotationsAttribute(CtMethod method) {
                return (AnnotationsAttribute)method.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
            }
        });
    }

    private void computeAnnotationChangesConstructor(List<JApiAnnotation> annotations, Optional<CtConstructor> oldBehavior, Optional<CtConstructor> newBehavior, JarArchiveComparatorOptions options) {
        AnnotationHelper.computeAnnotationChanges(annotations, oldBehavior, newBehavior, options, new AnnotationHelper.AnnotationsAttributeCallback<CtConstructor>(){

            @Override
            public AnnotationsAttribute getAnnotationsAttribute(CtConstructor method) {
                return (AnnotationsAttribute)method.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
            }
        });
    }

    private JApiChangeStatus evaluateChangeStatus(JApiChangeStatus changeStatus) {
        if (changeStatus == JApiChangeStatus.UNCHANGED) {
            if (this.staticModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.finalModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.accessModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.abstractModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.syntheticAttribute.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.varargsModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            for (JApiException jApiException : this.exceptions) {
                if (jApiException.getChangeStatus() != JApiChangeStatus.NEW && jApiException.getChangeStatus() != JApiChangeStatus.REMOVED) continue;
                changeStatus = JApiChangeStatus.MODIFIED;
            }
        }
        return changeStatus;
    }

    protected JApiAttribute<SyntheticAttribute> extractSyntheticAttribute(Optional<? extends CtBehavior> oldBehaviorOptional, Optional<? extends CtBehavior> newBehaviorOptional) {
        JApiAttribute<SyntheticAttribute> jApiAttribute = new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.UNCHANGED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.of(SyntheticAttribute.SYNTHETIC));
        if (oldBehaviorOptional.isPresent() && newBehaviorOptional.isPresent()) {
            CtBehavior oldBehavior = oldBehaviorOptional.get();
            CtBehavior newBehavior = newBehaviorOptional.get();
            byte[] attributeOldBehavior = oldBehavior.getAttribute("Synthetic");
            byte[] attributeNewBehavior = newBehavior.getAttribute("Synthetic");
            jApiAttribute = attributeOldBehavior != null && attributeNewBehavior != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.UNCHANGED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.of(SyntheticAttribute.SYNTHETIC)) : (attributeOldBehavior != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.MODIFIED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.of(SyntheticAttribute.NON_SYNTHETIC)) : (attributeNewBehavior != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.MODIFIED, Optional.of(SyntheticAttribute.NON_SYNTHETIC), Optional.of(SyntheticAttribute.SYNTHETIC)) : new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.UNCHANGED, Optional.of(SyntheticAttribute.NON_SYNTHETIC), Optional.of(SyntheticAttribute.NON_SYNTHETIC))));
        } else {
            byte[] attribute;
            CtBehavior ctBehavior;
            if (oldBehaviorOptional.isPresent()) {
                ctBehavior = oldBehaviorOptional.get();
                attribute = ctBehavior.getAttribute("Synthetic");
                jApiAttribute = attribute != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.REMOVED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.empty()) : new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.REMOVED, Optional.of(SyntheticAttribute.NON_SYNTHETIC), Optional.empty());
            }
            if (newBehaviorOptional.isPresent()) {
                ctBehavior = newBehaviorOptional.get();
                attribute = ctBehavior.getAttribute("Synthetic");
                jApiAttribute = attribute != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.NEW, Optional.empty(), Optional.of(SyntheticAttribute.SYNTHETIC)) : new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.NEW, Optional.empty(), Optional.of(SyntheticAttribute.NON_SYNTHETIC));
            }
        }
        return jApiAttribute;
    }

    public boolean hasSameParameter(JApiMethod method) {
        boolean hasSameParameter = true;
        List<JApiParameter> parameters1 = this.getParameters();
        List<JApiParameter> parameters2 = method.getParameters();
        if (parameters1.size() != parameters2.size()) {
            hasSameParameter = false;
        }
        if (hasSameParameter) {
            for (int i = 0; i < parameters1.size(); ++i) {
                if (parameters1.get(i).getType().equals(parameters2.get(i).getType())) continue;
                hasSameParameter = false;
            }
        }
        return hasSameParameter;
    }

    private JApiModifier<StaticModifier> extractStaticModifier(Optional<? extends CtBehavior> oldBehaviorOptional, Optional<? extends CtBehavior> newBehaviorOptional) {
        return ModifierHelper.extractModifierFromBehavior(oldBehaviorOptional, newBehaviorOptional, new ModifierHelper.ExtractModifierFromBehaviorCallback<StaticModifier>(){

            @Override
            public StaticModifier getModifierForOld(CtBehavior oldBehavior) {
                return Modifier.isStatic(oldBehavior.getModifiers()) ? StaticModifier.STATIC : StaticModifier.NON_STATIC;
            }

            @Override
            public StaticModifier getModifierForNew(CtBehavior newBehavior) {
                return Modifier.isStatic(newBehavior.getModifiers()) ? StaticModifier.STATIC : StaticModifier.NON_STATIC;
            }
        });
    }

    private JApiModifier<FinalModifier> extractFinalModifier(Optional<? extends CtBehavior> oldBehaviorOptional, Optional<? extends CtBehavior> newBehaviorOptional) {
        return ModifierHelper.extractModifierFromBehavior(oldBehaviorOptional, newBehaviorOptional, new ModifierHelper.ExtractModifierFromBehaviorCallback<FinalModifier>(){

            @Override
            public FinalModifier getModifierForOld(CtBehavior oldBehavior) {
                return Modifier.isFinal(oldBehavior.getModifiers()) ? FinalModifier.FINAL : FinalModifier.NON_FINAL;
            }

            @Override
            public FinalModifier getModifierForNew(CtBehavior newBehavior) {
                return Modifier.isFinal(newBehavior.getModifiers()) ? FinalModifier.FINAL : FinalModifier.NON_FINAL;
            }
        });
    }

    private JApiModifier<AccessModifier> extractAccessModifier(Optional<? extends CtBehavior> oldBehaviorOptional, Optional<? extends CtBehavior> newBehaviorOptional) {
        return ModifierHelper.extractModifierFromBehavior(oldBehaviorOptional, newBehaviorOptional, new ModifierHelper.ExtractModifierFromBehaviorCallback<AccessModifier>(){

            @Override
            public AccessModifier getModifierForOld(CtBehavior oldBehavior) {
                return ModifierHelper.translateToModifierLevel(oldBehavior.getModifiers());
            }

            @Override
            public AccessModifier getModifierForNew(CtBehavior newBehavior) {
                return ModifierHelper.translateToModifierLevel(newBehavior.getModifiers());
            }
        });
    }

    private JApiModifier<AbstractModifier> extractAbstractModifier(Optional<? extends CtBehavior> oldBehaviorOptional, Optional<? extends CtBehavior> newBehaviorOptional) {
        return ModifierHelper.extractModifierFromBehavior(oldBehaviorOptional, newBehaviorOptional, new ModifierHelper.ExtractModifierFromBehaviorCallback<AbstractModifier>(){

            @Override
            public AbstractModifier getModifierForOld(CtBehavior oldBehavior) {
                return Modifier.isAbstract(oldBehavior.getModifiers()) ? AbstractModifier.ABSTRACT : AbstractModifier.NON_ABSTRACT;
            }

            @Override
            public AbstractModifier getModifierForNew(CtBehavior newBehavior) {
                return Modifier.isAbstract(newBehavior.getModifiers()) ? AbstractModifier.ABSTRACT : AbstractModifier.NON_ABSTRACT;
            }
        });
    }

    private JApiModifier<BridgeModifier> extractBridgeModifier(Optional<? extends CtBehavior> oldBehaviorOptional, Optional<? extends CtBehavior> newBehaviorOptional) {
        return ModifierHelper.extractModifierFromBehavior(oldBehaviorOptional, newBehaviorOptional, new ModifierHelper.ExtractModifierFromBehaviorCallback<BridgeModifier>(){

            @Override
            public BridgeModifier getModifierForOld(CtBehavior oldBehavior) {
                return ModifierHelper.isBridge(oldBehavior.getModifiers()) ? BridgeModifier.BRIDGE : BridgeModifier.NON_BRIDGE;
            }

            @Override
            public BridgeModifier getModifierForNew(CtBehavior newBehavior) {
                return ModifierHelper.isBridge(newBehavior.getModifiers()) ? BridgeModifier.BRIDGE : BridgeModifier.NON_BRIDGE;
            }
        });
    }

    private JApiModifier<SyntheticModifier> extractSyntheticModifier(Optional<? extends CtBehavior> oldBehaviorOptional, Optional<? extends CtBehavior> newBehaviorOptional) {
        return ModifierHelper.extractModifierFromBehavior(oldBehaviorOptional, newBehaviorOptional, new ModifierHelper.ExtractModifierFromBehaviorCallback<SyntheticModifier>(){

            @Override
            public SyntheticModifier getModifierForOld(CtBehavior oldBehavior) {
                return ModifierHelper.isSynthetic(oldBehavior.getModifiers()) ? SyntheticModifier.SYNTHETIC : SyntheticModifier.NON_SYNTHETIC;
            }

            @Override
            public SyntheticModifier getModifierForNew(CtBehavior newBehavior) {
                return ModifierHelper.isSynthetic(newBehavior.getModifiers()) ? SyntheticModifier.SYNTHETIC : SyntheticModifier.NON_SYNTHETIC;
            }
        });
    }

    private JApiModifier<VarargsModifier> extractVarargsModifier(Optional<? extends CtBehavior> oldBehaviorOptional, Optional<? extends CtBehavior> newBehaviorOptional) {
        return ModifierHelper.extractModifierFromBehavior(oldBehaviorOptional, newBehaviorOptional, new ModifierHelper.ExtractModifierFromBehaviorCallback<VarargsModifier>(){

            private VarargsModifier getModifier(CtBehavior behavior) {
                return Modifier.isVarArgs(behavior.getModifiers()) ? VarargsModifier.VARARGS : VarargsModifier.NON_VARARGS;
            }

            @Override
            public VarargsModifier getModifierForOld(CtBehavior oldBehavior) {
                return this.getModifier(oldBehavior);
            }

            @Override
            public VarargsModifier getModifierForNew(CtBehavior newBehavior) {
                return this.getModifier(newBehavior);
            }
        });
    }

    @Override
    @XmlElementWrapper(name="modifiers")
    @XmlElement(name="modifier")
    public List<? extends JApiModifier<? extends Enum<? extends Enum<?>>>> getModifiers() {
        return Arrays.asList(this.finalModifier, this.staticModifier, this.accessModifier, this.abstractModifier, this.bridgeModifier, this.syntheticModifier);
    }

    @XmlAttribute
    public String getName() {
        return this.name;
    }

    @Override
    @XmlAttribute
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlElementWrapper(name="parameters")
    @XmlElement(name="parameter")
    public List<JApiParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(JApiParameter jApiParameter) {
        this.parameters.add(jApiParameter);
    }

    @Override
    @XmlTransient
    public JApiModifier<AccessModifier> getAccessModifier() {
        return this.accessModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<FinalModifier> getFinalModifier() {
        return this.finalModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<StaticModifier> getStaticModifier() {
        return this.staticModifier;
    }

    @Override
    public JApiModifier<AbstractModifier> getAbstractModifier() {
        return this.abstractModifier;
    }

    @XmlElementWrapper(name="attributes")
    @XmlElement(name="attribute")
    public List<JApiAttribute<? extends Enum<?>>> getAttributes() {
        ArrayList list = new ArrayList();
        list.add(this.syntheticAttribute);
        return list;
    }

    @Override
    @XmlTransient
    public JApiModifier<BridgeModifier> getBridgeModifier() {
        return this.bridgeModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<SyntheticModifier> getSyntheticModifier() {
        return this.syntheticModifier;
    }

    @Override
    @XmlTransient
    public JApiAttribute<SyntheticAttribute> getSyntheticAttribute() {
        return this.syntheticAttribute;
    }

    @XmlTransient
    public JApiModifier<VarargsModifier> getVarargsModifier() {
        return this.varargsModifier;
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        boolean binaryCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isBinaryCompatible()) continue;
            binaryCompatible = false;
            break;
        }
        return binaryCompatible;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        boolean sourceCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isSourceCompatible()) continue;
            sourceCompatible = false;
            break;
        }
        block1: for (JApiParameter jApiParameter : this.getParameters()) {
            for (JApiCompatibilityChange compatibilityChange : jApiParameter.getCompatibilityChanges()) {
                if (compatibilityChange.isSourceCompatible()) continue;
                sourceCompatible = false;
                continue block1;
            }
        }
        return sourceCompatible;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return this.compatibilityChanges;
    }

    @Override
    @XmlElementWrapper(name="annotations")
    @XmlElement(name="annotation")
    public List<JApiAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public Optional<Integer> getOldLineNumber() {
        return this.oldLineNumber;
    }

    @Override
    public Optional<Integer> geNewLineNumber() {
        return this.newLineNumber;
    }

    @XmlAttribute(name="oldLineNumber")
    public String getOldLineNumberAsString() {
        return OptionalHelper.optionalToString(this.oldLineNumber);
    }

    @XmlAttribute(name="newLineNumber")
    public String getNewLineNumberAsString() {
        return OptionalHelper.optionalToString(this.newLineNumber);
    }

    @XmlElementWrapper(name="exceptions")
    @XmlElement(name="exception")
    public List<JApiException> getExceptions() {
        return this.exceptions;
    }

    @XmlTransient
    public JApiClass getjApiClass() {
        return this.jApiClass;
    }

    @Override
    @XmlElementWrapper(name="genericTemplates")
    @XmlElement(name="genericTemplate")
    public List<JApiGenericTemplate> getGenericTemplates() {
        return this.genericTemplates;
    }

    public abstract void enhanceGenericTypeToParameters();

    protected void enhanceGenericTypeToParameters(JApiClass jApiClass, Optional<? extends CtBehavior> oldBehavior, Optional<? extends CtBehavior> newBehavior) {
        int i;
        List<JApiParameter> jApiParameters;
        SignatureParser signatureParser;
        String genericSignature;
        if (oldBehavior.isPresent() && oldBehavior.get().getGenericSignature() != null) {
            genericSignature = oldBehavior.get().getGenericSignature();
            signatureParser = new SignatureParser();
            signatureParser.parse(genericSignature);
            jApiParameters = signatureParser.getJApiParameters(jApiClass, SignatureParser.DiffType.OLD_PARAMS);
            if (jApiParameters.size() == this.getParameters().size()) {
                for (i = 0; i < this.getParameters().size(); ++i) {
                    this.getParameters().get(i).setTemplateName(jApiParameters.get(i).getTemplateNameOptional());
                    this.getParameters().get(i).getOldGenericTypes().clear();
                    this.getParameters().get(i).getOldGenericTypes().addAll(jApiParameters.get(i).getOldGenericTypes());
                }
            }
        }
        if (newBehavior.isPresent() && newBehavior.get().getGenericSignature() != null) {
            genericSignature = newBehavior.get().getGenericSignature();
            signatureParser = new SignatureParser();
            signatureParser.parse(genericSignature);
            jApiParameters = signatureParser.getJApiParameters(jApiClass, SignatureParser.DiffType.NEW_PARAMS);
            if (jApiParameters.size() == this.getParameters().size()) {
                for (i = 0; i < this.getParameters().size(); ++i) {
                    this.getParameters().get(i).setTemplateName(jApiParameters.get(i).getTemplateNameOptional());
                    this.getParameters().get(i).getNewGenericTypes().clear();
                    this.getParameters().get(i).getNewGenericTypes().addAll(jApiParameters.get(i).getNewGenericTypes());
                }
            }
        }
    }
}

