/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.model.JApiCompatibilityChangeType;
import japicmp.model.JApiSemanticVersionLevel;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAttribute;

public class JApiCompatibilityChange {
    private final JApiCompatibilityChangeType type;
    private boolean binaryCompatible;
    private boolean sourceCompatible;

    public JApiCompatibilityChange(JApiCompatibilityChangeType type) {
        this.type = type;
        this.binaryCompatible = type.isBinaryCompatible();
        this.sourceCompatible = type.isSourceCompatible();
    }

    @XmlAttribute(name="type")
    public JApiCompatibilityChangeType getType() {
        return this.type;
    }

    @XmlAttribute(name="binaryCompatible")
    public boolean isBinaryCompatible() {
        return this.binaryCompatible;
    }

    @XmlAttribute(name="sourceCompatible")
    public boolean isSourceCompatible() {
        return this.sourceCompatible;
    }

    public void setBinaryCompatible(boolean binaryCompatible) {
        this.binaryCompatible = binaryCompatible;
    }

    public void setSourceCompatible(boolean sourceCompatible) {
        this.sourceCompatible = sourceCompatible;
    }

    public JApiSemanticVersionLevel getSemanticVersionLevel() {
        return this.type.getSemanticVersionLevel();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JApiCompatibilityChange that = (JApiCompatibilityChange)o;
        return this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("JApiCompatibilityChange{");
        sb.append("type=").append((Object)this.type);
        sb.append('}');
        return sb.toString();
    }
}

