/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.model.AbstractModifier;
import japicmp.model.AccessModifier;
import japicmp.model.FinalModifier;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiAttribute;
import japicmp.model.JApiCanBeSynthetic;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiGenericType;
import japicmp.model.JApiHasAccessModifier;
import japicmp.model.JApiHasAnnotations;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasFinalModifier;
import japicmp.model.JApiHasGenericTypes;
import japicmp.model.JApiHasModifiers;
import japicmp.model.JApiHasStaticModifier;
import japicmp.model.JApiHasTransientModifier;
import japicmp.model.JApiHasVolatileModifier;
import japicmp.model.JApiModifier;
import japicmp.model.JApiType;
import japicmp.model.StaticModifier;
import japicmp.model.SyntheticAttribute;
import japicmp.model.SyntheticModifier;
import japicmp.model.TransientModifier;
import japicmp.model.VolatileModifier;
import japicmp.util.AnnotationHelper;
import japicmp.util.ModifierHelper;
import japicmp.util.SignatureParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javassist.CtField;
import javassist.Modifier;
import javassist.bytecode.AnnotationsAttribute;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

public class JApiField
implements JApiHasChangeStatus,
JApiHasModifiers,
JApiHasAccessModifier,
JApiHasStaticModifier,
JApiHasFinalModifier,
JApiHasTransientModifier,
JApiHasVolatileModifier,
JApiCompatibility,
JApiHasAnnotations,
JApiCanBeSynthetic,
JApiHasGenericTypes {
    private final JApiChangeStatus changeStatus;
    private final JApiClass jApiClass;
    private final Optional<CtField> oldFieldOptional;
    private final Optional<CtField> newFieldOptional;
    private final List<JApiAnnotation> annotations = new LinkedList<JApiAnnotation>();
    private final JApiModifier<AccessModifier> accessModifier;
    private final JApiModifier<StaticModifier> staticModifier;
    private final JApiModifier<FinalModifier> finalModifier;
    private final JApiModifier<TransientModifier> transientModifier;
    private final JApiModifier<VolatileModifier> volatileModifier;
    private final JApiModifier<SyntheticModifier> syntheticModifier;
    private final JApiAttribute<SyntheticAttribute> syntheticAttribute;
    private final List<JApiCompatibilityChange> compatibilityChanges = new ArrayList<JApiCompatibilityChange>();
    private final List<JApiGenericType> oldGenericTypes = new ArrayList<JApiGenericType>();
    private final List<JApiGenericType> newGenericTypes = new ArrayList<JApiGenericType>();
    private final JApiType type;

    public JApiField(JApiClass jApiClass, JApiChangeStatus changeStatus, Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional, JarArchiveComparatorOptions options) {
        this.jApiClass = jApiClass;
        this.oldFieldOptional = oldFieldOptional;
        this.newFieldOptional = newFieldOptional;
        this.computeAnnotationChanges(this.annotations, oldFieldOptional, newFieldOptional, options);
        this.accessModifier = this.extractAccessModifier(oldFieldOptional, newFieldOptional);
        this.staticModifier = this.extractStaticModifier(oldFieldOptional, newFieldOptional);
        this.finalModifier = this.extractFinalModifier(oldFieldOptional, newFieldOptional);
        this.transientModifier = this.extractTransientModifier(oldFieldOptional, newFieldOptional);
        this.volatileModifier = this.extractVolatileModifier(oldFieldOptional, newFieldOptional);
        this.syntheticModifier = this.extractSyntheticModifier(oldFieldOptional, newFieldOptional);
        this.syntheticAttribute = this.extractSyntheticAttribute(oldFieldOptional, newFieldOptional);
        this.type = this.extractType(oldFieldOptional, newFieldOptional);
        this.changeStatus = this.evaluateChangeStatus(changeStatus);
    }

    private void computeAnnotationChanges(List<JApiAnnotation> annotations, Optional<CtField> oldBehavior, Optional<CtField> newBehavior, JarArchiveComparatorOptions options) {
        AnnotationHelper.computeAnnotationChanges(annotations, oldBehavior, newBehavior, options, new AnnotationHelper.AnnotationsAttributeCallback<CtField>(){

            @Override
            public AnnotationsAttribute getAnnotationsAttribute(CtField field) {
                return (AnnotationsAttribute)field.getFieldInfo().getAttribute("RuntimeVisibleAnnotations");
            }
        });
    }

    private JApiType extractType(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional) {
        JApiType jApiType = new JApiType(Optional.empty(), Optional.empty(), JApiChangeStatus.UNCHANGED);
        if (oldFieldOptional.isPresent() && newFieldOptional.isPresent()) {
            String newType;
            CtField oldField = oldFieldOptional.get();
            CtField newField = newFieldOptional.get();
            String oldType = this.signatureToType(oldField.getSignature());
            jApiType = oldType.equals(newType = this.signatureToType(newField.getSignature())) ? new JApiType(Optional.of(oldType), Optional.of(newType), JApiChangeStatus.UNCHANGED) : new JApiType(Optional.of(oldType), Optional.of(newType), JApiChangeStatus.MODIFIED);
        } else if (oldFieldOptional.isPresent()) {
            CtField oldField = oldFieldOptional.get();
            String oldType = this.signatureToType(oldField.getSignature());
            jApiType = new JApiType(Optional.of(oldType), Optional.empty(), JApiChangeStatus.REMOVED);
        } else if (newFieldOptional.isPresent()) {
            CtField newField = newFieldOptional.get();
            String newType = this.signatureToType(newField.getSignature());
            jApiType = new JApiType(Optional.empty(), Optional.of(newType), JApiChangeStatus.NEW);
        }
        return jApiType;
    }

    private String signatureToType(String signature) {
        SignatureParser methodDescriptorParser = new SignatureParser();
        List<SignatureParser.ParsedParameter> types = methodDescriptorParser.parseTypes(signature);
        if (types.size() > 0) {
            return types.get(0).getType();
        }
        return "n.a.";
    }

    private JApiChangeStatus evaluateChangeStatus(JApiChangeStatus changeStatus) {
        if (changeStatus == JApiChangeStatus.UNCHANGED) {
            if (this.accessModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.staticModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.finalModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.transientModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.volatileModifier.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.syntheticAttribute.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
            if (this.type.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
                changeStatus = JApiChangeStatus.MODIFIED;
            }
        }
        return changeStatus;
    }

    private JApiAttribute<SyntheticAttribute> extractSyntheticAttribute(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional) {
        JApiAttribute<SyntheticAttribute> jApiAttribute = new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.UNCHANGED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.of(SyntheticAttribute.SYNTHETIC));
        if (oldFieldOptional.isPresent() && newFieldOptional.isPresent()) {
            CtField oldField = oldFieldOptional.get();
            CtField newField = newFieldOptional.get();
            byte[] attributeOldField = oldField.getAttribute("Synthetic");
            byte[] attributeNewField = newField.getAttribute("Synthetic");
            jApiAttribute = attributeOldField != null && attributeNewField != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.UNCHANGED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.of(SyntheticAttribute.SYNTHETIC)) : (attributeOldField != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.MODIFIED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.of(SyntheticAttribute.NON_SYNTHETIC)) : (attributeNewField != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.MODIFIED, Optional.of(SyntheticAttribute.NON_SYNTHETIC), Optional.of(SyntheticAttribute.SYNTHETIC)) : new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.UNCHANGED, Optional.of(SyntheticAttribute.NON_SYNTHETIC), Optional.of(SyntheticAttribute.NON_SYNTHETIC))));
        } else {
            byte[] attribute;
            CtField ctField;
            if (oldFieldOptional.isPresent()) {
                ctField = oldFieldOptional.get();
                attribute = ctField.getAttribute("Synthetic");
                jApiAttribute = attribute != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.REMOVED, Optional.of(SyntheticAttribute.SYNTHETIC), Optional.empty()) : new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.REMOVED, Optional.of(SyntheticAttribute.NON_SYNTHETIC), Optional.empty());
            }
            if (newFieldOptional.isPresent()) {
                ctField = newFieldOptional.get();
                attribute = ctField.getAttribute("Synthetic");
                jApiAttribute = attribute != null ? new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.NEW, Optional.empty(), Optional.of(SyntheticAttribute.SYNTHETIC)) : new JApiAttribute<SyntheticAttribute>(JApiChangeStatus.NEW, Optional.empty(), Optional.of(SyntheticAttribute.NON_SYNTHETIC));
            }
        }
        return jApiAttribute;
    }

    private JApiModifier<StaticModifier> extractStaticModifier(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional) {
        return ModifierHelper.extractModifierFromField(oldFieldOptional, newFieldOptional, new ModifierHelper.ExtractModifierFromFieldCallback<StaticModifier>(){

            @Override
            public StaticModifier getModifierForOld(CtField oldField) {
                return Modifier.isStatic(oldField.getModifiers()) ? StaticModifier.STATIC : StaticModifier.NON_STATIC;
            }

            @Override
            public StaticModifier getModifierForNew(CtField newField) {
                return Modifier.isStatic(newField.getModifiers()) ? StaticModifier.STATIC : StaticModifier.NON_STATIC;
            }
        });
    }

    private JApiModifier<FinalModifier> extractFinalModifier(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional) {
        return ModifierHelper.extractModifierFromField(oldFieldOptional, newFieldOptional, new ModifierHelper.ExtractModifierFromFieldCallback<FinalModifier>(){

            @Override
            public FinalModifier getModifierForOld(CtField oldField) {
                return Modifier.isFinal(oldField.getModifiers()) ? FinalModifier.FINAL : FinalModifier.NON_FINAL;
            }

            @Override
            public FinalModifier getModifierForNew(CtField newField) {
                return Modifier.isFinal(newField.getModifiers()) ? FinalModifier.FINAL : FinalModifier.NON_FINAL;
            }
        });
    }

    private JApiModifier<AccessModifier> extractAccessModifier(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional) {
        return ModifierHelper.extractModifierFromField(oldFieldOptional, newFieldOptional, new ModifierHelper.ExtractModifierFromFieldCallback<AccessModifier>(){

            @Override
            public AccessModifier getModifierForOld(CtField oldField) {
                return ModifierHelper.translateToModifierLevel(oldField.getModifiers());
            }

            @Override
            public AccessModifier getModifierForNew(CtField newField) {
                return ModifierHelper.translateToModifierLevel(newField.getModifiers());
            }
        });
    }

    private JApiModifier<AbstractModifier> extractAbstractModifier(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional) {
        return ModifierHelper.extractModifierFromField(oldFieldOptional, newFieldOptional, new ModifierHelper.ExtractModifierFromFieldCallback<AbstractModifier>(){

            @Override
            public AbstractModifier getModifierForOld(CtField oldField) {
                return Modifier.isAbstract(oldField.getModifiers()) ? AbstractModifier.ABSTRACT : AbstractModifier.NON_ABSTRACT;
            }

            @Override
            public AbstractModifier getModifierForNew(CtField newField) {
                return Modifier.isAbstract(newField.getModifiers()) ? AbstractModifier.ABSTRACT : AbstractModifier.NON_ABSTRACT;
            }
        });
    }

    private JApiModifier<TransientModifier> extractTransientModifier(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional) {
        return ModifierHelper.extractModifierFromField(oldFieldOptional, newFieldOptional, new ModifierHelper.ExtractModifierFromFieldCallback<TransientModifier>(){

            @Override
            public TransientModifier getModifierForOld(CtField oldField) {
                return Modifier.isTransient(oldField.getModifiers()) ? TransientModifier.TRANSIENT : TransientModifier.NON_TRANSIENT;
            }

            @Override
            public TransientModifier getModifierForNew(CtField newField) {
                return Modifier.isTransient(newField.getModifiers()) ? TransientModifier.TRANSIENT : TransientModifier.NON_TRANSIENT;
            }
        });
    }

    private JApiModifier<VolatileModifier> extractVolatileModifier(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional) {
        return ModifierHelper.extractModifierFromField(oldFieldOptional, newFieldOptional, new ModifierHelper.ExtractModifierFromFieldCallback<VolatileModifier>(){

            @Override
            public VolatileModifier getModifierForOld(CtField oldField) {
                return Modifier.isVolatile(oldField.getModifiers()) ? VolatileModifier.VOLATILE : VolatileModifier.NON_VOLATILE;
            }

            @Override
            public VolatileModifier getModifierForNew(CtField newField) {
                return Modifier.isVolatile(newField.getModifiers()) ? VolatileModifier.VOLATILE : VolatileModifier.NON_VOLATILE;
            }
        });
    }

    private JApiModifier<SyntheticModifier> extractSyntheticModifier(Optional<CtField> oldFieldOptional, Optional<CtField> newFieldOptional) {
        return ModifierHelper.extractModifierFromField(oldFieldOptional, newFieldOptional, new ModifierHelper.ExtractModifierFromFieldCallback<SyntheticModifier>(){

            @Override
            public SyntheticModifier getModifierForOld(CtField oldField) {
                return ModifierHelper.isSynthetic(oldField.getModifiers()) ? SyntheticModifier.SYNTHETIC : SyntheticModifier.NON_SYNTHETIC;
            }

            @Override
            public SyntheticModifier getModifierForNew(CtField newField) {
                return ModifierHelper.isSynthetic(newField.getModifiers()) ? SyntheticModifier.SYNTHETIC : SyntheticModifier.NON_SYNTHETIC;
            }
        });
    }

    @Override
    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlAttribute(name="name")
    public String getName() {
        String name = "n.a.";
        if (this.oldFieldOptional.isPresent()) {
            name = this.oldFieldOptional.get().getName();
        }
        if (this.newFieldOptional.isPresent()) {
            name = this.newFieldOptional.get().getName();
        }
        return name;
    }

    @XmlTransient
    public Optional<CtField> getOldFieldOptional() {
        return this.oldFieldOptional;
    }

    @XmlTransient
    public Optional<CtField> getNewFieldOptional() {
        return this.newFieldOptional;
    }

    @Override
    @XmlElementWrapper(name="modifiers")
    @XmlElement(name="modifier")
    public List<? extends JApiModifier<? extends Enum<? extends Enum<?>>>> getModifiers() {
        return Arrays.asList(this.accessModifier, this.staticModifier, this.finalModifier, this.transientModifier, this.volatileModifier, this.syntheticModifier);
    }

    @Override
    @XmlTransient
    public JApiModifier<StaticModifier> getStaticModifier() {
        return this.staticModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<FinalModifier> getFinalModifier() {
        return this.finalModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<TransientModifier> getTransientModifier() {
        return this.transientModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<VolatileModifier> getVolatileModifier() {
        return this.volatileModifier;
    }

    @Override
    @XmlTransient
    public JApiModifier<AccessModifier> getAccessModifier() {
        return this.accessModifier;
    }

    @XmlElementWrapper(name="attributes")
    @XmlElement(name="attribute")
    public List<JApiAttribute<? extends Enum<?>>> getAttributes() {
        ArrayList list = new ArrayList();
        list.add(this.syntheticAttribute);
        return list;
    }

    @Override
    @XmlTransient
    public JApiModifier<SyntheticModifier> getSyntheticModifier() {
        return this.syntheticModifier;
    }

    @Override
    @XmlTransient
    public JApiAttribute<SyntheticAttribute> getSyntheticAttribute() {
        return this.syntheticAttribute;
    }

    @XmlElement(name="type")
    public JApiType getType() {
        return this.type;
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        boolean binaryCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isBinaryCompatible()) continue;
            binaryCompatible = false;
        }
        return binaryCompatible;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        boolean sourceCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isSourceCompatible()) continue;
            sourceCompatible = false;
        }
        return sourceCompatible;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return this.compatibilityChanges;
    }

    @Override
    @XmlElementWrapper(name="annotations")
    @XmlElement(name="annotation")
    public List<JApiAnnotation> getAnnotations() {
        return this.annotations;
    }

    @XmlTransient
    public JApiClass getjApiClass() {
        return this.jApiClass;
    }

    public String toString() {
        return "JApiField [changeStatus=" + (Object)((Object)this.changeStatus) + ", jApiClass=" + this.jApiClass + ", oldFieldOptional=" + this.oldFieldOptional + ", newFieldOptional=" + this.newFieldOptional + ", annotations=" + this.annotations + ", accessModifier=" + this.accessModifier + ", staticModifier=" + this.staticModifier + ", finalModifier=" + this.finalModifier + ", transientModifier=" + this.transientModifier + ", volatileModifier=" + this.volatileModifier + ", syntheticModifier=" + this.syntheticModifier + ", syntheticAttribute=" + this.syntheticAttribute + ", compatibilityChanges=" + this.compatibilityChanges + ", type=" + this.type + "]";
    }

    @Override
    @XmlElementWrapper(name="oldGenericTypes")
    @XmlElement(name="oldGenericType")
    public List<JApiGenericType> getOldGenericTypes() {
        return this.oldGenericTypes;
    }

    @Override
    @XmlElementWrapper(name="newGenericTypes")
    @XmlElement(name="newGenericType")
    public List<JApiGenericType> getNewGenericTypes() {
        return this.newGenericTypes;
    }
}

