/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiGenericType;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasGenericTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlTransient;

public class JApiGenericTemplate
implements JApiHasChangeStatus,
JApiHasGenericTypes,
JApiCompatibility {
    private final String name;
    private final Optional<String> oldType;
    private final Optional<String> newType;
    private List<JApiGenericType> oldInterfaceTypes;
    private List<JApiGenericType> newInterfaceTypes;
    private List<JApiGenericType> oldGenericTypes;
    private List<JApiGenericType> newGenericTypes;
    private final JApiChangeStatus changeStatus;
    private final List<JApiCompatibilityChange> compatibilityChanges = new ArrayList<JApiCompatibilityChange>();

    public JApiGenericTemplate(JApiChangeStatus changeStatus, String name, Optional<String> oldType, Optional<String> newType) {
        this.changeStatus = changeStatus;
        this.name = name;
        this.oldType = oldType;
        this.newType = newType;
    }

    @Override
    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    @XmlTransient
    public Optional<String> getOldTypeOptional() {
        return this.oldType;
    }

    @XmlTransient
    public Optional<String> getNewTypeOptional() {
        return this.newType;
    }

    @XmlAttribute(name="oldType")
    public String getOldType() {
        return this.oldType.orElse("n.a.");
    }

    @XmlAttribute(name="newType")
    public String getNewType() {
        return this.newType.orElse("n.a.");
    }

    @Override
    @XmlElementWrapper(name="oldGenericTypes")
    @XmlElement(name="oldGenericType")
    public List<JApiGenericType> getOldGenericTypes() {
        if (this.oldGenericTypes == null) {
            this.oldGenericTypes = new ArrayList<JApiGenericType>();
        }
        return this.oldGenericTypes;
    }

    @Override
    @XmlElementWrapper(name="newGenericTypes")
    @XmlElement(name="newGenericType")
    public List<JApiGenericType> getNewGenericTypes() {
        if (this.newGenericTypes == null) {
            this.newGenericTypes = new ArrayList<JApiGenericType>();
        }
        return this.newGenericTypes;
    }

    public String toString() {
        return this.name + ":" + this.oldType;
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        boolean binaryCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isBinaryCompatible()) continue;
            binaryCompatible = false;
            break;
        }
        return binaryCompatible;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        boolean sourceCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isSourceCompatible()) continue;
            sourceCompatible = false;
            break;
        }
        return sourceCompatible;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return this.compatibilityChanges;
    }

    @XmlElementWrapper(name="oldInterfaceTypes")
    @XmlElement(name="oldInterfaceType")
    public List<JApiGenericType> getOldInterfaceTypes() {
        if (this.oldInterfaceTypes == null) {
            this.oldInterfaceTypes = new ArrayList<JApiGenericType>();
        }
        return this.oldInterfaceTypes;
    }

    @XmlElementWrapper(name="newInterfaceTypes")
    @XmlElement(name="newInterfaceType")
    public List<JApiGenericType> getNewInterfaceTypes() {
        if (this.newInterfaceTypes == null) {
            this.newInterfaceTypes = new ArrayList<JApiGenericType>();
        }
        return this.newInterfaceTypes;
    }
}

