/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.model.AccessModifier;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiHasChangeStatus;
import japicmp.util.OptionalHelper;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAttribute;

public class JApiModifier<T>
implements JApiHasChangeStatus {
    private final Optional<T> oldModifier;
    private final Optional<T> newModifier;
    private final JApiChangeStatus changeStatus;

    public JApiModifier(Optional<T> oldModifier, Optional<T> newModifier, JApiChangeStatus changeStatus) {
        this.oldModifier = oldModifier;
        this.newModifier = newModifier;
        this.changeStatus = changeStatus;
    }

    public Optional<T> getOldModifier() {
        return this.oldModifier;
    }

    public Optional<T> getNewModifier() {
        return this.newModifier;
    }

    @Override
    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlAttribute(name="oldValue")
    public String getValueOld() {
        return OptionalHelper.optionalToString(this.oldModifier);
    }

    @XmlAttribute(name="newValue")
    public String getValueNew() {
        return OptionalHelper.optionalToString(this.newModifier);
    }

    public boolean hasChangedFromTo(T oldValue, T newValue) {
        boolean hasChanged = false;
        if (this.oldModifier.isPresent() && this.newModifier.isPresent() && this.oldModifier.get() == oldValue && this.newModifier.get() == newValue) {
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean hasChangedFrom(T oldValue) {
        boolean hasChanged = false;
        if (this.oldModifier.isPresent() && this.newModifier.isPresent()) {
            if (this.oldModifier.get() == oldValue && this.newModifier.get() != oldValue) {
                hasChanged = true;
            }
        } else if (this.oldModifier.isPresent()) {
            if (this.oldModifier.get() == oldValue) {
                hasChanged = true;
            }
        } else {
            hasChanged = true;
        }
        return hasChanged;
    }

    public boolean hasChangedTo(T value) {
        boolean hasChangedTo = false;
        if (this.oldModifier.isPresent() && this.newModifier.isPresent()) {
            T newValue = this.newModifier.get();
            T oldValue = this.oldModifier.get();
            if (value == newValue && oldValue != value) {
                hasChangedTo = true;
            }
        }
        return hasChangedTo;
    }

    public boolean hasChangedToMoreVisible() {
        boolean hasChangedTo = false;
        if (this.oldModifier.isPresent() && this.newModifier.isPresent()) {
            T oldValue = this.oldModifier.get();
            T newValue = this.newModifier.get();
            if (oldValue instanceof AccessModifier && newValue instanceof AccessModifier) {
                return ((AccessModifier)newValue).getLevel() > ((AccessModifier)oldValue).getLevel();
            }
        }
        return hasChangedTo;
    }
}

