/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiGenericType;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasGenericTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class JApiParameter
implements JApiHasGenericTypes,
JApiHasChangeStatus,
JApiCompatibility {
    private String type;
    private Optional<String> templateName;
    private final List<JApiGenericType> oldGenericTypes = new ArrayList<JApiGenericType>();
    private final List<JApiGenericType> newGenericTypes = new ArrayList<JApiGenericType>();
    private final List<JApiCompatibilityChange> compatibilityChanges = new ArrayList<JApiCompatibilityChange>();
    private final JApiChangeStatus changeStatus = JApiChangeStatus.UNCHANGED;

    public JApiParameter(String type, Optional<String> templateName) {
        this.type = type;
        this.templateName = templateName;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTemplateName(Optional<String> templateName) {
        this.templateName = templateName;
    }

    @Override
    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlAttribute(name="type")
    public String getType() {
        return this.type;
    }

    @XmlAttribute(name="templateName")
    public String getTemplateName() {
        return this.templateName.orElse("N/A");
    }

    public Optional<String> getTemplateNameOptional() {
        return this.templateName;
    }

    @Override
    @XmlElementWrapper(name="oldGenericTypes")
    @XmlElement(name="oldGenericType")
    public List<JApiGenericType> getOldGenericTypes() {
        return this.oldGenericTypes;
    }

    @Override
    @XmlElementWrapper(name="newGenericTypes")
    @XmlElement(name="newGenericType")
    public List<JApiGenericType> getNewGenericTypes() {
        return this.newGenericTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JApiParameter that = (JApiParameter)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        boolean binaryCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isBinaryCompatible()) continue;
            binaryCompatible = false;
            break;
        }
        return binaryCompatible;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        boolean sourceCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isSourceCompatible()) continue;
            sourceCompatible = false;
            break;
        }
        return sourceCompatible;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return this.compatibilityChanges;
    }
}

