/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiGenericType;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasGenericTypes;
import japicmp.util.OptionalHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

public class JApiReturnType
implements JApiHasGenericTypes,
JApiHasChangeStatus,
JApiCompatibility {
    private final Optional<String> oldReturnTypeOptional;
    private final Optional<String> newReturnTypeOptional;
    private final JApiChangeStatus changeStatus;
    private final List<JApiGenericType> oldGenericTypes = new ArrayList<JApiGenericType>();
    private final List<JApiGenericType> newGenericTypes = new ArrayList<JApiGenericType>();
    private final List<JApiCompatibilityChange> compatibilityChanges = new ArrayList<JApiCompatibilityChange>();

    public JApiReturnType(JApiChangeStatus changeStatus, Optional<String> oldReturnTypeOptional, Optional<String> newReturnTypeOptional) {
        this.changeStatus = changeStatus;
        this.oldReturnTypeOptional = oldReturnTypeOptional;
        this.newReturnTypeOptional = newReturnTypeOptional;
    }

    @Override
    @XmlAttribute(name="changeStatus")
    public JApiChangeStatus getChangeStatus() {
        return this.changeStatus;
    }

    @XmlAttribute(name="oldValue")
    public String getOldReturnType() {
        return OptionalHelper.optionalToString(this.oldReturnTypeOptional);
    }

    @XmlAttribute(name="newValue")
    public String getNewReturnType() {
        return OptionalHelper.optionalToString(this.newReturnTypeOptional);
    }

    @Override
    @XmlElementWrapper(name="oldGenericTypes")
    @XmlElement(name="oldGenericType")
    public List<JApiGenericType> getOldGenericTypes() {
        return this.oldGenericTypes;
    }

    @Override
    @XmlElementWrapper(name="newGenericTypes")
    @XmlElement(name="newGenericType")
    public List<JApiGenericType> getNewGenericTypes() {
        return this.newGenericTypes;
    }

    public String toString() {
        return "JApiReturnType [oldReturnTypeOptional=" + this.oldReturnTypeOptional + ", newReturnTypeOptional=" + this.newReturnTypeOptional + ", changeStatus=" + (Object)((Object)this.changeStatus) + "]";
    }

    @Override
    @XmlAttribute
    public boolean isBinaryCompatible() {
        boolean binaryCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isBinaryCompatible()) continue;
            binaryCompatible = false;
            break;
        }
        return binaryCompatible;
    }

    @Override
    @XmlAttribute
    public boolean isSourceCompatible() {
        boolean sourceCompatible = true;
        for (JApiCompatibilityChange compatibilityChange : this.compatibilityChanges) {
            if (compatibilityChange.isSourceCompatible()) continue;
            sourceCompatible = false;
            break;
        }
        return sourceCompatible;
    }

    @Override
    @XmlElementWrapper(name="compatibilityChanges")
    @XmlElement(name="compatibilityChange")
    public List<JApiCompatibilityChange> getCompatibilityChanges() {
        return this.compatibilityChanges;
    }
}

