/*
 * Decompiled with CFR 0.152.
 */
package japicmp.model;

import japicmp.cmp.JarArchiveComparator;
import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.exception.JApiCmpException;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiClassType;
import japicmp.model.JApiField;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiJavaObjectSerializationCompatibility;
import japicmp.model.JApiModifier;
import japicmp.model.JApiSerialVersionUid;
import japicmp.model.JApiSuperclass;
import japicmp.model.StaticModifier;
import japicmp.model.TransientModifier;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.SerialVersionUID;

public class JavaObjectSerializationCompatibility {
    private static final Logger LOGGER = Logger.getLogger(JavaObjectSerializationCompatibility.class.getName());
    private static final String SERIAL_VERSION_UID = "serialVersionUID";

    public static JApiSerialVersionUid extractSerialVersionUid(JarArchiveComparatorOptions options, JarArchiveComparator jarArchiveComparator, Optional<CtClass> oldClass, Optional<CtClass> newClass) {
        SerialVersionUidResult resultOld = JavaObjectSerializationCompatibility.computeSerialVersionUid(options, oldClass, jarArchiveComparator);
        SerialVersionUidResult resultNew = JavaObjectSerializationCompatibility.computeSerialVersionUid(options, newClass, jarArchiveComparator);
        return new JApiSerialVersionUid(resultOld.serializable, resultNew.serializable, resultOld.serialVersionUidDefault, resultNew.serialVersionUidDefault, resultOld.serialVersionUid, resultNew.serialVersionUid);
    }

    public void evaluate(List<JApiClass> jApiClasses) {
        for (JApiClass jApiClass : jApiClasses) {
            this.computeChangeStatus(jApiClass);
        }
    }

    private static SerialVersionUidResult computeSerialVersionUid(JarArchiveComparatorOptions options, Optional<CtClass> ctClassOptional, JarArchiveComparator jarArchiveComparator) {
        CtClass ctClass;
        SerialVersionUidResult result = new SerialVersionUidResult();
        if (ctClassOptional.isPresent() && JavaObjectSerializationCompatibility.isCtClassSerializable(options, ctClass = ctClassOptional.get(), jarArchiveComparator)) {
            Object constantValue;
            CtField declaredField;
            result.serializable = true;
            try {
                CtField declaredField2 = ctClass.getDeclaredField(SERIAL_VERSION_UID);
                Object constantValue2 = declaredField2.getConstantValue();
                if (constantValue2 instanceof Long) {
                    result.serialVersionUid = Optional.of((Long)constantValue2);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to get serialVersionUid from class " + ctClass.getName() + ": " + e.getLocalizedMessage(), e);
                try {
                    SerialVersionUID.setSerialVersionUID(ctClass);
                    declaredField = ctClass.getDeclaredField(SERIAL_VERSION_UID);
                    constantValue = declaredField.getConstantValue();
                    if (constantValue instanceof Long) {
                        result.serialVersionUidDefault = Optional.of((Long)constantValue);
                    }
                    ctClass.removeField(declaredField);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to compute default serialVersionUid for class " + ctClass.getName() + ": " + ex.getLocalizedMessage(), ex);
                }
            }
            if (!result.serialVersionUidDefault.isPresent()) {
                try {
                    CtField declaredFieldOriginal = ctClass.getDeclaredField(SERIAL_VERSION_UID);
                    ctClass.removeField(declaredFieldOriginal);
                    SerialVersionUID.setSerialVersionUID(ctClass);
                    declaredField = ctClass.getDeclaredField(SERIAL_VERSION_UID);
                    constantValue = declaredField.getConstantValue();
                    if (constantValue instanceof Long) {
                        result.serialVersionUidDefault = Optional.of((Long)constantValue);
                    }
                    ctClass.removeField(declaredField);
                    ctClass.addField(declaredFieldOriginal);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to compute default serialVersionUid for class " + ctClass.getName() + ": " + ex.getLocalizedMessage(), ex);
                }
            }
        }
        return result;
    }

    private static boolean isCtClassSerializable(JarArchiveComparatorOptions options, CtClass clazz, JarArchiveComparator jarArchiveComparator) {
        ClassPool pool = clazz.getClassPool();
        try {
            return clazz.subtypeOf(pool.get("java.io.Serializable"));
        }
        catch (NotFoundException e) {
            if (options.getIgnoreMissingClasses().ignoreClass(e.getMessage())) {
                return false;
            }
            throw JApiCmpException.forClassLoading(e, clazz.getName(), jarArchiveComparator);
        }
    }

    private void computeChangeStatus(JApiClass jApiClass) {
        JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.NOT_SERIALIZABLE;
        JApiSerialVersionUid jApiSerialVersionUid = jApiClass.getSerialVersionUid();
        if ((jApiSerialVersionUid.isSerializableOld() || jApiSerialVersionUid.isSerializableNew()) && !(state = this.checkChanges(jApiClass)).isIncompatible()) {
            if (jApiSerialVersionUid.getSerialVersionUidInClassOld().isPresent() && jApiSerialVersionUid.getSerialVersionUidInClassNew().isPresent()) {
                Long suidNew;
                Long suidOld = jApiSerialVersionUid.getSerialVersionUidInClassOld().get();
                state = suidOld.equals(suidNew = jApiSerialVersionUid.getSerialVersionUidInClassNew().get()) ? JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE : JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_SERIALVERSIONUID_MODIFIED;
            } else if (jApiSerialVersionUid.getSerialVersionUidInClassOld().isPresent()) {
                Long suidNewDefault;
                Long suidOld = jApiSerialVersionUid.getSerialVersionUidInClassOld().get();
                state = jApiClass.getChangeStatus() != JApiChangeStatus.REMOVED ? (jApiSerialVersionUid.isSerializableNew() ? (jApiSerialVersionUid.getSerialVersionUidDefaultNew().isPresent() ? (suidOld.equals(suidNewDefault = jApiSerialVersionUid.getSerialVersionUidDefaultNew().get()) ? JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE : JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_SERIALVERSIONUID_REMOVED_AND_NOT_MATCHES_NEW_DEFAULT) : JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_CLASS_REMOVED) : JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_SERIALIZABLE_REMOVED) : JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_CLASS_REMOVED;
            } else if (jApiSerialVersionUid.getSerialVersionUidInClassNew().isPresent()) {
                if (jApiClass.getChangeStatus() != JApiChangeStatus.NEW) {
                    if (jApiSerialVersionUid.isSerializableOld()) {
                        Long suidOldDefault;
                        Long suidNew = jApiSerialVersionUid.getSerialVersionUidInClassNew().get();
                        state = jApiSerialVersionUid.getSerialVersionUidDefaultOld().isPresent() ? (suidNew.equals(suidOldDefault = jApiSerialVersionUid.getSerialVersionUidDefaultOld().get()) ? JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE : JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_SERIALVERSIONUID_REMOVED_AND_NOT_MATCHES_NEW_DEFAULT) : JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE;
                    }
                } else {
                    state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE;
                }
            } else if (jApiClass.getChangeStatus() == JApiChangeStatus.NEW) {
                state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE;
            } else if (jApiClass.getChangeStatus() == JApiChangeStatus.REMOVED) {
                state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_CLASS_REMOVED;
            } else if (!this.isEnum(jApiClass)) {
                Long defaultNew;
                Long defaultOld;
                state = jApiSerialVersionUid.getSerialVersionUidDefaultOld().isPresent() && jApiSerialVersionUid.getSerialVersionUidDefaultNew().isPresent() ? ((defaultOld = jApiSerialVersionUid.getSerialVersionUidDefaultOld().get()).equals(defaultNew = jApiSerialVersionUid.getSerialVersionUidDefaultNew().get()) ? JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE : JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_DEFAULT_SERIALVERSIONUID_CHANGED) : (jApiSerialVersionUid.getSerialVersionUidDefaultOld().isPresent() ? JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_SERIALIZABLE_REMOVED : JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE);
            }
        }
        jApiClass.setJavaObjectSerializationCompatible(state);
    }

    private boolean isEnum(JApiClass jApiClass) {
        return jApiClass.getClassType().getNewTypeOptional().isPresent() && jApiClass.getClassType().getNewTypeOptional().get() == JApiClassType.ClassType.ENUM;
    }

    private JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus checkChanges(JApiClass jApiClass) {
        JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE;
        if (jApiClass.getChangeStatus() == JApiChangeStatus.REMOVED) {
            return JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_CLASS_REMOVED;
        }
        if ((state = this.checkChangesForClassType(jApiClass, state)) != JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE) {
            return state;
        }
        if ((state = this.checkChangesForSuperclass(jApiClass, state)) != JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE) {
            return state;
        }
        if ((state = this.checkChangesForFields(jApiClass, state)) != JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE) {
            return state;
        }
        state = this.checkChangesForInterfaces(jApiClass, state);
        return state;
    }

    private JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus checkChangesForSuperclass(JApiClass jApiClass, JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus state) {
        JApiSuperclass jApiClassSuperclass = jApiClass.getSuperclass();
        if (jApiClassSuperclass.getChangeStatus() == JApiChangeStatus.MODIFIED) {
            state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_SUPERCLASS_MODIFIED;
        }
        return state;
    }

    private JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus checkChangesForClassType(JApiClass jApiClass, JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus state) {
        JApiClassType.ClassType newClassType;
        JApiClassType.ClassType oldClassType;
        JApiClassType classType = jApiClass.getClassType();
        if (classType.getChangeStatus() == JApiChangeStatus.MODIFIED && (oldClassType = classType.getOldTypeOptional().get()) != (newClassType = classType.getNewTypeOptional().get())) {
            state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_CLASS_TYPE_MODIFIED;
        }
        return state;
    }

    private JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus checkChangesForInterfaces(JApiClass jApiClass, JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus state) {
        boolean serializableAdded = false;
        boolean serializableRemoved = false;
        boolean serializableUnchanged = false;
        boolean externalizableAdded = false;
        boolean externalizableRemoved = false;
        for (JApiImplementedInterface implementedInterface : jApiClass.getInterfaces()) {
            if (Serializable.class.getCanonicalName().equals(implementedInterface.getFullyQualifiedName())) {
                if (implementedInterface.getChangeStatus() == JApiChangeStatus.NEW) {
                    serializableAdded = true;
                } else if (implementedInterface.getChangeStatus() == JApiChangeStatus.REMOVED) {
                    serializableRemoved = true;
                } else if (implementedInterface.getChangeStatus() == JApiChangeStatus.UNCHANGED) {
                    serializableUnchanged = true;
                }
            }
            if (!Externalizable.class.getCanonicalName().equals(implementedInterface.getFullyQualifiedName())) continue;
            if (implementedInterface.getChangeStatus() == JApiChangeStatus.NEW) {
                externalizableAdded = true;
                continue;
            }
            if (implementedInterface.getChangeStatus() != JApiChangeStatus.REMOVED) continue;
            externalizableRemoved = true;
        }
        if (serializableRemoved) {
            state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_SERIALIZABLE_REMOVED;
        }
        if (externalizableRemoved) {
            state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_EXTERNALIZABLE_REMOVED;
        }
        if ((serializableRemoved || serializableUnchanged || serializableAdded) && externalizableAdded) {
            state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_CHANGED_FROM_SERIALIZABLE_TO_EXTERNALIZABLE;
        }
        if ((serializableUnchanged || serializableAdded) && externalizableRemoved) {
            state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_CHANGED_FROM_EXTERNALIZABLE_TO_SERIALIZABLE;
        }
        return state;
    }

    private JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus checkChangesForFields(JApiClass jApiClass, JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus state) {
        for (JApiField field : jApiClass.getFields()) {
            JApiModifier<TransientModifier> transientModifier;
            JApiModifier<StaticModifier> staticModifier;
            if (field.getChangeStatus() == JApiChangeStatus.REMOVED && !SERIAL_VERSION_UID.equals(field.getName())) {
                state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_FIELD_REMOVED;
            }
            if ((staticModifier = field.getStaticModifier()).getOldModifier().isPresent() && staticModifier.getNewModifier().isPresent() && staticModifier.getOldModifier().get() == StaticModifier.NON_STATIC && staticModifier.getNewModifier().get() == StaticModifier.STATIC) {
                state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_FIELD_CHANGED_FROM_NONSTATIC_TO_STATIC;
            }
            if ((transientModifier = field.getTransientModifier()).getOldModifier().isPresent() && transientModifier.getNewModifier().isPresent() && transientModifier.getOldModifier().get() == TransientModifier.NON_TRANSIENT && transientModifier.getNewModifier().get() == TransientModifier.TRANSIENT) {
                state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_FIELD_CHANGED_FROM_NONTRANSIENT_TO_TRANSIENT;
            }
            if (field.getType().getChangeStatus() != JApiChangeStatus.MODIFIED) continue;
            state = JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_INCOMPATIBLE_FIELD_TYPE_MODIFIED;
        }
        return state;
    }

    private static class SerialVersionUidResult {
        boolean serializable = false;
        Optional<Long> serialVersionUid = Optional.empty();
        Optional<Long> serialVersionUidDefault = Optional.empty();

        private SerialVersionUidResult() {
        }
    }
}

