/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output;

import japicmp.model.JApiAnnotation;
import japicmp.model.JApiClass;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiField;
import japicmp.model.JApiHasAnnotations;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiMethod;
import japicmp.model.JApiSuperclass;
import java.util.Iterator;
import java.util.List;

public class Filter {
    public static void filter(List<JApiClass> jApiClasses, FilterVisitor visitor) {
        Iterator<JApiClass> itClasses = jApiClasses.iterator();
        while (itClasses.hasNext()) {
            JApiClass jApiClass = itClasses.next();
            Iterator<JApiMethod> itMethods = jApiClass.getMethods().iterator();
            while (itMethods.hasNext()) {
                JApiMethod jApiMethod = itMethods.next();
                visitor.visit(itMethods, jApiMethod);
                Filter.visitAnnotations(visitor, jApiMethod);
            }
            Iterator<JApiConstructor> itConstructors = jApiClass.getConstructors().iterator();
            while (itConstructors.hasNext()) {
                JApiConstructor jApiConstructor = itConstructors.next();
                visitor.visit(itConstructors, jApiConstructor);
                Filter.visitAnnotations(visitor, jApiConstructor);
            }
            Iterator<JApiImplementedInterface> itInterfaces = jApiClass.getInterfaces().iterator();
            while (itInterfaces.hasNext()) {
                JApiImplementedInterface jApiImplementedInterface = itInterfaces.next();
                visitor.visit(itInterfaces, jApiImplementedInterface);
            }
            JApiSuperclass superclass = jApiClass.getSuperclass();
            visitor.visit(superclass);
            Iterator<JApiField> itFields = jApiClass.getFields().iterator();
            while (itFields.hasNext()) {
                JApiField jApiField = itFields.next();
                visitor.visit(itFields, jApiField);
                Filter.visitAnnotations(visitor, jApiField);
            }
            Filter.visitAnnotations(visitor, jApiClass);
            visitor.visit(itClasses, jApiClass);
        }
    }

    private static void visitAnnotations(FilterVisitor visitor, JApiHasAnnotations jApiHasAnnotations) {
        Iterator<JApiAnnotation> itAnnotations = jApiHasAnnotations.getAnnotations().iterator();
        while (itAnnotations.hasNext()) {
            JApiAnnotation jApiAnnotation = itAnnotations.next();
            visitor.visit(itAnnotations, jApiAnnotation);
        }
    }

    public static interface FilterVisitor {
        public void visit(Iterator<JApiClass> var1, JApiClass var2);

        public void visit(Iterator<JApiMethod> var1, JApiMethod var2);

        public void visit(Iterator<JApiConstructor> var1, JApiConstructor var2);

        public void visit(Iterator<JApiImplementedInterface> var1, JApiImplementedInterface var2);

        public void visit(Iterator<JApiField> var1, JApiField var2);

        public void visit(Iterator<JApiAnnotation> var1, JApiAnnotation var2);

        public void visit(JApiSuperclass var1);
    }
}

