/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.html;

import japicmp.config.Options;
import japicmp.exception.JApiCmpException;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiAnnotationElement;
import japicmp.model.JApiAnnotationElementValue;
import japicmp.model.JApiBehavior;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiClassFileFormatVersion;
import japicmp.model.JApiClassType;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiException;
import japicmp.model.JApiField;
import japicmp.model.JApiGenericTemplate;
import japicmp.model.JApiGenericType;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasGenericTemplates;
import japicmp.model.JApiHasGenericTypes;
import japicmp.model.JApiHasModifiers;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiJavaObjectSerializationCompatibility;
import japicmp.model.JApiMethod;
import japicmp.model.JApiModifier;
import japicmp.model.JApiReturnType;
import japicmp.model.JApiSerialVersionUid;
import japicmp.model.JApiSuperclass;
import japicmp.model.JApiType;
import japicmp.output.OutputFilter;
import japicmp.output.OutputGenerator;
import japicmp.output.html.HtmlOutput;
import japicmp.output.html.HtmlOutputGeneratorOptions;
import japicmp.output.html.TemplateEngine;
import japicmp.util.Streams;
import japicmp.util.StringHelper;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HtmlOutputGenerator
extends OutputGenerator<HtmlOutput> {
    private final HtmlOutputGeneratorOptions htmlOutputGeneratorOptions;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private final TemplateEngine templateEngine;

    public HtmlOutputGenerator(List<JApiClass> jApiClasses, Options options, HtmlOutputGeneratorOptions htmlOutputGeneratorOptions) {
        super(options, jApiClasses);
        this.htmlOutputGeneratorOptions = htmlOutputGeneratorOptions;
        this.templateEngine = new TemplateEngine();
    }

    @Override
    public HtmlOutput generate() {
        OutputFilter outputFilter = new OutputFilter(this.options);
        outputFilter.filter(this.jApiClasses);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>\n");
        sb.append("<head>\n");
        sb.append("<title>").append(this.getTitle()).append("</title>\n");
        sb.append("<style>\n").append(this.getStyle()).append("\n</style>\n");
        sb.append("</head>\n");
        sb.append("<body>\n");
        sb.append("<span class=\"title\">").append(this.getTitle()).append("</span>\n");
        sb.append("<br/>\n");
        this.metaInformation(sb);
        this.warningMissingClasses(sb);
        this.toc(sb);
        this.explanations(sb);
        this.classes(sb);
        sb.append("</body>\n");
        sb.append("</html>\n");
        return new HtmlOutput(sb.toString());
    }

    private void classes(StringBuilder sb) {
        if (this.options.isReportOnlySummary()) {
            return;
        }
        sb.append(this.jApiClasses.stream().map(jApiClass -> this.templateEngine.loadAndFillTemplate("/html/class-entry.html", this.mapOf("fullyQualifiedName", jApiClass.getFullyQualifiedName(), "outputChangeStatus", this.outputChangeStatus((JApiHasChangeStatus)jApiClass), "javaObjectSerializationCompatible", this.javaObjectSerializationCompatible((JApiClass)jApiClass), "modifiers", this.modifiers((JApiHasModifiers)jApiClass), "classType", this.classType((JApiClass)jApiClass), "compatibilityChanges", this.compatibilityChanges((JApiCompatibility)jApiClass, false), "classFileFormatVersion", this.classFileFormatVersion((JApiClass)jApiClass), "genericTemplates", this.genericTemplates((JApiHasGenericTemplates)jApiClass, false), "superclass", this.superclass((JApiClass)jApiClass), "interfaces", this.interfaces((JApiClass)jApiClass), "serialVersionUid", this.serialVersionUid((JApiClass)jApiClass), "fields", this.fields((JApiClass)jApiClass), "constructors", this.constructors((JApiClass)jApiClass), "methods", this.methods((JApiClass)jApiClass), "annotations", this.annotations(jApiClass.getAnnotations())))).collect(Collectors.joining()));
    }

    private String methods(JApiClass jApiClass) {
        if (!jApiClass.getMethods().isEmpty()) {
            return this.templateEngine.loadAndFillTemplate("/html/methods.html", this.mapOf("tbody", this.methodsTBody(jApiClass.getMethods())));
        }
        return "";
    }

    private String methodsTBody(List<JApiMethod> methods) {
        return methods.stream().sorted(Comparator.comparing(JApiBehavior::getName)).map(method -> "<tr>\n<td>" + this.outputChangeStatus((JApiHasChangeStatus)method) + "</td>\n<td>" + this.modifiers((JApiHasModifiers)method) + "</td>\n<td>" + this.genericTemplates((JApiHasGenericTemplates)method, true) + "</td>\n<td>" + this.returnType((JApiMethod)method) + "</td>\n<td>" + method.getName() + "(" + this.parameters((JApiBehavior)method) + ")" + this.annotations(method.getAnnotations()) + "</td>\n<td>" + this.exceptions((JApiBehavior)method) + "</td>\n<td>" + this.compatibilityChanges((JApiCompatibility)method, true) + "</td>\n<td>" + this.templateEngine.loadAndFillTemplate("/html/line-numbers.html", this.mapOf("oldLineNumber", method.getOldLineNumberAsString(), "newLineNumber", method.getNewLineNumberAsString())) + "</td>\n</tr>\n").collect(Collectors.joining());
    }

    private String returnType(JApiMethod method) {
        return "<span class=\"method_return_type " + method.getReturnType().getChangeStatus().name().toLowerCase() + "\">" + this.returnTypeValue(method.getReturnType()) + "</span>";
    }

    private String returnTypeValue(JApiReturnType returnType) {
        switch (returnType.getChangeStatus()) {
            case NEW: 
            case UNCHANGED: {
                return returnType.getNewReturnType() + this.genericParameterTypes(returnType);
            }
            case REMOVED: {
                return returnType.getOldReturnType() + this.genericParameterTypes(returnType);
            }
            case MODIFIED: {
                return returnType.getNewReturnType() + "&#160;(&lt;-&#160;" + returnType.getOldReturnType() + this.genericParameterTypes(returnType);
            }
        }
        return "";
    }

    private String constructors(JApiClass jApiClass) {
        if (!jApiClass.getConstructors().isEmpty()) {
            return this.templateEngine.loadAndFillTemplate("/html/constructors.html", this.mapOf("tbody", this.constructors(jApiClass.getConstructors())));
        }
        return "";
    }

    private String constructors(List<JApiConstructor> constructors) {
        return constructors.stream().map(constructor -> "<tr>\n<td>" + this.outputChangeStatus((JApiHasChangeStatus)constructor) + "</td>\n<td>" + this.modifiers((JApiHasModifiers)constructor) + "</td>\n<td>" + this.genericTemplates((JApiHasGenericTemplates)constructor, true) + "</td>\n<td>" + constructor.getName() + "(" + this.parameters((JApiBehavior)constructor) + ")" + this.annotations(constructor.getAnnotations()) + "</td>\n<td>" + this.exceptions((JApiBehavior)constructor) + "</td>\n<td>" + this.compatibilityChanges((JApiCompatibility)constructor, true) + "</td>\n<td>" + this.templateEngine.loadAndFillTemplate("/html/line-numbers.html", this.mapOf("oldLineNumber", constructor.getOldLineNumberAsString(), "newLineNumber", constructor.getNewLineNumberAsString())) + "</td>\n</tr>\n").collect(Collectors.joining());
    }

    private String exceptions(JApiBehavior jApiBehavior) {
        if (!jApiBehavior.getExceptions().isEmpty()) {
            return this.templateEngine.loadAndFillTemplate("/html/exceptions.html", this.mapOf("tbody", this.exceptionsTBody(jApiBehavior.getExceptions())));
        }
        return "";
    }

    private String exceptionsTBody(List<JApiException> exceptions) {
        return exceptions.stream().map(exc -> "<tr>\n<td>" + this.outputChangeStatus((JApiHasChangeStatus)exc) + "</td>\n<td>" + exc.getName() + "</td>\n</tr>\n").collect(Collectors.joining());
    }

    private String parameters(JApiBehavior jApiBehavior) {
        return jApiBehavior.getParameters().stream().map(parameter -> "<span class=\"method_parameter " + parameter.getChangeStatus().name().toLowerCase() + "\">" + parameter.getType() + this.genericParameterTypes((JApiHasGenericTypes)parameter) + this.binaryAndSourceCompatibility((JApiCompatibility)parameter) + "</span>").collect(Collectors.joining(", "));
    }

    private String fields(JApiClass jApiClass) {
        if (!jApiClass.getFields().isEmpty()) {
            return this.templateEngine.loadAndFillTemplate("/html/fields.html", this.mapOf("tbody", this.fields(jApiClass.getFields())));
        }
        return "";
    }

    private String fields(List<JApiField> fields) {
        return fields.stream().sorted(Comparator.comparing(JApiField::getName)).map(field -> "<tr>\n<td>" + this.outputChangeStatus((JApiHasChangeStatus)field) + "</td>\n<td>" + this.modifiers((JApiHasModifiers)field) + "</td>\n<td>" + this.type((JApiField)field) + "</td>\n<td>" + field.getName() + this.annotations(field.getAnnotations()) + "</td>\n<td>" + this.compatibilityChanges((JApiCompatibility)field, true) + "</td>\n</tr>\n").collect(Collectors.joining());
    }

    private String type(JApiField field) {
        return "<span class=\"modifier " + field.getType().getChangeStatus().name().toLowerCase() + "\">" + this.typeValue(field) + "</span>";
    }

    private String typeValue(JApiField field) {
        JApiType type = field.getType();
        switch (type.getChangeStatus()) {
            case NEW: 
            case UNCHANGED: {
                return type.getNewValue() + this.genericParameterTypes(field);
            }
            case REMOVED: {
                return type.getOldValue() + this.genericParameterTypes(field);
            }
            case MODIFIED: {
                return type.getNewValue() + "&#160;(&lt;-&#160;" + type.getOldValue() + this.genericParameterTypes(field);
            }
        }
        return "";
    }

    private String annotations(List<JApiAnnotation> annotations) {
        if (!annotations.isEmpty()) {
            return this.templateEngine.loadAndFillTemplate("/html/annotations.html", this.mapOf("tbody", this.annotationsTBody(annotations)));
        }
        return "";
    }

    private String annotationsTBody(List<JApiAnnotation> annotations) {
        return annotations.stream().sorted(Comparator.comparing(JApiAnnotation::getFullyQualifiedName)).map(annotation -> "<tr>\n<td>" + this.outputChangeStatus((JApiHasChangeStatus)annotation) + "</td>\n<td>" + annotation.getFullyQualifiedName() + "</td>\n<td>" + this.elements((JApiAnnotation)annotation) + "</td>\n</tr>\n").collect(Collectors.joining());
    }

    private String elements(JApiAnnotation annotation) {
        if (!annotation.getElements().isEmpty()) {
            return this.templateEngine.loadAndFillTemplate("/html/annotation-elements.html", this.mapOf("tbody", this.annotationElements(annotation.getElements())));
        }
        return "n.a.";
    }

    private String annotationElements(List<JApiAnnotationElement> elements) {
        return elements.stream().map(element -> "<tr>\n<td>" + this.outputChangeStatus((JApiHasChangeStatus)element) + "</td>\n<td>" + element.getName() + "</td>\n<td>" + element.getOldElementValues().stream().map(this::valueToString).collect(Collectors.joining(",<wbr/>")) + "</td>\n<td>" + element.getNewElementValues().stream().map(this::valueToString).collect(Collectors.joining(",<wbr/>")) + "</td>\n</tr>\n").collect(Collectors.joining());
    }

    private String valueToString(JApiAnnotationElementValue value) {
        switch (value.getType()) {
            case Annotation: {
                return "@" + value.getFullyQualifiedName() + "(" + this.values(value) + ")";
            }
            case Array: {
                return "{" + this.values(value) + "}";
            }
            case Enum: {
                return value.getFullyQualifiedName() + "." + value.getValue();
            }
        }
        return value.getValueString();
    }

    private String values(JApiAnnotationElementValue value) {
        return value.getValues().stream().map(this::valueToString).collect(Collectors.joining());
    }

    private String serialVersionUid(JApiClass jApiClass) {
        if (jApiClass.getSerialVersionUid().isSerializableOld() || jApiClass.getSerialVersionUid().isSerializableNew()) {
            return this.templateEngine.loadAndFillTemplate("/html/serial-version-uid.html", this.mapOf("tbody", this.serialVersionUidTBody(jApiClass.getSerialVersionUid())));
        }
        return "";
    }

    private String serialVersionUidTBody(JApiSerialVersionUid serialVersionUid) {
        return "<tr>\n<td class=\"matrix_layout\">Old</td><td class=\"" + (serialVersionUid.isSerializableOld() != serialVersionUid.isSerializableNew() ? "modified" : "") + "\">" + serialVersionUid.isSerializableOld() + "</td>\n<td class=\"" + (!serialVersionUid.getSerialVersionUidDefaultOldAsString().equals(serialVersionUid.getSerialVersionUidDefaultNewAsString()) ? "modified" : "") + "\">" + serialVersionUid.getSerialVersionUidDefaultOldAsString() + "</td>\n<td class=\"" + (!serialVersionUid.getSerialVersionUidInClassOldAsString().equals(serialVersionUid.getSerialVersionUidInClassNewAsString()) ? "modified" : "") + "\">" + serialVersionUid.getSerialVersionUidInClassOldAsString() + "</td>\n</tr>\n<tr>\n<td class=\"matrix_layout\">New</td><td class=\"" + (serialVersionUid.isSerializableOld() != serialVersionUid.isSerializableNew() ? "modified" : "") + "\">" + serialVersionUid.isSerializableNew() + "</td>\n<td class=\"" + (!serialVersionUid.getSerialVersionUidDefaultOldAsString().equals(serialVersionUid.getSerialVersionUidDefaultNewAsString()) ? "modified" : "") + "\">" + serialVersionUid.getSerialVersionUidDefaultNewAsString() + "</td>\n<td class=\"" + (!serialVersionUid.getSerialVersionUidInClassOldAsString().equals(serialVersionUid.getSerialVersionUidInClassNewAsString()) ? "modified" : "") + "\">" + serialVersionUid.getSerialVersionUidInClassNewAsString() + "</td>\n</tr>\n";
    }

    private String interfaces(JApiClass jApiClass) {
        if (!jApiClass.getInterfaces().isEmpty()) {
            return this.templateEngine.loadAndFillTemplate("/html/interfaces.html", this.mapOf("tbody", this.interfacesTBody(jApiClass.getInterfaces())));
        }
        return "";
    }

    private String interfacesTBody(List<JApiImplementedInterface> interfaces) {
        return interfaces.stream().map(interfaze -> "<tr>\n<td>" + this.outputChangeStatus((JApiHasChangeStatus)interfaze) + "</td>\n<td>" + interfaze.getFullyQualifiedName() + "</td>\n<td>" + this.compatibilityChanges((JApiCompatibility)interfaze, true) + "</td>\n</tr>\n").collect(Collectors.joining());
    }

    private String superclass(JApiClass jApiClass) {
        JApiSuperclass superclass = jApiClass.getSuperclass();
        if ((superclass.getOldSuperclass().isPresent() || superclass.getNewSuperclass().isPresent()) && (superclass.getChangeStatus() == JApiChangeStatus.NEW && !superclass.getSuperclassNew().equalsIgnoreCase("java.lang.Object") || superclass.getChangeStatus() == JApiChangeStatus.REMOVED && !superclass.getSuperclassOld().equalsIgnoreCase("java.lang.Object") || superclass.getChangeStatus() == JApiChangeStatus.MODIFIED || superclass.getChangeStatus() == JApiChangeStatus.UNCHANGED && !superclass.getSuperclassOld().equalsIgnoreCase("java.lang.Object"))) {
            return this.templateEngine.loadAndFillTemplate("/html/superclass.html", this.mapOf("tbody", this.superclassTBody(jApiClass.getSuperclass())));
        }
        return "";
    }

    private String superclassTBody(JApiSuperclass superclass) {
        return "<tr>\n<td>" + this.outputChangeStatus(superclass) + "</td>\n<td>" + this.superclassName(superclass) + "</td>\n<td>" + this.compatibilityChanges(superclass, true) + "</td>\n</tr>\n";
    }

    private String superclassName(JApiSuperclass superclass) {
        switch (superclass.getChangeStatus()) {
            case NEW: 
            case UNCHANGED: {
                return superclass.getSuperclassNew();
            }
            case REMOVED: {
                return superclass.getSuperclassOld();
            }
            case MODIFIED: {
                return superclass.getSuperclassNew() + "(&lt;-&#160;" + superclass.getSuperclassOld() + ")";
            }
        }
        return "";
    }

    private String genericTemplates(JApiHasGenericTemplates jApiHasGenericTemplates, boolean withNA) {
        List<JApiGenericTemplate> genericTemplates = jApiHasGenericTemplates.getGenericTemplates();
        if (!genericTemplates.isEmpty()) {
            return "<span class=\"label_class_member\">Generic Templates:</span>\n" + this.templateEngine.loadAndFillTemplate("/html/generic-templates.html", this.mapOf("tbody", this.genericTemplatesTBody(genericTemplates)));
        }
        return withNA ? "n.a." : "";
    }

    private String genericTemplatesTBody(List<JApiGenericTemplate> genericTemplates) {
        return genericTemplates.stream().map(jApiGenericTemplate -> "<tr>\n<td>" + this.outputChangeStatus((JApiHasChangeStatus)jApiGenericTemplate) + "</td>\n<td>" + jApiGenericTemplate.getName() + "</td>\n<td>" + jApiGenericTemplate.getOldType() + this.interfaceTypes(jApiGenericTemplate.getOldInterfaceTypes()) + "</td>\n<td>" + jApiGenericTemplate.getNewType() + "</td>\n<td>" + this.genericParameterTypes((JApiHasGenericTypes)jApiGenericTemplate) + "</td>\n</tr>\n").collect(Collectors.joining());
    }

    private String interfaceTypes(List<JApiGenericType> interfaceTypes) {
        if (!interfaceTypes.isEmpty()) {
            return interfaceTypes.stream().map(interfaceType -> "&#038; " + interfaceType.getType() + this.genericParameterTypesRecursive((JApiGenericType)interfaceType)).collect(Collectors.joining());
        }
        return "";
    }

    private String genericParameterTypesRecursive(JApiGenericType jApiGenericType) {
        if (!jApiGenericType.getGenericTypes().isEmpty()) {
            return "&#60;" + jApiGenericType.getGenericTypes().stream().map(jApiGenericType1 -> this.genericParameterWithWildcard((JApiGenericType)jApiGenericType1) + this.genericParameterTypesRecursive((JApiGenericType)jApiGenericType1)).collect(Collectors.joining(",")) + "&#62;";
        }
        return "";
    }

    private String genericParameterWithWildcard(JApiGenericType jApiGenericType) {
        switch (jApiGenericType.getGenericWildCard()) {
            case NONE: {
                return jApiGenericType.getType();
            }
            case EXTENDS: {
                return "? extends " + jApiGenericType.getType();
            }
            case SUPER: {
                return "? super " + jApiGenericType.getType();
            }
            case UNBOUNDED: {
                return "?";
            }
        }
        return "";
    }

    private String genericParameterTypes(JApiHasGenericTypes jApiHasGenericTypes) {
        if (!jApiHasGenericTypes.getNewGenericTypes().isEmpty() || !jApiHasGenericTypes.getOldGenericTypes().isEmpty()) {
            return "<div class=\"tooltip\"><span class=\"" + (!((JApiCompatibility)((Object)jApiHasGenericTypes)).isSourceCompatible() ? "modified method_parameter" : "unchanged method_parameter") + "\">&#60;..&#62;</span><div class=\"tooltiptext\"><table>" + this.genericTypes("New", jApiHasGenericTypes.getNewGenericTypes()) + this.genericTypes("Old", jApiHasGenericTypes.getOldGenericTypes()) + "</table></div></div>";
        }
        return "";
    }

    private String genericTypes(String header, List<JApiGenericType> genericTypes) {
        if (!genericTypes.isEmpty()) {
            return "<tr><td class=\"table_head_td\">" + header + ":</td>" + genericTypes.stream().map(genericType -> "<td>" + this.genericParameterWithWildcard((JApiGenericType)genericType) + this.genericParameterTypesRecursive((JApiGenericType)genericType) + "</td>").collect(Collectors.joining()) + "</tr>";
        }
        return "";
    }

    private String classFileFormatVersion(JApiClass jApiClass) {
        if (jApiClass.getClassFileFormatVersion().getChangeStatus() == JApiChangeStatus.MODIFIED) {
            return this.templateEngine.loadAndFillTemplate("/html/class-file-format-version.html", this.mapOf("tbody", this.classFileFormatVersionTBody(jApiClass)));
        }
        return "";
    }

    private String classFileFormatVersionTBody(JApiClass jApiClass) {
        JApiClassFileFormatVersion classFileFormatVersion = jApiClass.getClassFileFormatVersion();
        return "<tr>\n<td>" + this.outputChangeStatus(classFileFormatVersion) + "</td>\n<td>" + this.classFileFormatVersionString(classFileFormatVersion.getMajorVersionOld(), classFileFormatVersion.getMinorVersionOld()) + "</td>\n<td>" + this.classFileFormatVersionString(classFileFormatVersion.getMajorVersionNew(), classFileFormatVersion.getMinorVersionNew()) + "</td>\n</tr>\n";
    }

    private String classFileFormatVersionString(int majorVersion, int minorVersion) {
        if (majorVersion >= 0 && minorVersion >= 0) {
            return majorVersion + "." + minorVersion;
        }
        return "n.a.";
    }

    private String compatibilityChanges(JApiCompatibility jApiClass, boolean withNA) {
        if (!jApiClass.getCompatibilityChanges().isEmpty()) {
            return this.templateEngine.loadAndFillTemplate("/html/compatibility-changes.html", this.mapOf("tbody", jApiClass.getCompatibilityChanges().stream().map(this::compatibilityChange).collect(Collectors.joining())));
        }
        return withNA ? "n.a." : "";
    }

    private String compatibilityChange(JApiCompatibilityChange jApiCompatibilityChange) {
        return "<tr><td>" + (Object)((Object)jApiCompatibilityChange.getType()) + "</td></tr>\n";
    }

    private String classType(JApiClass jApiClass) {
        return "<span class=\"" + jApiClass.getClassType().getChangeStatus().name().toLowerCase() + "\">" + this.classTypeValue(jApiClass.getClassType()) + "</span>\n";
    }

    private String classTypeValue(JApiClassType classType) {
        if (classType.getChangeStatus() == JApiChangeStatus.MODIFIED) {
            return classType.getNewType().toLowerCase() + "&#160;(&lt;-&#160;" + classType.getOldType().toLowerCase() + ")";
        }
        if (classType.getChangeStatus() == JApiChangeStatus.NEW || classType.getChangeStatus() == JApiChangeStatus.UNCHANGED) {
            return classType.getNewType().toLowerCase();
        }
        if (classType.getChangeStatus() == JApiChangeStatus.REMOVED) {
            return classType.getOldType().toLowerCase();
        }
        return "";
    }

    private String modifiers(JApiHasModifiers jApiHasModifiers) {
        return jApiHasModifiers.getModifiers().stream().map(jApiModifier -> {
            String modifier = this.modifier((JApiModifier<? extends Enum<? extends Enum<?>>>)jApiModifier);
            if (!modifier.trim().isEmpty()) {
                return "<span class=\"modifier " + jApiModifier.getChangeStatus().name().toLowerCase() + "\">" + modifier + "</span>\n";
            }
            return "";
        }).collect(Collectors.joining());
    }

    private String modifier(JApiModifier<? extends Enum<? extends Enum<?>>> jApiModifier) {
        if (jApiModifier.getChangeStatus() == JApiChangeStatus.MODIFIED) {
            return jApiModifier.getValueNew() + "&#160;(&lt;-&#160;" + jApiModifier.getValueOld() + ")&#160;";
        }
        if (jApiModifier.getChangeStatus() == JApiChangeStatus.UNCHANGED) {
            return jApiModifier.getValueNew().toLowerCase().startsWith("non") || jApiModifier.getValueNew().equalsIgnoreCase("package_protected") ? "" : jApiModifier.getValueNew().toLowerCase();
        }
        if (jApiModifier.getChangeStatus() == JApiChangeStatus.NEW) {
            return jApiModifier.getValueNew().toLowerCase().startsWith("non") || jApiModifier.getValueNew().equalsIgnoreCase("package_protected") ? "" : jApiModifier.getValueNew().toLowerCase();
        }
        if (jApiModifier.getChangeStatus() == JApiChangeStatus.REMOVED) {
            return jApiModifier.getValueOld().toLowerCase().startsWith("non") || jApiModifier.getValueOld().equalsIgnoreCase("package_protected") ? "" : jApiModifier.getValueOld().toLowerCase();
        }
        return "";
    }

    private String javaObjectSerializationCompatible(JApiClass jApiClass) {
        if (jApiClass.getJavaObjectSerializationCompatible() == JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.NOT_SERIALIZABLE) {
            return "";
        }
        if (jApiClass.getJavaObjectSerializationCompatible() == JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus.SERIALIZABLE_COMPATIBLE) {
            return "<span class=\"new\">&#160;(Serializable compatible)&#160;</span>";
        }
        return "<span class=\"removed\">&#160;(Serializable incompatible(!): " + jApiClass.getJavaObjectSerializationCompatibleAsString() + ")&#160;</span>";
    }

    private void explanations(StringBuilder sb) {
        sb.append("<div class=\"explanations\">\n<span>Binary incompatible changes are marked with (!) while source incompatible changes are marked with (*).</span>\n</div>\n");
    }

    private void toc(StringBuilder sb) {
        if (!this.jApiClasses.isEmpty()) {
            sb.append("<ul>\n");
            sb.append("<li>\n");
            sb.append("<a href=\"#toc\">Classes</a>\n");
            sb.append("</li>\n");
            sb.append("</ul>\n");
            sb.append(this.templateEngine.loadAndFillTemplate("/html/toc.html", this.mapOf("tbody", this.tocEntries())));
        }
    }

    private String tocEntries() {
        return this.jApiClasses.stream().map(jApiClass -> this.templateEngine.loadAndFillTemplate("/html/toc-entry.html", this.mapOf("outputChangeStatus", this.outputChangeStatus((JApiHasChangeStatus)jApiClass), "fullyQualifiedName", jApiClass.getFullyQualifiedName()))).collect(Collectors.joining());
    }

    private String outputChangeStatus(JApiHasChangeStatus jApiHasChangeStatus) {
        return "<span class=\"" + jApiHasChangeStatus.getChangeStatus().name().toLowerCase() + "\">" + jApiHasChangeStatus.getChangeStatus().name() + (jApiHasChangeStatus instanceof JApiCompatibility ? this.binaryAndSourceCompatibility((JApiCompatibility)((Object)jApiHasChangeStatus)) : "") + "</span>";
    }

    private String binaryAndSourceCompatibility(JApiCompatibility jApiCompatibility) {
        if (!jApiCompatibility.isBinaryCompatible()) {
            return "&#160;(!)";
        }
        if (jApiCompatibility.isBinaryCompatible() && !jApiCompatibility.isSourceCompatible()) {
            return "&#160;(*)";
        }
        return "";
    }

    private void warningMissingClasses(StringBuilder sb) {
        if (this.options.getIgnoreMissingClasses().isIgnoreAllMissingClasses()) {
            sb.append("<div class=\"warnings\">\n<span id=\"warning-missingclasses\">\nWARNING: You are using the option '--ignore-missing-classes', i.e. superclasses and\ninterfaces that could not be found on the classpath are ignored. Hence changes\ncaused by these superclasses and interfaces are not reflected in the output.\n</span>\n</div>");
        }
    }

    private String getStyle() {
        String styleSheet;
        if (this.options.getHtmlStylesheet().isPresent()) {
            try {
                FileInputStream inputStream = new FileInputStream(this.options.getHtmlStylesheet().get());
                styleSheet = Streams.asString(inputStream);
            }
            catch (FileNotFoundException e) {
                throw new JApiCmpException(JApiCmpException.Reason.IoException, "Failed to load stylesheet: " + e.getMessage(), e);
            }
        } else {
            styleSheet = this.templateEngine.loadTemplate("/style.css");
        }
        return styleSheet;
    }

    private void metaInformation(StringBuilder sb) {
        sb.append(this.templateEngine.loadAndFillTemplate("/html/meta-information.html", this.mapOf("oldJar", this.options.joinOldArchives(), "newJar", this.options.joinNewArchives(), "newJar", this.options.joinNewArchives(), "creationTimestamp", DATE_FORMAT.format(new Date()), "accessModifier", this.options.getAccessModifier().name(), "onlyModifications", String.valueOf(this.options.isOutputOnlyModifications()), "onlyBinaryIncompatibleModifications", String.valueOf(this.options.isOutputOnlyBinaryIncompatibleModifications()), "ignoreMissingClasses", String.valueOf(this.options.getIgnoreMissingClasses().isIgnoreAllMissingClasses()), "packagesInclude", StringHelper.filtersAsString(this.options.getIncludes(), true), "packagesExclude", StringHelper.filtersAsString(this.options.getExcludes(), false), "semanticVersioning", this.htmlOutputGeneratorOptions.getSemanticVersioningInformation()))).append("\n");
    }

    private Map<String, String> mapOf(String ... args) {
        HashMap<String, String> map = new HashMap<String, String>();
        int count = args.length / 2;
        for (int i = 0; i < count; ++i) {
            map.put(args[i * 2], args[i * 2 + 1]);
        }
        return map;
    }

    private String getTitle() {
        if (this.htmlOutputGeneratorOptions.getTitle().isPresent()) {
            return this.htmlOutputGeneratorOptions.getTitle().get();
        }
        return "japicmp-Report";
    }
}

