/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.incompatible;

import com.google.common.base.Joiner;
import japicmp.JApiCmp;
import japicmp.cmp.JApiCmpArchive;
import japicmp.cmp.JarArchiveComparator;
import japicmp.config.Options;
import japicmp.exception.JApiCmpException;
import japicmp.filter.ClassFilter;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiBehavior;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiField;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiMethod;
import japicmp.model.JApiParameter;
import japicmp.model.JApiReturnType;
import japicmp.model.JApiSuperclass;
import japicmp.model.JApiType;
import japicmp.output.Filter;
import japicmp.output.OutputGenerator;
import japicmp.output.semver.SemverOut;
import japicmp.versioning.SemanticVersion;
import japicmp.versioning.VersionChange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.CtClass;

public class IncompatibleErrorOutput
extends OutputGenerator<Void> {
    private static final Logger LOGGER = Logger.getLogger(JApiCmp.class.getName());
    private final JarArchiveComparator jarArchiveComparator;

    public IncompatibleErrorOutput(Options options, List<JApiClass> jApiClasses, JarArchiveComparator jarArchiveComparator) {
        super(options, jApiClasses);
        this.jarArchiveComparator = jarArchiveComparator;
    }

    protected void warn(String msg, Throwable exception) {
        LOGGER.log(Level.WARNING, msg, exception);
    }

    protected void warn(String msg) {
        LOGGER.log(Level.WARNING, msg);
    }

    protected void info(String msg) {
        LOGGER.log(Level.INFO, msg);
    }

    protected void debug(String msg) {
        LOGGER.log(Level.FINE, msg);
    }

    protected boolean isDebugEnabled() {
        return LOGGER.isLoggable(Level.FINE);
    }

    @Override
    public Void generate() {
        if (this.options.isErrorOnModifications()) {
            for (JApiClass jApiClass : this.jApiClasses) {
                if (jApiClass.getChangeStatus() == JApiChangeStatus.UNCHANGED) continue;
                throw new JApiCmpException(JApiCmpException.Reason.IncompatibleChange, String.format("There is at least one modified class: %s", jApiClass.getFullyQualifiedName()));
            }
        }
        this.breakBuildIfNecessaryByApplyingFilter(this.jApiClasses, this.options, this.jarArchiveComparator);
        if (this.options.isErrorOnSemanticIncompatibility()) {
            Optional<SemanticVersion> semanticVersion;
            boolean ignoreMissingOldVersion = this.options.isIgnoreMissingOldVersion();
            boolean ignoreMissingNewVersion = this.options.isIgnoreMissingNewVersion();
            ArrayList<SemanticVersion> oldVersions = new ArrayList<SemanticVersion>();
            ArrayList<SemanticVersion> newVersions = new ArrayList<SemanticVersion>();
            for (JApiCmpArchive file : this.options.getOldArchives()) {
                semanticVersion = file.getVersion().getSemanticVersion();
                if (!semanticVersion.isPresent()) continue;
                oldVersions.add(semanticVersion.get());
            }
            for (JApiCmpArchive file : this.options.getNewArchives()) {
                semanticVersion = file.getVersion().getSemanticVersion();
                if (!semanticVersion.isPresent()) continue;
                newVersions.add(semanticVersion.get());
            }
            VersionChange versionChange = new VersionChange(oldVersions, newVersions, ignoreMissingOldVersion, ignoreMissingNewVersion);
            if (!versionChange.isAllMajorVersionsZero() || this.options.isErrorOnSemanticIncompatibilityForMajorVersionZero()) {
                Optional<SemanticVersion.ChangeType> changeTypeOptional = versionChange.computeChangeType();
                if (changeTypeOptional.isPresent()) {
                    SemanticVersion.ChangeType changeType = changeTypeOptional.get();
                    SemverOut semverOut = new SemverOut(this.options, this.jApiClasses, (change, semanticVersionLevel) -> {
                        switch (semanticVersionLevel) {
                            case MAJOR: {
                                if (changeType.ordinal() <= SemanticVersion.ChangeType.MAJOR.ordinal()) break;
                                this.warn("Incompatibility detected: Requires semantic version level " + (Object)((Object)semanticVersionLevel) + ": " + change);
                                break;
                            }
                            case MINOR: {
                                if (changeType.ordinal() <= SemanticVersion.ChangeType.MINOR.ordinal()) break;
                                this.warn("Incompatibility detected: Requires semantic version level\t " + (Object)((Object)semanticVersionLevel) + ": " + change);
                                break;
                            }
                            case PATCH: {
                                if (changeType.ordinal() <= SemanticVersion.ChangeType.PATCH.ordinal()) break;
                                this.warn("Incompatibility detected: Requires semantic version level\t " + (Object)((Object)semanticVersionLevel) + ": " + change);
                                break;
                            }
                        }
                    });
                    String semver = semverOut.generate();
                    if (changeType == SemanticVersion.ChangeType.MINOR && semver.equals("1.0.0")) {
                        throw new JApiCmpException(JApiCmpException.Reason.IncompatibleChange, "Versions of archives indicate a minor change but binary incompatible changes found.");
                    }
                    if (changeType == SemanticVersion.ChangeType.PATCH && semver.equals("1.0.0")) {
                        throw new JApiCmpException(JApiCmpException.Reason.IncompatibleChange, "Versions of archives indicate a patch change but binary incompatible changes found.");
                    }
                    if (changeType == SemanticVersion.ChangeType.PATCH && semver.equals("0.1.0")) {
                        throw new JApiCmpException(JApiCmpException.Reason.IncompatibleChange, "Versions of archives indicate a patch change but binary compatible changes found.");
                    }
                    if (changeType == SemanticVersion.ChangeType.UNCHANGED && semver.equals("1.0.0")) {
                        throw new JApiCmpException(JApiCmpException.Reason.IncompatibleChange, "Versions of archives indicate no API changes but binary incompatible changes found.");
                    }
                    if (changeType == SemanticVersion.ChangeType.UNCHANGED && semver.equals("0.1.0")) {
                        throw new JApiCmpException(JApiCmpException.Reason.IncompatibleChange, "Versions of archives indicate no API changes but binary compatible changes found.");
                    }
                    if (changeType == SemanticVersion.ChangeType.UNCHANGED && semver.equals("0.0.1")) {
                        throw new JApiCmpException(JApiCmpException.Reason.IncompatibleChange, "Versions of archives indicate no API changes but found API changes.");
                    }
                } else if (this.isDebugEnabled()) {
                    Joiner joiner = Joiner.on(';');
                    this.debug("No change type available for old version(s) " + joiner.join(oldVersions) + " and new version(s) " + joiner.join(newVersions) + ".");
                }
            } else {
                this.info("Skipping semantic version check because all major versions are zero (see http://semver.org/#semantic-versioning-specification-semver, section 4).");
            }
        }
        return null;
    }

    private String methodParameterToList(JApiBehavior jApiMethod) {
        StringBuilder sb = new StringBuilder();
        for (JApiParameter jApiParameter : jApiMethod.getParameters()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(jApiParameter.getType());
        }
        return sb.toString();
    }

    void breakBuildIfNecessaryByApplyingFilter(List<JApiClass> jApiClasses, final Options options, final JarArchiveComparator jarArchiveComparator) {
        final StringBuilder sb = new StringBuilder();
        final BreakBuildResult breakBuildResult = new BreakBuildResult(options.isErrorOnBinaryIncompatibility(), options.isErrorOnSourceIncompatibility());
        final boolean breakBuildIfCausedByExclusion = options.isErrorOnExclusionIncompatibility();
        Filter.filter(jApiClasses, new Filter.FilterVisitor(){

            @Override
            public void visit(Iterator<JApiClass> iterator, JApiClass jApiClass) {
                for (JApiCompatibilityChange change : jApiClass.getCompatibilityChanges()) {
                    if (change.isBinaryCompatible() && change.isSourceCompatible()) continue;
                    if (!change.isBinaryCompatible()) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!change.isSourceCompatible()) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiClass.getFullyQualifiedName()).append(":").append(change.getType().name());
                }
            }

            @Override
            public void visit(Iterator<JApiMethod> iterator, JApiMethod jApiMethod) {
                List changes = Stream.concat(jApiMethod.getCompatibilityChanges().stream(), jApiMethod.getReturnType().getCompatibilityChanges().stream()).collect(Collectors.toList());
                for (JApiCompatibilityChange change : changes) {
                    if (change.isBinaryCompatible() && change.isSourceCompatible()) continue;
                    if (!change.isBinaryCompatible() && this.breakBuildIfCausedByExclusion(jApiMethod)) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!change.isSourceCompatible() && this.breakBuildIfCausedByExclusion(jApiMethod)) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiMethod.getjApiClass().getFullyQualifiedName()).append(".").append(jApiMethod.getName()).append("(").append(IncompatibleErrorOutput.this.methodParameterToList(jApiMethod)).append(")").append(":").append(change.getType().name());
                }
            }

            private boolean breakBuildIfCausedByExclusion(JApiMethod jApiMethod) {
                if (!breakBuildIfCausedByExclusion) {
                    JApiReturnType returnType = jApiMethod.getReturnType();
                    String oldType = returnType.getOldReturnType();
                    try {
                        Optional<CtClass> ctClassOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.OLD, oldType);
                        if (ctClassOptional.isPresent() && this.classExcluded(ctClassOptional.get())) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        IncompatibleErrorOutput.this.warn("Failed to load class " + oldType + ": " + e.getMessage(), e);
                    }
                    String newType = returnType.getNewReturnType();
                    try {
                        Optional<CtClass> ctClassOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.NEW, newType);
                        if (ctClassOptional.isPresent() && this.classExcluded(ctClassOptional.get())) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        IncompatibleErrorOutput.this.warn("Failed to load class " + newType + ": " + e.getMessage(), e);
                    }
                }
                return true;
            }

            @Override
            public void visit(Iterator<JApiConstructor> iterator, JApiConstructor jApiConstructor) {
                for (JApiCompatibilityChange change : jApiConstructor.getCompatibilityChanges()) {
                    if (change.isBinaryCompatible() && change.isSourceCompatible()) continue;
                    if (!change.isBinaryCompatible()) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!change.isSourceCompatible()) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiConstructor.getjApiClass().getFullyQualifiedName()).append(".").append(jApiConstructor.getName()).append("(").append(IncompatibleErrorOutput.this.methodParameterToList(jApiConstructor)).append(")").append(":").append(change.getType().name());
                }
            }

            @Override
            public void visit(Iterator<JApiImplementedInterface> iterator, JApiImplementedInterface jApiImplementedInterface) {
                for (JApiCompatibilityChange change : jApiImplementedInterface.getCompatibilityChanges()) {
                    if (change.isBinaryCompatible() && change.isSourceCompatible()) continue;
                    if (!change.isBinaryCompatible() && this.breakBuildIfCausedByExclusion(jApiImplementedInterface)) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!change.isSourceCompatible() && this.breakBuildIfCausedByExclusion(jApiImplementedInterface)) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiImplementedInterface.getFullyQualifiedName()).append("[").append(jApiImplementedInterface.getFullyQualifiedName()).append("]").append(":").append(change.getType().name());
                }
            }

            private boolean breakBuildIfCausedByExclusion(JApiImplementedInterface jApiImplementedInterface) {
                if (!breakBuildIfCausedByExclusion) {
                    CtClass ctClass = jApiImplementedInterface.getCtClass();
                    return !this.classExcluded(ctClass);
                }
                return true;
            }

            @Override
            public void visit(Iterator<JApiField> iterator, JApiField jApiField) {
                for (JApiCompatibilityChange change : jApiField.getCompatibilityChanges()) {
                    if (change.isBinaryCompatible() && change.isSourceCompatible()) continue;
                    if (!change.isBinaryCompatible() && this.breakBuildIfCausedByExclusion(jApiField)) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!change.isSourceCompatible() && this.breakBuildIfCausedByExclusion(jApiField)) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiField.getjApiClass().getFullyQualifiedName()).append(".").append(jApiField.getName()).append(":").append(change.getType().name());
                }
            }

            private boolean breakBuildIfCausedByExclusion(JApiField jApiField) {
                if (!breakBuildIfCausedByExclusion) {
                    Optional<String> newTypeOptional;
                    JApiType type = jApiField.getType();
                    Optional<String> oldTypeOptional = type.getOldTypeOptional();
                    if (oldTypeOptional.isPresent()) {
                        String oldType = oldTypeOptional.get();
                        try {
                            Optional<CtClass> ctClassOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.OLD, oldType);
                            if (ctClassOptional.isPresent() && this.classExcluded(ctClassOptional.get())) {
                                return false;
                            }
                        }
                        catch (Exception e) {
                            IncompatibleErrorOutput.this.warn("Failed to load class " + oldType + ": " + e.getMessage(), e);
                        }
                    }
                    if ((newTypeOptional = type.getNewTypeOptional()).isPresent()) {
                        String newType = newTypeOptional.get();
                        try {
                            Optional<CtClass> ctClassOptional = jarArchiveComparator.loadClass(JarArchiveComparator.ArchiveType.NEW, newType);
                            if (ctClassOptional.isPresent() && this.classExcluded(ctClassOptional.get())) {
                                return false;
                            }
                        }
                        catch (Exception e) {
                            IncompatibleErrorOutput.this.warn("Failed to load class " + newType + ": " + e.getMessage(), e);
                        }
                    }
                }
                return true;
            }

            @Override
            public void visit(Iterator<JApiAnnotation> iterator, JApiAnnotation jApiAnnotation) {
            }

            @Override
            public void visit(JApiSuperclass jApiSuperclass) {
                for (JApiCompatibilityChange change : jApiSuperclass.getCompatibilityChanges()) {
                    if (change.isBinaryCompatible() && change.isSourceCompatible()) continue;
                    if (!change.isBinaryCompatible() && this.breakBuildIfCausedByExclusion(jApiSuperclass)) {
                        breakBuildResult.binaryIncompatibleChanges = true;
                    }
                    if (!change.isSourceCompatible() && this.breakBuildIfCausedByExclusion(jApiSuperclass)) {
                        breakBuildResult.sourceIncompatibleChanges = true;
                    }
                    if (sb.length() > 1) {
                        sb.append(',');
                    }
                    sb.append(jApiSuperclass.getJApiClassOwning().getFullyQualifiedName()).append(":").append(change.getType().name());
                }
            }

            private boolean breakBuildIfCausedByExclusion(JApiSuperclass jApiSuperclass) {
                if (!breakBuildIfCausedByExclusion) {
                    CtClass ctClass;
                    Optional<CtClass> oldSuperclassOptional = jApiSuperclass.getOldSuperclass();
                    if (oldSuperclassOptional.isPresent() && this.classExcluded(ctClass = oldSuperclassOptional.get())) {
                        return false;
                    }
                    Optional<CtClass> newSuperclassOptional = jApiSuperclass.getNewSuperclass();
                    if (newSuperclassOptional.isPresent()) {
                        CtClass ctClass2 = newSuperclassOptional.get();
                        return !this.classExcluded(ctClass2);
                    }
                }
                return true;
            }

            private boolean classExcluded(CtClass ctClass) {
                List<japicmp.filter.Filter> excludes = options.getExcludes();
                for (japicmp.filter.Filter exclude : excludes) {
                    ClassFilter classFilter;
                    if (!(exclude instanceof ClassFilter) || !(classFilter = (ClassFilter)exclude).matches(ctClass)) continue;
                    return true;
                }
                return false;
            }
        });
        if (breakBuildResult.breakTheBuild()) {
            throw new JApiCmpException(JApiCmpException.Reason.IncompatibleChange, String.format("There is at least one incompatibility: %s", sb));
        }
    }

    private static class BreakBuildResult {
        private final boolean breakBuildOnBinaryIncompatibleModifications;
        private final boolean breakBuildOnSourceIncompatibleModifications;
        boolean binaryIncompatibleChanges = false;
        boolean sourceIncompatibleChanges = false;

        public BreakBuildResult(boolean breakBuildOnBinaryIncompatibleModifications, boolean breakBuildOnSourceIncompatibleModifications) {
            this.breakBuildOnBinaryIncompatibleModifications = breakBuildOnBinaryIncompatibleModifications;
            this.breakBuildOnSourceIncompatibleModifications = breakBuildOnSourceIncompatibleModifications;
        }

        public boolean breakTheBuild() {
            return this.binaryIncompatibleChanges && this.breakBuildOnBinaryIncompatibleModifications || this.sourceIncompatibleChanges && this.breakBuildOnSourceIncompatibleModifications;
        }
    }
}

