/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.markdown;

import japicmp.output.markdown.Markdown;
import japicmp.output.markdown.MarkdownImage;
import japicmp.output.markdown.MarkdownRefImage;
import japicmp.output.markdown.MarkdownReferences;

public class MarkdownBadge
extends Markdown {
    static final String BASE_URL = "https://img.shields.io/badge/";
    final String label;
    final String message;
    final String color;
    final String logo;

    public MarkdownBadge(String label, String message, String color, String logo) {
        this.label = label;
        this.message = message;
        this.color = color;
        this.logo = logo;
    }

    public MarkdownBadge(String label, String message, String color) {
        this(label, message, color, null);
    }

    public String toString() {
        String alt = this.label != null ? this.label + " " + this.message : this.message;
        return new MarkdownImage(alt, this.getHref(), alt).toString();
    }

    public MarkdownRefImage toRefImage(MarkdownReferences references, String alt, String title) {
        return references.make(this.getHref(), alt, title).toImage(alt);
    }

    public MarkdownRefImage toRefImage(MarkdownReferences references, String title) {
        return this.toRefImage(references, title, title);
    }

    public MarkdownRefImage toRefImage(MarkdownReferences references) {
        return this.toRefImage(references, this.message);
    }

    private String getHref() {
        String pre = this.label == null ? "" : this.label.replace("-", "_").replace(" ", "_").replace("#", ":") + "-";
        String msg = this.message.replace("-", "_").replace(" ", "_").replace("#", ":");
        String arg = this.logo == null ? "" : "?logo=" + this.logo;
        return BASE_URL + pre + msg + "-" + this.color + arg;
    }
}

