/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.markdown;

import japicmp.output.markdown.Markdown;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MarkdownList
extends Markdown {
    private final String pad;
    private final List<String> elements;

    MarkdownList(String ... elements) {
        this.pad = "";
        this.elements = Arrays.asList(elements);
    }

    MarkdownList(int level, Stream<String> elements) {
        String format = "%-" + level * 2 + "s";
        this.pad = String.format(format, "");
        this.elements = elements.collect(Collectors.toList());
    }

    MarkdownList(int level, String ... elements) {
        this(level, Arrays.stream(elements));
    }

    public String toString() {
        return (this.pad.isEmpty() || this.elements.isEmpty() ? "" : "\n") + (String)this.elements.stream().filter(x -> x != null && !x.isEmpty()).map(e -> this.pad + "- " + e).collect(LINES);
    }
}

