/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.markdown;

import japicmp.cmp.JApiCmpArchive;
import japicmp.config.IgnoreMissingClasses;
import japicmp.config.Options;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiAnnotationElement;
import japicmp.model.JApiBehavior;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiClassFileFormatVersion;
import japicmp.model.JApiClassType;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiCompatibilityChangeType;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiException;
import japicmp.model.JApiField;
import japicmp.model.JApiGenericTemplate;
import japicmp.model.JApiGenericType;
import japicmp.model.JApiHasAnnotations;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasGenericTemplates;
import japicmp.model.JApiHasModifiers;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiJavaObjectSerializationCompatibility;
import japicmp.model.JApiMethod;
import japicmp.model.JApiModifier;
import japicmp.model.JApiParameter;
import japicmp.model.JApiReturnType;
import japicmp.model.JApiSuperclass;
import japicmp.model.JApiType;
import japicmp.model.VarargsModifier;
import japicmp.output.OutputFilter;
import japicmp.output.OutputGenerator;
import japicmp.output.markdown.Markdown;
import japicmp.output.markdown.MarkdownBadge;
import japicmp.output.markdown.MarkdownList;
import japicmp.output.markdown.MarkdownReferences;
import japicmp.output.markdown.MarkdownSection;
import japicmp.output.markdown.config.MarkdownOptions;
import japicmp.output.semver.SemverOut;
import japicmp.util.JApiClassFileFormatVersionHelper;
import japicmp.util.MemberValueHelper;
import japicmp.util.ModifierHelper;
import japicmp.util.TypeNameHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.bytecode.annotation.MemberValue;

public class MarkdownOutputGenerator
extends OutputGenerator<String> {
    final MarkdownOptions md;
    final MarkdownReferences references = new MarkdownReferences();

    public MarkdownOutputGenerator(MarkdownOptions mdOptions, List<JApiClass> jApiClasses) {
        super(mdOptions.options, jApiClasses);
        this.md = mdOptions;
    }

    public MarkdownOutputGenerator(Options options, List<JApiClass> jApiClasses) {
        this(MarkdownOptions.newDefault(options), jApiClasses);
    }

    @Override
    public String generate() {
        String semver = new SemverOut(this.options, this.jApiClasses).generate();
        return this.renderHeading(0, this.md.title.report) + this.md.message.getSemverBadge(semver) + "\n" + this.renderHeading(1, this.md.title.summary) + this.renderReportSummary(this.md.message.getSummaryMessage(semver), this.options) + "\n\n" + this.renderHtmlDetails(this.md.message.expandOptions, this.renderReportOptions(this.options)) + this.renderReportResults(this.options) + "\n" + this.renderMissingClassesWarning(this.options.getIgnoreMissingClasses()) + "___" + "\n\n" + String.format(this.md.message.generatedOn, this.md.message.getCurrentTimestamp()) + "\n\n" + this.references + "\n";
    }

    private String renderHeading(int level, String text) {
        StringBuilder tmp = new StringBuilder();
        tmp.append("\n");
        for (int repeat = 0; repeat < this.md.title.topHeadingLevel + level && repeat < 6; ++repeat) {
            tmp.append("#");
        }
        tmp.append(" ");
        tmp.append(text);
        tmp.append("\n\n");
        return tmp.toString();
    }

    private String renderReportSummary(String summary, Options options) {
        String newVersion = this.renderArchivesVersion(this.md.targetNewVersion, options.getNewArchives(), this.md.message.oneNewVersion, this.md.message.manyNewArchives);
        String oldVersion = this.renderArchivesVersion(this.md.targetOldVersion, options.getOldArchives(), this.md.message.oneOldVersion, this.md.message.manyOldArchives);
        return String.format(summary, newVersion, oldVersion);
    }

    private String renderReportOptions(Options options) {
        List<Pattern> patterns = options.getIgnoreMissingClasses().getIgnoreMissingClassRegularExpression();
        return new MarkdownList(String.format(this.md.message.reportOnlySummary, this.md.message.yesNo(options.isReportOnlySummary())), String.format(this.md.message.reportOnlyChanges, this.md.message.yesNo(options.isOutputOnlyModifications())), String.format(this.md.message.reportOnlyBinaryIncompatibleChanges, this.md.message.yesNo(options.isOutputOnlyBinaryIncompatibleModifications())), String.format(this.md.message.accessModifierFilter, options.getAccessModifier()), String.format(this.md.message.oldArchives, new MarkdownList(1, options.getOldArchives().stream().map(this::renderArchive))), String.format(this.md.message.newArchives, new MarkdownList(1, options.getNewArchives().stream().map(this::renderArchive))), String.format(this.md.message.evaluateAnnotations, this.md.message.yesNo(!options.isNoAnnotations())), String.format(this.md.message.includeSynthetic, this.md.message.yesNo(options.isIncludeSynthetic())), String.format(this.md.message.includeSpecificElements, this.md.message.yesNo(!options.getIncludes().isEmpty()) + new MarkdownList(1, options.getIncludes().stream().filter(Objects::nonNull).map(Object::toString).distinct().map(this::renderCode))), String.format(this.md.message.excludeSpecificElements, this.md.message.yesNo(!options.getExcludes().isEmpty()) + new MarkdownList(1, options.getExcludes().stream().filter(Objects::nonNull).map(Object::toString).distinct().map(this::renderCode))), String.format(this.md.message.ignoreAllMissingClasses, this.md.message.yesNo(options.getIgnoreMissingClasses().isIgnoreAllMissingClasses())), String.format(this.md.message.ignoreSpecificMissingClasses, this.md.message.yesNo(!patterns.isEmpty()) + new MarkdownList(1, patterns.stream().map(Pattern::pattern).map(this::renderCode))), String.format(this.md.message.treatChangesAsErrors, new MarkdownList(1, String.format(this.md.message.anyChanges, this.md.message.yesNo(options.isErrorOnModifications())), String.format(this.md.message.binaryIncompatibleChanges, this.md.message.yesNo(options.isErrorOnBinaryIncompatibility())), String.format(this.md.message.sourceIncompatibleChanges, this.md.message.yesNo(options.isErrorOnSourceIncompatibility())), String.format(this.md.message.incompatibleChangesCausedByExcludedClasses, this.md.message.yesNo(options.isErrorOnExclusionIncompatibility())), String.format(this.md.message.semanticallyIncompatibleChanges, this.md.message.yesNo(options.isErrorOnSemanticIncompatibility())), String.format(this.md.message.semanticallyIncompatibleChangesIncludingDevelopmentVersions, this.md.message.yesNo(options.isErrorOnSemanticIncompatibilityForMajorVersionZero())))), String.format(this.md.message.classpathMode, new Object[]{options.getClassPathMode()}), String.format(this.md.message.oldClasspath, options.getOldClassPath().orElse("")), String.format(this.md.message.newClasspath, options.getNewClassPath().orElse(""))) + "\n";
    }

    private String renderArchivesVersion(Optional<String> version, List<JApiCmpArchive> archives, String one, String many) {
        if (version.isPresent()) {
            return String.format(one, version.get());
        }
        if (archives.isEmpty()) {
            return String.format(one, this.md.message.unknownVersion);
        }
        if (archives.size() == 1) {
            JApiCmpArchive archive = archives.get(0);
            String archiveVersion = archive.getVersion().getStringVersion();
            if (archiveVersion != null && !archiveVersion.equals("n.a.")) {
                return String.format(one, archiveVersion);
            }
            return String.format(one, this.renderSimpleArchiveName(archive));
        }
        return many;
    }

    private String renderReportResults(Options options) {
        new OutputFilter(options).filter(this.jApiClasses);
        if (this.jApiClasses.isEmpty()) {
            return "";
        }
        return new MarkdownSection<JApiClass>(this.renderHeading(1, this.md.title.results), this.jApiClasses, this.md.sort.classes).column(this.md.header.status, this::renderStatus).column(this.md.header.type, this::renderClassLink).column(this.md.header.serialization, this::renderSerializationChange).column(this.md.header.compatibilityChanges, this::renderAllCompatibilityChanges) + (this.md.options.isReportOnlySummary() ? "" : this.renderHtmlDetails(this.md.message.expandResults, this.jApiClasses.stream().sorted(this.md.sort.classes).map(this::renderClass).collect(Collectors.joining())));
    }

    private String renderMissingClassesWarning(IgnoreMissingClasses missing) {
        if (missing.isIgnoreAllMissingClasses()) {
            return this.md.message.warningAllMissingClassesIgnored;
        }
        if (!missing.getIgnoreMissingClassRegularExpression().isEmpty()) {
            return this.md.message.warningSomeMissingClassesIgnored;
        }
        return "";
    }

    private String renderClass(JApiClass clazz) {
        String name = clazz.getFullyQualifiedName();
        return "___\n\n" + this.renderHtmlAnchor(name) + this.renderHeading(2, this.renderCode(name)) + this.renderCompatibilityList(clazz) + "\n\n" + this.renderClassInfo(clazz) + this.renderGenericTemplates(clazz) + this.renderImplementedInterfaces(clazz) + this.renderAnnotations(clazz) + this.renderConstructors(clazz) + this.renderMethods(clazz) + this.renderFields(clazz);
    }

    private String renderHtmlAnchor(String id) {
        return Markdown.angles("a id=" + Markdown.quotes(this.renderSlug(id))) + Markdown.angles("/a");
    }

    private String renderHtmlDetails(String summary, String details) {
        return Markdown.angles("details markdown=" + Markdown.quotes("1")) + "\n" + Markdown.angles("summary") + summary + Markdown.angles("/summary") + "\n\n" + details + "\n" + Markdown.angles("/details") + "\n\n";
    }

    private String renderSlug(String id) {
        return "user-content-" + id.toLowerCase();
    }

    private Markdown renderCompatibilityList(JApiClass clazz) {
        return new MarkdownList(String.format(this.md.message.compatibilityBinary, this.md.message.checkbox(clazz.isBinaryCompatible())), String.format(this.md.message.compatibilitySource, this.md.message.checkbox(clazz.isSourceCompatible())), String.format(this.md.message.compatibilitySerialization, this.md.message.checkbox(!clazz.getJavaObjectSerializationCompatible().isIncompatible())));
    }

    private Markdown renderClassInfo(JApiClass clazz) {
        return new MarkdownSection<JApiClass>("", clazz).column(this.md.header.status, this::renderStatus).column(this.md.header.modifiers, this::renderModifiers).column(this.md.header.classType, this::renderClassType).column(this.md.header.className, this::renderClassSimpleName).column(this.md.header.superclass, this::renderClassSuperclass).column(this.md.header.classJdk, this::renderClassJdk).column(this.md.header.serialization, this::renderSerializationChange).column(this.md.header.compatibilityChanges, this::renderClassLevelCompatibilityChanges);
    }

    private Markdown renderGenericTemplates(JApiClass clazz) {
        return new MarkdownSection<JApiGenericTemplate>(this.renderHeading(3, this.md.title.generics), clazz.getGenericTemplates(), this.md.sort.generics).column(this.md.header.status, this::renderStatus).column(this.md.header.genericTemplateName, this::renderGenericTemplateName).column(this.md.header.genericTemplateType, this::renderGenericTemplateType).column(this.md.header.compatibilityChanges, this::renderCompatibilityChanges);
    }

    private Markdown renderImplementedInterfaces(JApiClass clazz) {
        return new MarkdownSection<JApiImplementedInterface>(this.renderHeading(3, this.md.title.interfaces), clazz.getInterfaces(), this.md.sort.interfaces).column(this.md.header.status, this::renderStatus).column(this.md.header.interfaceName, this::renderImplementedInterfaceName).column(this.md.header.compatibilityChanges, this::renderCompatibilityChanges);
    }

    private Markdown renderAnnotations(JApiClass clazz) {
        return new MarkdownSection<JApiAnnotation>(this.renderHeading(3, this.md.title.annotations), clazz.getAnnotations(), this.md.sort.annotations).column(this.md.header.status, this::renderStatus).column(this.md.header.annotationName, this::renderAnnotation).column(this.md.header.compatibilityChanges, this::renderAllCompatibilityChanges);
    }

    private Markdown renderConstructors(JApiClass clazz) {
        return new MarkdownSection<JApiConstructor>(this.renderHeading(3, this.md.title.constructors), clazz.getConstructors(), this.md.sort.constructors).column(this.md.header.status, this::renderStatus).column(this.md.header.modifiers, this::renderModifiers).column(this.md.header.generics, this::renderGenericTemplates).column(this.md.header.constructorNameAndParameters, this::renderNameAndParameters).column(this.md.header.annotations, this::renderInlineAnnotations).column(this.md.header.exceptions, this::renderExceptions).column(this.md.header.compatibilityChanges, this::renderAllCompatibilityChanges);
    }

    private Markdown renderMethods(JApiClass clazz) {
        return new MarkdownSection<JApiMethod>(this.renderHeading(3, this.md.title.methods), clazz.getMethods(), this.md.sort.methods).column(this.md.header.status, this::renderStatus).column(this.md.header.modifiers, this::renderModifiers).column(this.md.header.generics, this::renderGenericTemplates).column(this.md.header.methodReturnType, this::renderReturnType).column(this.md.header.methodNameAndParameters, this::renderNameAndParameters).column(this.md.header.annotations, this::renderInlineAnnotations).column(this.md.header.exceptions, this::renderExceptions).column(this.md.header.compatibilityChanges, this::renderAllCompatibilityChanges);
    }

    private Markdown renderFields(JApiClass clazz) {
        return new MarkdownSection<JApiField>(this.renderHeading(3, this.md.title.fields), clazz.getFields(), this.md.sort.fields).column(this.md.header.status, this::renderStatus).column(this.md.header.modifiers, this::renderModifiers).column(this.md.header.fieldType, this::renderFieldType).column(this.md.header.fieldName, this::renderFieldName).column(this.md.header.annotations, this::renderInlineAnnotations).column(this.md.header.compatibilityChanges, this::renderCompatibilityChanges);
    }

    private String renderStatus(JApiHasChangeStatus element) {
        boolean isFullyCompatible;
        boolean isBinaryCompatible = ((JApiCompatibility)((Object)element)).isBinaryCompatible();
        boolean isSourceCompatible = ((JApiCompatibility)((Object)element)).isSourceCompatible();
        boolean isSerializationCompatible = !(element instanceof JApiJavaObjectSerializationCompatibility) || !((JApiJavaObjectSerializationCompatibility)((Object)element)).getJavaObjectSerializationCompatible().isIncompatible();
        boolean bl = isFullyCompatible = isBinaryCompatible && isSourceCompatible && isSerializationCompatible;
        if (element.getChangeStatus() != JApiChangeStatus.UNCHANGED || isFullyCompatible) {
            return this.renderLiteralStatus(element);
        }
        if (!isBinaryCompatible && !isSourceCompatible) {
            return this.md.message.statusIncompatible;
        }
        if (!isBinaryCompatible) {
            return this.md.message.statusBinaryIncompatible;
        }
        if (!isSourceCompatible) {
            return this.md.message.statusSourceIncompatible;
        }
        return this.md.message.statusSerializationIncompatible;
    }

    private String renderLiteralStatus(JApiHasChangeStatus element) {
        switch (element.getChangeStatus()) {
            case NEW: {
                return this.md.message.statusNew;
            }
            case REMOVED: {
                return this.md.message.statusRemoved;
            }
            case UNCHANGED: {
                return this.md.message.statusUnchanged;
            }
        }
        return this.md.message.statusModified;
    }

    private String renderClassLink(JApiClass clazz) {
        String name = clazz.getFullyQualifiedName();
        return this.md.options.isReportOnlySummary() ? name : this.references.link("#" + this.renderSlug(name), name, null).toString();
    }

    private String renderClassSimpleName(JApiClass clazz) {
        String simpleName = TypeNameHelper.formatTypeName(clazz.getFullyQualifiedName(), Collections.emptyList(), true);
        return this.renderChange(clazz, this.renderCode(simpleName));
    }

    private String renderClassType(JApiClass clazz) {
        JApiClassType classType = clazz.getClassType();
        return this.renderChange(classType, this.md.message.getClassType(classType.getOldTypeOptional()), this.md.message.getClassType(classType.getNewTypeOptional()));
    }

    private String renderClassSuperclass(JApiClass clazz) {
        JApiSuperclass superclass = clazz.getSuperclass();
        JApiClass correspondingClass = superclass.getCorrespondingJApiClass().orElse(null);
        return this.renderChange(superclass, this.renderTypeWithGenericTemplates(superclass.getOldSuperclassName().orElse(null), superclass, correspondingClass), this.renderTypeWithGenericTemplates(superclass.getNewSuperclassName().orElse(null), superclass, correspondingClass));
    }

    private String renderClassJdk(JApiClass clazz) {
        JApiClassFileFormatVersion version = clazz.getClassFileFormatVersion();
        return this.renderChange(version, JApiClassFileFormatVersionHelper.getOldJdkVersion(version), JApiClassFileFormatVersionHelper.getNewJdkVersion(version));
    }

    private String renderGenericTemplateName(JApiGenericTemplate genericTemplate) {
        return this.renderChange(genericTemplate, this.renderCode(genericTemplate.getName()));
    }

    private String renderGenericTemplateType(JApiGenericTemplate genericTemplate) {
        return this.renderChange(genericTemplate, this.renderTypeWithGenericTypes(genericTemplate.getOldType(), genericTemplate.getOldGenericTypes()), this.renderTypeWithGenericTypes(genericTemplate.getNewType(), genericTemplate.getNewGenericTypes()));
    }

    private String renderImplementedInterfaceName(JApiImplementedInterface implInterface) {
        return this.renderChange(implInterface, this.renderTypeWithGenericTemplates(implInterface.getFullyQualifiedName(), implInterface, implInterface.getCorrespondingJApiClass().orElse(null)));
    }

    private String renderNameAndParameters(JApiBehavior behavior) {
        String name = behavior.getName();
        int pos = name != null ? name.lastIndexOf(36) : -1;
        String simpleName = pos > 0 ? name.substring(pos + 1) : name;
        return this.renderChange(behavior, this.renderCode(simpleName)) + this.renderParameters(behavior);
    }

    private String renderParameters(JApiBehavior behavior) {
        return Markdown.parenthesis(behavior.getParameters().stream().map(x -> this.renderParameter(behavior, (JApiParameter)x)).collect(Markdown.CSV));
    }

    private String renderParameter(JApiBehavior method, JApiParameter parameter) {
        if (parameter.getTemplateNameOptional().isPresent()) {
            return this.renderChange(parameter, this.renderCode(parameter.getTemplateName()));
        }
        JApiChangeStatus status = method.getChangeStatus();
        JApiModifier<VarargsModifier> varargs = method.getVarargsModifier();
        String oldType = status == JApiChangeStatus.NEW ? null : this.renderParameterType(method, parameter, varargs.getOldModifier(), parameter.getOldGenericTypes());
        String newType = status == JApiChangeStatus.REMOVED ? null : this.renderParameterType(method, parameter, varargs.getNewModifier(), parameter.getNewGenericTypes());
        return this.renderChange(parameter, oldType, newType);
    }

    private String renderGenericTemplates(JApiBehavior behavior) {
        List<JApiGenericTemplate> genericTemplates = behavior.getGenericTemplates();
        if (genericTemplates.isEmpty()) {
            return "";
        }
        return "\\<" + genericTemplates.stream().map(this::renderGenericTemplate).collect(Markdown.CSV) + "\\" + ">";
    }

    private String renderGenericTemplate(JApiGenericTemplate genericTemplate) {
        String name = genericTemplate.getName();
        String oldTemplate = this.renderGenericTemplate(name, genericTemplate.getOldTypeOptional().orElse(null), genericTemplate.getOldGenericTypes());
        String newTemplate = this.renderGenericTemplate(name, genericTemplate.getNewTypeOptional().orElse(null), genericTemplate.getNewGenericTypes());
        return this.renderChange(genericTemplate, oldTemplate, newTemplate);
    }

    private String renderGenericTemplate(String name, String type, List<JApiGenericType> genericTypes) {
        String fullType = TypeNameHelper.formatGenericTemplate(name, type, genericTypes, false);
        String simpleType = TypeNameHelper.formatGenericTemplate(name, type, genericTypes, true);
        return this.renderCodeWithTooltip(fullType, simpleType);
    }

    private String renderCompatibilityChanges(List<JApiCompatibilityChange> changes) {
        if (changes.isEmpty()) {
            return this.renderNoChangesBadge();
        }
        return changes.stream().map(this::renderChangeBadge).collect(Markdown.SPACES);
    }

    private String renderCompatibilityChanges(JApiCompatibility hasCompatibilityChanges) {
        return this.renderCompatibilityChanges(hasCompatibilityChanges.getCompatibilityChanges());
    }

    @SafeVarargs
    private final String renderCompatibilityChanges(List<? extends JApiCompatibility> ... haveCompatibilityChanges) {
        return this.renderCompatibilityChanges(Stream.of(haveCompatibilityChanges).flatMap(Collection::stream).map(JApiCompatibility::getCompatibilityChanges).flatMap(Collection::stream).distinct().collect(Collectors.toList()));
    }

    private String renderAllCompatibilityChanges(JApiClass clazz) {
        Stream<List> allCompatibilityChanges = Stream.of(Collections.singletonList(clazz), Collections.singletonList(clazz.getClassFileFormatVersion()), Collections.singletonList(clazz.getSuperclass()), clazz.getGenericTemplates(), clazz.getInterfaces(), clazz.getAnnotations(), clazz.getAnnotations().stream().map(JApiAnnotation::getElements).flatMap(Collection::stream).collect(Collectors.toList()), clazz.getConstructors(), clazz.getConstructors().stream().map(JApiBehavior::getParameters).flatMap(Collection::stream).collect(Collectors.toList()), clazz.getMethods(), clazz.getMethods().stream().map(JApiMethod::getReturnType).collect(Collectors.toList()), clazz.getMethods().stream().map(JApiBehavior::getParameters).flatMap(Collection::stream).collect(Collectors.toList()), clazz.getFields());
        return this.renderCompatibilityChanges(allCompatibilityChanges.flatMap(Collection::stream).map(JApiCompatibility::getCompatibilityChanges).flatMap(Collection::stream).distinct().sorted(Comparator.comparing(JApiCompatibilityChange::getType)).collect(Collectors.toList()));
    }

    private String renderClassLevelCompatibilityChanges(JApiClass clazz) {
        return this.renderCompatibilityChanges(new List[]{Arrays.asList(clazz, clazz.getClassFileFormatVersion(), clazz.getSuperclass())});
    }

    private String renderAllCompatibilityChanges(JApiAnnotation annotation) {
        return this.renderCompatibilityChanges(Collections.singletonList(annotation), annotation.getElements());
    }

    private String renderAllCompatibilityChanges(JApiConstructor constructor) {
        return this.renderCompatibilityChanges(Collections.singletonList(constructor), constructor.getParameters());
    }

    private String renderAllCompatibilityChanges(JApiMethod method) {
        return this.renderCompatibilityChanges(Collections.singletonList(method), Collections.singletonList(method.getReturnType()), method.getParameters());
    }

    private String renderNoChangesBadge() {
        return new MarkdownBadge(null, this.md.message.noCompatibilityChanges, this.md.message.colorNoChanges).toRefImage(this.references).toString();
    }

    private String renderChangeBadge(JApiCompatibilityChange change) {
        JApiCompatibilityChangeType type = change.getType();
        return new MarkdownBadge(null, this.md.message.compatibilityChangeType.getOrDefault((Object)type, type.name()), this.md.message.getSemanticColor(change.getSemanticVersionLevel())).toRefImage(this.references).toString();
    }

    private String renderSerializationChange(JApiClass clazz) {
        JApiJavaObjectSerializationCompatibility.JApiJavaObjectSerializationChangeStatus change = clazz.getJavaObjectSerializationCompatible();
        String text = this.md.message.serializationCompatibility.getOrDefault((Object)change, change.getDescription());
        String color = change.isIncompatible() ? this.md.message.colorMajorChanges : this.md.message.colorNoChanges;
        String msg = change.isIncompatible() ? this.md.message.statusIncompatible : text;
        return new MarkdownBadge(null, msg, color).toRefImage(this.references, text).toString();
    }

    private String renderChange(JApiHasChangeStatus hasStatus, String oldValue, String newValue) {
        if (oldValue == null && newValue == null) {
            return null;
        }
        switch (hasStatus.getChangeStatus()) {
            case NEW: {
                return newValue == null ? null : String.format(this.md.message.added, newValue);
            }
            case REMOVED: {
                return oldValue == null ? null : String.format(this.md.message.removed, oldValue);
            }
            case UNCHANGED: {
                if (newValue == null) {
                    return String.format(this.md.message.unchanged, oldValue);
                }
                if (oldValue == null || newValue.equals(oldValue)) {
                    return String.format(this.md.message.unchanged, newValue);
                }
                return String.format(this.md.message.modified, oldValue, newValue);
            }
        }
        if (oldValue == null) {
            return String.format(this.md.message.added, newValue);
        }
        if (newValue == null) {
            return String.format(this.md.message.removed, oldValue);
        }
        if (newValue.equals(oldValue)) {
            return String.format(this.md.message.unchanged, newValue);
        }
        return String.format(this.md.message.modified, oldValue, newValue);
    }

    private String renderChange(JApiHasChangeStatus status, String value) {
        return this.renderChange(status, value, value);
    }

    private String renderModifiers(JApiHasModifiers clazz) {
        return clazz.getModifiers().stream().map(this::renderModifier).filter(Objects::nonNull).collect(Markdown.SPACES);
    }

    private String renderModifier(JApiModifier<? extends Enum<? extends Enum<?>>> modifier) {
        String oldName = ModifierHelper.getOldModifierName(modifier).orElse(null);
        String newName = ModifierHelper.getNewModifierName(modifier).orElse(null);
        return this.renderChange(modifier, this.renderCode(oldName), this.renderCode(newName));
    }

    private String renderTypeWithGenericTypes(String type, List<JApiGenericType> genericTypes) {
        if (type == null) {
            return null;
        }
        String fullType = TypeNameHelper.formatTypeName(type, genericTypes, false);
        String simpleType = TypeNameHelper.formatTypeName(type, genericTypes, true);
        return this.renderCodeWithTooltip(fullType, simpleType);
    }

    private String renderTypeWithGenericTemplates(String type, JApiHasChangeStatus hasChangeStatus, JApiHasGenericTemplates hasGenericTemplates) {
        if (type == null) {
            return null;
        }
        String fullType = TypeNameHelper.formatTypeName(type, hasChangeStatus, hasGenericTemplates, false);
        String simpleType = TypeNameHelper.formatTypeName(type, hasChangeStatus, hasGenericTemplates, true);
        return this.renderCodeWithTooltip(fullType, simpleType);
    }

    private String renderParameterType(JApiBehavior method, JApiParameter parameter, Optional<VarargsModifier> varargs, List<JApiGenericType> genericTypes) {
        if (parameter.getType() == null) {
            return null;
        }
        String fullType = TypeNameHelper.formatParameterTypeName(method, parameter, varargs, genericTypes, false);
        String simpleType = TypeNameHelper.formatParameterTypeName(method, parameter, varargs, genericTypes, true);
        return this.renderCodeWithTooltip(fullType, simpleType);
    }

    private String renderMemberValue(Optional<MemberValue> optionalValue) {
        if (!optionalValue.isPresent()) {
            return "";
        }
        String fullValue = MemberValueHelper.formatMemberValue(optionalValue.get(), false);
        String simpleValue = MemberValueHelper.formatMemberValue(optionalValue.get(), true);
        return this.renderCodeWithTooltip(fullValue, simpleValue);
    }

    private String renderReturnType(JApiMethod method) {
        JApiReturnType returnType = method.getReturnType();
        return this.renderChange(returnType, this.renderTypeWithGenericTypes(returnType.getOldReturnType(), returnType.getOldGenericTypes()), this.renderTypeWithGenericTypes(returnType.getNewReturnType(), returnType.getNewGenericTypes()));
    }

    private String renderFieldType(JApiField field) {
        JApiType fieldType = field.getType();
        return this.renderChange(fieldType, this.renderTypeWithGenericTypes(fieldType.getOldValue(), field.getOldGenericTypes()), this.renderTypeWithGenericTypes(fieldType.getNewValue(), field.getNewGenericTypes()));
    }

    private String renderFieldName(JApiField field) {
        return this.renderCode(field.getName());
    }

    private String renderExceptions(JApiBehavior behavior) {
        return behavior.getExceptions().stream().map(this::renderException).collect(Markdown.CSV);
    }

    private String renderException(JApiException exception) {
        return this.renderChange(exception, this.renderTypeWithGenericTypes(exception.getName(), Collections.emptyList()));
    }

    private String renderInlineAnnotations(JApiHasAnnotations hasAnnotations) {
        return hasAnnotations.getAnnotations().stream().map(this::renderAnnotation).collect(Markdown.BR);
    }

    private String renderAnnotation(JApiAnnotation annotation) {
        String typeName = this.renderTypeWithGenericTemplates(annotation.getFullyQualifiedName(), annotation, annotation.getCorrespondingJApiClass().orElse(null));
        return this.renderChange(annotation, typeName) + (annotation.getElements().isEmpty() ? "" : ": ") + annotation.getElements().stream().map(this::renderAnnotationElement).collect(Markdown.CSV);
    }

    private String renderAnnotationElement(JApiAnnotationElement element) {
        return this.renderChange(element, this.renderCode(element.getName())) + "=" + this.renderChange(element, this.renderMemberValue(element.getOldValue()), this.renderMemberValue(element.getNewValue()));
    }

    private String renderCode(String text) {
        return text == null || text.isEmpty() ? text : Markdown.backticks(text);
    }

    private String renderCodeWithTooltip(String fullType, String simpleType) {
        if (fullType.equals(simpleType)) {
            return this.renderCode(simpleType);
        }
        return this.references.link(null, this.renderCode(simpleType), fullType).toString();
    }

    String renderArchive(JApiCmpArchive archive) {
        String label = this.renderSimpleArchiveName(archive);
        String version = archive.getVersion().getStringVersion();
        String message = version != null && !version.equals("n.a.") ? version : this.md.message.unknownVersion;
        return new MarkdownBadge(label, message, this.md.message.colorVersionNumber).toString();
    }

    String renderSimpleArchiveName(JApiCmpArchive archive) {
        int dot;
        String version = archive.getVersion().getStringVersion();
        String name = archive.getFile().getName();
        if (version != null && name.contains(version)) {
            name = name.replace(version, "");
        }
        if ((dot = name.lastIndexOf(".")) > 0) {
            name = name.substring(0, dot);
        }
        if (name.endsWith("-") || name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }
}

