/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.markdown;

import japicmp.output.markdown.Markdown;
import java.util.Objects;
import java.util.Optional;

class MarkdownReference
extends Markdown {
    final String href;
    final String title;

    MarkdownReference(String href, String title) {
        this.href = Optional.ofNullable(href).orElse("#");
        this.title = title;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MarkdownReference) {
            MarkdownReference that = (MarkdownReference)obj;
            return Objects.equals(this.href, that.href) && Objects.equals(this.title, that.title);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.href, this.title);
    }

    public String toString() {
        if (this.title == null || this.title.isEmpty()) {
            return this.href;
        }
        String sanitizedTitle = this.title.replace("\"", "\\\"");
        return this.href + " " + MarkdownReference.quotes(sanitizedTitle);
    }
}

