/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.markdown;

import japicmp.output.markdown.Markdown;
import japicmp.output.markdown.MarkdownRefLink;
import japicmp.output.markdown.MarkdownReference;
import japicmp.output.markdown.MarkdownStoredReference;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

final class MarkdownReferences
extends Markdown {
    private final List<MarkdownStoredReference> references = new ArrayList<MarkdownStoredReference>();
    private int referenceId;

    MarkdownReferences() {
    }

    MarkdownStoredReference make(String href, String id, String title) {
        MarkdownReference reference = new MarkdownReference(href, title);
        return this.references.stream().filter(reference::equals).findAny().orElseGet(() -> this.storeReference(id, reference));
    }

    MarkdownRefLink link(String href, String text, String title) {
        return this.make(href, text, title).toLink(text);
    }

    private MarkdownStoredReference storeReference(String id, MarkdownReference reference) {
        MarkdownStoredReference stored = this.isIllegalReferenceId(id) || this.alreadyUsedReferenceId(id) ? new MarkdownStoredReference(++this.referenceId, reference) : new MarkdownStoredReference(id, reference);
        this.references.add(stored);
        return stored;
    }

    private boolean isIllegalReferenceId(String text) {
        return text == null || text.isEmpty() || text.contains("[") || text.contains("]");
    }

    private boolean alreadyUsedReferenceId(String id) {
        return this.references.stream().map(MarkdownStoredReference::getId).anyMatch(id::equals);
    }

    public String toString() {
        return (String)this.references.stream().sorted(Comparator.comparing(MarkdownStoredReference::getIndex).thenComparing(MarkdownStoredReference::getId)).map(MarkdownStoredReference::toString).collect(LINES);
    }
}

