/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.markdown;

import japicmp.output.markdown.Markdown;
import japicmp.output.markdown.MarkdownTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class MarkdownSection<T>
extends Markdown {
    private final String title;
    private final List<T> list;
    private final Comparator<? super T> comparator;
    private final List<Column<T>> columns = new ArrayList<Column<T>>();

    MarkdownSection(String title, List<T> list, Comparator<? super T> comparator) {
        this.title = title;
        this.list = list;
        this.comparator = comparator;
    }

    MarkdownSection(String title, T one) {
        this(title, Collections.singletonList(one), null);
    }

    MarkdownSection<T> column(String header, Function<T, String> mapper) {
        this.columns.add(new Column<T>(header, mapper));
        return this;
    }

    public String toString() {
        if (this.list.isEmpty()) {
            return "";
        }
        Stream stream = this.comparator == null ? this.list.stream() : this.list.stream().sorted(this.comparator);
        MarkdownTable table = new MarkdownTable(this.columns.stream().map(column -> column.header).collect(Collectors.toList()));
        stream.forEach(x -> table.addRow(this.columns.stream().map(column -> column.mapper.apply(x)).collect(Collectors.toList())));
        return this.title + table;
    }

    private static final class Column<T> {
        final String header;
        final Function<T, String> mapper;

        Column(String header, Function<T, String> mapper) {
            this.header = header;
            this.mapper = mapper;
        }
    }
}

