/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.markdown;

import japicmp.output.markdown.Markdown;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class MarkdownTable
extends Markdown {
    final int columns;
    final List<List<String>> rows = new ArrayList<List<String>>();

    MarkdownTable(List<String> headers) {
        this.columns = headers.size();
        this.rows.add(headers);
    }

    static String getColumnFormat(int width) {
        return width < 1 ? "%s" : "%-" + width + "s";
    }

    void addRow(List<String> row) {
        this.rows.add(row);
    }

    public String toString() {
        if (this.rows.size() == 1) {
            return "";
        }
        Map<Integer, Integer> colWidths = this.calculateColumnWidths();
        return IntStream.range(0, this.rows.size()).mapToObj(r -> {
            List<String> row = this.rows.get(r);
            StringBuilder tmp = new StringBuilder();
            tmp.append(new Row(row, colWidths));
            if (r == 0) {
                tmp.append('|');
                IntStream.range(0, this.columns).forEach(index -> tmp.append("-").append(String.format(MarkdownTable.getColumnFormat((Integer)colWidths.get(index)), "").replace(" ", "-")).append("-").append('|'));
                tmp.append("\n");
            }
            return tmp.toString();
        }).collect(Collectors.joining()) + "\n";
    }

    private Map<Integer, Integer> calculateColumnWidths() {
        return IntStream.range(0, this.columns).mapToObj(Integer.class::cast).collect(Collectors.toMap(Function.identity(), this::calculateMaxWidth));
    }

    private int calculateMaxWidth(int index) {
        if (index + 1 < this.columns) {
            return this.rows.stream().map(x -> (String)x.get(index)).filter(Objects::nonNull).mapToInt(String::length).filter(x -> x <= 64).max().orElse(0);
        }
        return this.rows.get(0).get(index).length();
    }

    private class Row {
        final List<String> data;
        final Map<Integer, Integer> widths;
        int offset = 0;

        Row(List<String> data, Map<Integer, Integer> widths) {
            this.data = data;
            this.widths = widths;
        }

        String formatColumn(int index) {
            int width = this.widths.get(index);
            int maxWidth = Math.max(0, width - this.offset);
            String formatted = String.format(MarkdownTable.getColumnFormat(maxWidth), this.data.get(index));
            int length = formatted.length();
            if (length <= width) {
                this.offset -= width - length;
            } else if (length > maxWidth) {
                this.offset += length - maxWidth;
            }
            this.offset = Math.max(0, this.offset);
            return formatted;
        }

        public String toString() {
            return '|' + IntStream.range(0, MarkdownTable.this.columns).mapToObj(index -> " " + this.formatColumn(index) + " " + '|').collect(Collectors.joining()) + "\n";
        }
    }
}

