/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.stdout;

import japicmp.config.Options;
import japicmp.model.AbstractModifier;
import japicmp.model.AccessModifier;
import japicmp.model.BridgeModifier;
import japicmp.model.FinalModifier;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiAnnotationElement;
import japicmp.model.JApiAnnotationElementValue;
import japicmp.model.JApiBehavior;
import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiClassFileFormatVersion;
import japicmp.model.JApiClassType;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiCompatibilityChangeType;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiException;
import japicmp.model.JApiField;
import japicmp.model.JApiGenericTemplate;
import japicmp.model.JApiGenericType;
import japicmp.model.JApiHasAbstractModifier;
import japicmp.model.JApiHasAccessModifier;
import japicmp.model.JApiHasAnnotations;
import japicmp.model.JApiHasBridgeModifier;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiHasFinalModifier;
import japicmp.model.JApiHasGenericTemplates;
import japicmp.model.JApiHasGenericTypes;
import japicmp.model.JApiHasStaticModifier;
import japicmp.model.JApiHasSyntheticModifier;
import japicmp.model.JApiHasTransientModifier;
import japicmp.model.JApiHasVolatileModifier;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiMethod;
import japicmp.model.JApiModifier;
import japicmp.model.JApiParameter;
import japicmp.model.JApiReturnType;
import japicmp.model.JApiSuperclass;
import japicmp.model.JApiType;
import japicmp.model.StaticModifier;
import japicmp.model.SyntheticModifier;
import japicmp.model.TransientModifier;
import japicmp.model.VolatileModifier;
import japicmp.output.OutputFilter;
import japicmp.output.OutputGenerator;
import japicmp.util.GenericTemplateHelper;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import javassist.bytecode.annotation.MemberValue;

public class StdoutOutputGenerator
extends OutputGenerator<String> {
    static final String NO_CHANGES = "No changes.";
    static final String WARNING = "WARNING";

    public StdoutOutputGenerator(Options options, List<JApiClass> jApiClasses) {
        super(options, jApiClasses);
    }

    @Override
    public String generate() {
        OutputFilter outputFilter = new OutputFilter(this.options);
        outputFilter.filter(this.jApiClasses);
        StringBuilder sb = new StringBuilder();
        sb.append(this.options.getDifferenceDescription()).append('\n');
        if (this.options.getIgnoreMissingClasses().isIgnoreAllMissingClasses()) {
            sb.append(WARNING).append(": You are using the option '").append("--ignore-missing-classes").append("', i.e. superclasses and interfaces that could not be found on the classpath are ignored.").append(" Hence changes caused by these superclasses and interfaces are not reflected in the output.\n");
        } else if (!this.options.getIgnoreMissingClasses().getIgnoreMissingClassRegularExpression().isEmpty()) {
            sb.append(WARNING).append(": You have ignored certain classes, i.e. superclasses and interfaces that could not ").append("be found on the classpath are ignored. Hence changes caused by these superclasses and interfaces are not reflected in the output.\n");
        }
        if (!this.jApiClasses.isEmpty()) {
            for (JApiClass jApiClass : this.jApiClasses) {
                this.processClass(sb, jApiClass);
                if (this.options.isReportOnlySummary()) continue;
                this.processConstructors(sb, jApiClass);
                this.processMethods(sb, jApiClass);
                this.processAnnotations(sb, jApiClass, 1);
            }
        } else {
            sb.append(NO_CHANGES);
        }
        return sb.toString();
    }

    private void processAnnotations(StringBuilder sb, JApiHasAnnotations jApiClass, int numberofTabs) {
        List<JApiAnnotation> annotations = jApiClass.getAnnotations();
        for (JApiAnnotation jApiAnnotation : annotations) {
            this.appendAnnotation(sb, this.signs(jApiAnnotation), jApiAnnotation, numberofTabs);
            List<JApiAnnotationElement> elements = jApiAnnotation.getElements();
            for (JApiAnnotationElement jApiAnnotationElement : elements) {
                this.appendAnnotationElement(sb, this.signs(jApiAnnotationElement), jApiAnnotationElement, numberofTabs + 1);
            }
        }
    }

    private void processConstructors(StringBuilder sb, JApiClass jApiClass) {
        List<JApiConstructor> constructors = jApiClass.getConstructors();
        for (JApiConstructor jApiConstructor : constructors) {
            this.appendBehavior(sb, this.signs(jApiConstructor), jApiConstructor, "CONSTRUCTOR:");
            this.processAnnotations(sb, jApiConstructor, 2);
            this.processExceptions(sb, jApiConstructor, 2);
            this.processGenericTemplateChanges(sb, jApiConstructor, 2);
        }
    }

    private void processMethods(StringBuilder sb, JApiClass jApiClass) {
        List<JApiMethod> methods = jApiClass.getMethods();
        for (JApiMethod jApiMethod : methods) {
            this.appendBehavior(sb, this.signs(jApiMethod), jApiMethod, "METHOD:");
            this.processAnnotations(sb, jApiMethod, 2);
            this.processExceptions(sb, jApiMethod, 2);
            this.processGenericTemplateChanges(sb, jApiMethod, 2);
        }
    }

    private void processExceptions(StringBuilder sb, JApiBehavior jApiBehavior, int indent) {
        for (JApiException exception : jApiBehavior.getExceptions()) {
            this.appendException(sb, this.signs(exception), exception, indent);
        }
    }

    private void appendException(StringBuilder sb, String signs, JApiException jApiException, int indent) {
        sb.append(this.tabs(indent)).append(signs).append(" ").append((Object)jApiException.getChangeStatus()).append(" EXCEPTION: ").append(jApiException.getName()).append("\n");
    }

    private void processClass(StringBuilder sb, JApiClass jApiClass) {
        this.appendClass(sb, this.signs(jApiClass), jApiClass);
    }

    private String signs(JApiHasChangeStatus hasChangeStatus) {
        JApiChangeStatus changeStatus = hasChangeStatus.getChangeStatus();
        String retVal = "???";
        switch (changeStatus) {
            case UNCHANGED: {
                retVal = "===";
                break;
            }
            case NEW: {
                retVal = "+++";
                break;
            }
            case REMOVED: {
                retVal = "---";
                break;
            }
            case MODIFIED: {
                retVal = "***";
            }
        }
        boolean binaryCompatible = true;
        boolean sourceCompatible = true;
        if (hasChangeStatus instanceof JApiCompatibility) {
            JApiCompatibility jApiCompatibility = (JApiCompatibility)((Object)hasChangeStatus);
            binaryCompatible = jApiCompatibility.isBinaryCompatible();
            sourceCompatible = jApiCompatibility.isSourceCompatible();
        }
        retVal = binaryCompatible ? (sourceCompatible ? retVal + " " : retVal + "*") : retVal + "!";
        return retVal;
    }

    private void appendBehavior(StringBuilder sb, String signs, JApiBehavior jApiBehavior, String classMemberType) {
        sb.append("\t").append(signs).append(" ").append((Object)jApiBehavior.getChangeStatus()).append(" ").append(classMemberType).append(" ").append(this.accessModifierAsString(jApiBehavior)).append(this.abstractModifierAsString(jApiBehavior)).append(this.staticModifierAsString(jApiBehavior)).append(this.finalModifierAsString(jApiBehavior)).append(this.syntheticModifierAsString(jApiBehavior)).append(this.bridgeModifierAsString(jApiBehavior)).append(this.returnType(jApiBehavior)).append(jApiBehavior.getName()).append("(");
        int paramCount = 0;
        for (JApiParameter jApiParameter : jApiBehavior.getParameters()) {
            if (paramCount > 0) {
                sb.append(", ");
            }
            sb.append(jApiParameter.getType());
            this.appendGenericTypes(sb, jApiParameter);
            ++paramCount;
        }
        sb.append(")\n");
    }

    private void appendGenericTypes(StringBuilder sb, JApiHasGenericTypes jApiHasGenericTypes) {
        if (!(jApiHasGenericTypes.getNewGenericTypes().isEmpty() && jApiHasGenericTypes.getOldGenericTypes().isEmpty() || !(jApiHasGenericTypes instanceof JApiCompatibility))) {
            List<JApiCompatibilityChange> compatibilityChanges = ((JApiCompatibility)((Object)jApiHasGenericTypes)).getCompatibilityChanges();
            this.appendGenericTypesForCompatibilityChanges(sb, jApiHasGenericTypes, compatibilityChanges);
        }
    }

    private void appendGenericTypesForCompatibilityChanges(StringBuilder sb, JApiHasGenericTypes jApiHasGenericTypes, List<JApiCompatibilityChange> compatibilityChanges) {
        if (this.compatibilityChangesContains(compatibilityChanges, JApiCompatibilityChangeType.METHOD_PARAMETER_GENERICS_CHANGED, JApiCompatibilityChangeType.METHOD_RETURN_TYPE_GENERICS_CHANGED, JApiCompatibilityChangeType.FIELD_GENERICS_CHANGED, JApiCompatibilityChangeType.CLASS_GENERIC_TEMPLATE_GENERICS_CHANGED)) {
            this.appendGenericTypes(sb, false, jApiHasGenericTypes.getNewGenericTypes());
            this.appendGenericTypes(sb, true, jApiHasGenericTypes.getOldGenericTypes());
        } else {
            if (!jApiHasGenericTypes.getNewGenericTypes().isEmpty()) {
                this.appendGenericTypes(sb, false, jApiHasGenericTypes.getNewGenericTypes());
            }
            if (!jApiHasGenericTypes.getOldGenericTypes().isEmpty()) {
                this.appendGenericTypes(sb, false, jApiHasGenericTypes.getOldGenericTypes());
            }
        }
    }

    private boolean compatibilityChangesContains(List<JApiCompatibilityChange> compatibilityChanges, JApiCompatibilityChangeType ... types) {
        return compatibilityChanges.stream().anyMatch(cc -> Arrays.stream(types).anyMatch(type -> cc.getType() == type));
    }

    private void appendGenericTypes(StringBuilder sb, boolean withChangeInParenthesis, List<JApiGenericType> genericTypes) {
        if (!genericTypes.isEmpty()) {
            if (withChangeInParenthesis) {
                sb.append("(<- ");
            }
            sb.append("<");
            int count = 0;
            for (JApiGenericType genericType : genericTypes) {
                if (count > 0) {
                    sb.append(",");
                }
                this.appendGenericType(sb, genericType);
                if (!genericType.getGenericTypes().isEmpty()) {
                    this.appendGenericTypes(sb, false, genericType.getGenericTypes());
                }
                ++count;
            }
            sb.append(">");
            if (withChangeInParenthesis) {
                sb.append(")");
            }
        }
    }

    private void appendGenericType(StringBuilder sb, JApiGenericType jApiGenericType) {
        if (jApiGenericType.getGenericWildCard() == JApiGenericType.JApiGenericWildCard.NONE) {
            sb.append(jApiGenericType.getType());
        } else if (jApiGenericType.getGenericWildCard() == JApiGenericType.JApiGenericWildCard.UNBOUNDED) {
            sb.append("?");
        } else if (jApiGenericType.getGenericWildCard() == JApiGenericType.JApiGenericWildCard.EXTENDS) {
            sb.append("? extends ").append(jApiGenericType.getType());
        } else if (jApiGenericType.getGenericWildCard() == JApiGenericType.JApiGenericWildCard.SUPER) {
            sb.append("? super ").append(jApiGenericType.getType());
        }
    }

    private String returnType(JApiBehavior jApiBehavior) {
        StringBuilder sb = new StringBuilder();
        if (jApiBehavior instanceof JApiMethod) {
            JApiMethod method = (JApiMethod)jApiBehavior;
            JApiReturnType jApiReturnType = method.getReturnType();
            if (jApiReturnType.getChangeStatus() == JApiChangeStatus.UNCHANGED) {
                sb.append(jApiReturnType.getNewReturnType());
                this.appendGenericTypes(sb, jApiReturnType);
                sb.append(" ");
            } else if (jApiReturnType.getChangeStatus() == JApiChangeStatus.MODIFIED) {
                sb.append(jApiReturnType.getNewReturnType());
                this.appendGenericTypes(sb, jApiReturnType);
                sb.append(" (<-");
                sb.append(jApiReturnType.getOldReturnType());
                this.appendGenericTypes(sb, jApiReturnType);
                sb.append(") ");
            } else if (jApiReturnType.getChangeStatus() == JApiChangeStatus.NEW) {
                sb.append(jApiReturnType.getNewReturnType());
                this.appendGenericTypes(sb, jApiReturnType);
                sb.append(" ");
            } else {
                sb.append(jApiReturnType.getOldReturnType());
                this.appendGenericTypes(sb, jApiReturnType);
                sb.append(" ");
            }
        }
        return sb.toString();
    }

    private void appendAnnotation(StringBuilder sb, String signs, JApiAnnotation jApiAnnotation, int numberOfTabs) {
        sb.append(String.format("%s%s %s ANNOTATION: %s\n", new Object[]{this.tabs(numberOfTabs), signs, jApiAnnotation.getChangeStatus(), jApiAnnotation.getFullyQualifiedName()}));
    }

    private void appendAnnotationElement(StringBuilder sb, String signs, JApiAnnotationElement jApiAnnotationElement, int numberOfTabs) {
        sb.append(String.format("%s%s %s ELEMENT: %s=", new Object[]{this.tabs(numberOfTabs), signs, jApiAnnotationElement.getChangeStatus(), jApiAnnotationElement.getName()}));
        Optional<MemberValue> oldValue = jApiAnnotationElement.getOldValue();
        Optional<MemberValue> newValue = jApiAnnotationElement.getNewValue();
        if (oldValue.isPresent() && newValue.isPresent()) {
            if (jApiAnnotationElement.getChangeStatus() == JApiChangeStatus.UNCHANGED) {
                sb.append(this.elementValueList2String(jApiAnnotationElement.getNewElementValues()));
            } else if (jApiAnnotationElement.getChangeStatus() == JApiChangeStatus.REMOVED) {
                sb.append(String.format("%s (-)", this.elementValueList2String(jApiAnnotationElement.getOldElementValues())));
            } else if (jApiAnnotationElement.getChangeStatus() == JApiChangeStatus.NEW) {
                sb.append(String.format("%s (+)", this.elementValueList2String(jApiAnnotationElement.getNewElementValues())));
            } else if (jApiAnnotationElement.getChangeStatus() == JApiChangeStatus.MODIFIED) {
                sb.append(String.format("%s (<- %s)", this.elementValueList2String(jApiAnnotationElement.getNewElementValues()), this.elementValueList2String(jApiAnnotationElement.getOldElementValues())));
            }
        } else if (!oldValue.isPresent() && newValue.isPresent()) {
            sb.append(String.format("%s (+)", this.elementValueList2String(jApiAnnotationElement.getNewElementValues())));
        } else if (oldValue.isPresent() && !newValue.isPresent()) {
            sb.append(String.format("%s (-)", this.elementValueList2String(jApiAnnotationElement.getOldElementValues())));
        } else {
            sb.append(" n.a.");
        }
        sb.append("\n");
    }

    private String elementValueList2String(List<JApiAnnotationElementValue> values) {
        StringBuilder sb = new StringBuilder();
        for (JApiAnnotationElementValue value : values) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (value.getName().isPresent()) {
                sb.append(value.getName().get()).append("=");
            }
            if (value.getType() != JApiAnnotationElementValue.Type.Array && value.getType() != JApiAnnotationElementValue.Type.Annotation) {
                if (value.getType() == JApiAnnotationElementValue.Type.Enum) {
                    sb.append(value.getFullyQualifiedName()).append(".").append(value.getValueString());
                    continue;
                }
                sb.append(value.getValueString());
                continue;
            }
            if (value.getType() == JApiAnnotationElementValue.Type.Array) {
                sb.append("{").append(this.elementValueList2String(value.getValues())).append("}");
                continue;
            }
            if (value.getType() != JApiAnnotationElementValue.Type.Annotation) continue;
            sb.append("@").append(value.getFullyQualifiedName()).append("(").append(this.elementValueList2String(value.getValues())).append(")");
        }
        return sb.toString();
    }

    private String tabs(int numberOfTabs) {
        if (numberOfTabs <= 0) {
            return "";
        }
        if (numberOfTabs == 1) {
            return "\t";
        }
        if (numberOfTabs == 2) {
            return "\t\t";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberOfTabs; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }

    private void appendClass(StringBuilder sb, String signs, JApiClass jApiClass) {
        sb.append(signs).append(" ").append((Object)jApiClass.getChangeStatus()).append(" ").append(this.processClassType(jApiClass)).append(": ").append(this.accessModifierAsString(jApiClass)).append(this.abstractModifierAsString(jApiClass)).append(this.staticModifierAsString(jApiClass)).append(this.finalModifierAsString(jApiClass)).append(this.syntheticModifierAsString(jApiClass)).append(jApiClass.getFullyQualifiedName()).append(" ").append(this.javaObjectSerializationStatus(jApiClass)).append("\n");
        if (this.options.isReportOnlySummary()) {
            return;
        }
        this.processClassFileFormatVersionChanges(sb, jApiClass);
        this.processGenericTemplateChanges(sb, jApiClass, 1);
        this.processInterfaceChanges(sb, jApiClass);
        this.processSuperclassChanges(sb, jApiClass);
        this.processFieldChanges(sb, jApiClass);
    }

    private void processGenericTemplateChanges(StringBuilder sb, JApiHasGenericTemplates jApiHasGenericTemplates, int numberOfTabs) {
        List<JApiGenericTemplate> genericTemplates = jApiHasGenericTemplates.getGenericTemplates();
        if (!genericTemplates.isEmpty()) {
            sb.append(this.tabs(numberOfTabs)).append("GENERIC TEMPLATES: ");
            genericTemplates.sort(Comparator.comparing(JApiGenericTemplate::getName));
            int count = 0;
            for (JApiGenericTemplate jApiGenericTemplate : genericTemplates) {
                if (count > 0) {
                    sb.append(", ");
                }
                ++count;
                sb.append(this.signs(jApiGenericTemplate));
                if (sb.charAt(sb.length() - 1) != ' ') {
                    sb.append(" ");
                }
                sb.append(jApiGenericTemplate.getName()).append(":");
                JApiChangeStatus changeStatus = jApiGenericTemplate.getChangeStatus();
                if (changeStatus == JApiChangeStatus.NEW || changeStatus == JApiChangeStatus.UNCHANGED) {
                    sb.append(jApiGenericTemplate.getNewType());
                    if (jApiGenericTemplate instanceof JApiCompatibility) {
                        this.appendGenericTypesForCompatibilityChanges(sb, jApiGenericTemplate, jApiHasGenericTemplates.getCompatibilityChanges());
                    }
                } else if (changeStatus == JApiChangeStatus.REMOVED) {
                    sb.append(jApiGenericTemplate.getOldType());
                    if (jApiGenericTemplate instanceof JApiCompatibility) {
                        this.appendGenericTypesForCompatibilityChanges(sb, jApiGenericTemplate, jApiHasGenericTemplates.getCompatibilityChanges());
                    }
                } else {
                    sb.append(jApiGenericTemplate.getNewType());
                    this.appendGenericTypes(sb, false, jApiGenericTemplate.getNewGenericTypes());
                    sb.append(" (<-").append(jApiGenericTemplate.getOldType());
                    this.appendGenericTypes(sb, false, jApiGenericTemplate.getOldGenericTypes());
                    sb.append(")");
                }
                if (jApiGenericTemplate.getOldInterfaceTypes().isEmpty() && jApiGenericTemplate.getNewInterfaceTypes().isEmpty()) continue;
                if (GenericTemplateHelper.haveGenericTemplateInterfacesChanges(jApiGenericTemplate.getOldInterfaceTypes(), jApiGenericTemplate.getNewInterfaceTypes())) {
                    this.appendGenericTemplatesInterfaces(sb, jApiGenericTemplate, false, true);
                    sb.append(" (<-");
                    this.appendGenericTemplatesInterfaces(sb, jApiGenericTemplate, true, false);
                    sb.append(")");
                    continue;
                }
                this.appendGenericTemplatesInterfaces(sb, jApiGenericTemplate, false, true);
            }
            sb.append("\n");
        }
    }

    private void appendGenericTemplatesInterfaces(StringBuilder sb, JApiGenericTemplate jApiGenericTemplate, boolean printOld, boolean printNew) {
        if (printOld) {
            for (JApiGenericType jApiGenericType : jApiGenericTemplate.getOldInterfaceTypes()) {
                sb.append(" & ");
                sb.append(jApiGenericType.getType());
                this.appendGenericTypes(sb, false, jApiGenericType.getGenericTypes());
            }
        }
        if (printNew) {
            for (JApiGenericType jApiGenericType : jApiGenericTemplate.getNewInterfaceTypes()) {
                sb.append(" & ");
                sb.append(jApiGenericType.getType());
                this.appendGenericTypes(sb, false, jApiGenericType.getGenericTypes());
            }
        }
    }

    private void processClassFileFormatVersionChanges(StringBuilder sb, JApiClass jApiClass) {
        JApiClassFileFormatVersion classFileFormatVersion = jApiClass.getClassFileFormatVersion();
        sb.append(this.tabs(1)).append(this.signs(classFileFormatVersion)).append(" CLASS FILE FORMAT VERSION: ");
        if (classFileFormatVersion.getMajorVersionNew() != -1 && classFileFormatVersion.getMinorVersionNew() != -1) {
            sb.append(classFileFormatVersion.getMajorVersionNew()).append(".").append(classFileFormatVersion.getMinorVersionNew());
        } else {
            sb.append("n.a.");
        }
        sb.append(" <- ");
        if (classFileFormatVersion.getMajorVersionOld() != -1 && classFileFormatVersion.getMinorVersionOld() != -1) {
            sb.append(classFileFormatVersion.getMajorVersionOld()).append(".").append(classFileFormatVersion.getMinorVersionOld());
        } else {
            sb.append("n.a.");
        }
        sb.append("\n");
    }

    private String processClassType(JApiClass jApiClass) {
        JApiClassType classType = jApiClass.getClassType();
        switch (classType.getChangeStatus()) {
            case NEW: {
                return classType.getNewType();
            }
            case REMOVED: {
                return classType.getOldType();
            }
            case MODIFIED: {
                return classType.getNewType() + " (<- " + classType.getOldType() + ") ";
            }
            case UNCHANGED: {
                return classType.getOldType();
            }
        }
        return "n.a.";
    }

    private String javaObjectSerializationStatus(JApiClass jApiClass) {
        return " (" + jApiClass.getJavaObjectSerializationCompatible().getDescription() + ")";
    }

    private void processFieldChanges(StringBuilder sb, JApiClass jApiClass) {
        List<JApiField> jApiFields = jApiClass.getFields();
        for (JApiField jApiField : jApiFields) {
            sb.append(this.tabs(1)).append(this.signs(jApiField)).append(" ").append((Object)jApiField.getChangeStatus()).append(" FIELD: ").append(this.accessModifierAsString(jApiField)).append(this.staticModifierAsString(jApiField)).append(this.finalModifierAsString(jApiField)).append(this.transientModifierAsString(jApiField)).append(this.volatileModifierAsString(jApiField)).append(this.syntheticModifierAsString(jApiField)).append(this.fieldTypeChangeAsString(jApiField));
            this.appendGenericTypes(sb, jApiField);
            sb.append(" ").append(jApiField.getName()).append('\n');
            this.processAnnotations(sb, jApiField, 2);
        }
    }

    private String abstractModifierAsString(JApiHasAbstractModifier hasAbstractModifier) {
        JApiModifier<AbstractModifier> modifier = hasAbstractModifier.getAbstractModifier();
        return this.modifierAsString(modifier, AbstractModifier.NON_ABSTRACT);
    }

    private String finalModifierAsString(JApiHasFinalModifier hasFinalModifier) {
        JApiModifier<FinalModifier> modifier = hasFinalModifier.getFinalModifier();
        return this.modifierAsString(modifier, FinalModifier.NON_FINAL);
    }

    private String transientModifierAsString(JApiHasTransientModifier hasTransientModifier) {
        JApiModifier<TransientModifier> modifier = hasTransientModifier.getTransientModifier();
        return this.modifierAsString(modifier, TransientModifier.NON_TRANSIENT);
    }

    private String volatileModifierAsString(JApiHasVolatileModifier hasTransientModifier) {
        JApiModifier<VolatileModifier> modifier = hasTransientModifier.getVolatileModifier();
        return this.modifierAsString(modifier, VolatileModifier.NON_VOLATILE);
    }

    private String staticModifierAsString(JApiHasStaticModifier hasStaticModifier) {
        JApiModifier<StaticModifier> modifier = hasStaticModifier.getStaticModifier();
        return this.modifierAsString(modifier, StaticModifier.NON_STATIC);
    }

    private String accessModifierAsString(JApiHasAccessModifier modifier) {
        JApiModifier<AccessModifier> accessModifier = modifier.getAccessModifier();
        return this.modifierAsString(accessModifier, AccessModifier.PACKAGE_PROTECTED);
    }

    private String syntheticModifierAsString(JApiHasSyntheticModifier modifier) {
        JApiModifier<SyntheticModifier> syntheticModifier = modifier.getSyntheticModifier();
        return this.modifierAsString(syntheticModifier, SyntheticModifier.NON_SYNTHETIC);
    }

    private String bridgeModifierAsString(JApiHasBridgeModifier modifier) {
        JApiModifier<BridgeModifier> bridgeModifier = modifier.getBridgeModifier();
        return this.modifierAsString(bridgeModifier, BridgeModifier.NON_BRIDGE);
    }

    private <T> String modifierAsString(JApiModifier<T> modifier, T notPrintValue) {
        if (modifier.getOldModifier().isPresent() && modifier.getNewModifier().isPresent()) {
            if (modifier.getChangeStatus() == JApiChangeStatus.MODIFIED) {
                return modifier.getNewModifier().get() + " (<- " + modifier.getOldModifier().get() + ") ";
            }
            if (modifier.getChangeStatus() == JApiChangeStatus.NEW) {
                if (modifier.getNewModifier().get() != notPrintValue) {
                    return modifier.getNewModifier().get() + "(+) ";
                }
            } else if (modifier.getChangeStatus() == JApiChangeStatus.REMOVED) {
                if (modifier.getOldModifier().get() != notPrintValue) {
                    return modifier.getOldModifier().get() + "(-) ";
                }
            } else if (modifier.getNewModifier().get() != notPrintValue) {
                return modifier.getNewModifier().get() + " ";
            }
        } else if (modifier.getOldModifier().isPresent()) {
            if (modifier.getOldModifier().get() != notPrintValue) {
                return modifier.getOldModifier().get() + "(-) ";
            }
        } else if (modifier.getNewModifier().isPresent() && modifier.getNewModifier().get() != notPrintValue) {
            return modifier.getNewModifier().get() + "(+) ";
        }
        return "";
    }

    private String fieldTypeChangeAsString(JApiField field) {
        JApiType type = field.getType();
        if (type.getOldTypeOptional().isPresent() && type.getNewTypeOptional().isPresent()) {
            if (type.getChangeStatus() == JApiChangeStatus.MODIFIED) {
                return type.getNewTypeOptional().get() + " (<- " + type.getOldTypeOptional().get() + ")";
            }
            if (type.getChangeStatus() == JApiChangeStatus.NEW) {
                return type.getNewTypeOptional().get() + "(+)";
            }
            if (type.getChangeStatus() == JApiChangeStatus.REMOVED) {
                return type.getOldTypeOptional().get() + "(-)";
            }
            return type.getNewTypeOptional().get();
        }
        if (type.getOldTypeOptional().isPresent() && !type.getNewTypeOptional().isPresent()) {
            return type.getOldTypeOptional().get();
        }
        if (!type.getOldTypeOptional().isPresent() && type.getNewTypeOptional().isPresent()) {
            return type.getNewTypeOptional().get();
        }
        return "n.a.";
    }

    private void processSuperclassChanges(StringBuilder sb, JApiClass jApiClass) {
        JApiSuperclass jApiSuperclass = jApiClass.getSuperclass();
        if (!this.options.isOutputOnlyModifications() || jApiSuperclass.getChangeStatus() != JApiChangeStatus.UNCHANGED) {
            sb.append(this.tabs(1)).append(this.signs(jApiSuperclass)).append(" ").append((Object)jApiSuperclass.getChangeStatus()).append(" SUPERCLASS: ").append(this.superclassChangeAsString(jApiSuperclass)).append("\n");
        }
    }

    private String superclassChangeAsString(JApiSuperclass jApiSuperclass) {
        if (jApiSuperclass.getOldSuperclassName().isPresent() && jApiSuperclass.getNewSuperclassName().isPresent()) {
            return jApiSuperclass.getNewSuperclassName().get() + " (<- " + jApiSuperclass.getOldSuperclassName().get() + ")";
        }
        if (jApiSuperclass.getOldSuperclassName().isPresent() && !jApiSuperclass.getNewSuperclassName().isPresent()) {
            return jApiSuperclass.getOldSuperclassName().get();
        }
        if (!jApiSuperclass.getOldSuperclassName().isPresent() && jApiSuperclass.getNewSuperclassName().isPresent()) {
            return jApiSuperclass.getNewSuperclassName().get();
        }
        return "n.a.";
    }

    private void processInterfaceChanges(StringBuilder sb, JApiClass jApiClass) {
        List<JApiImplementedInterface> interfaces = jApiClass.getInterfaces();
        for (JApiImplementedInterface implementedInterface : interfaces) {
            sb.append(this.tabs(1)).append(this.signs(implementedInterface)).append(" ").append((Object)implementedInterface.getChangeStatus()).append(" INTERFACE: ").append(implementedInterface.getFullyQualifiedName()).append("\n");
        }
    }
}

