/*
 * Decompiled with CFR 0.152.
 */
package japicmp.output.xml;

import japicmp.config.Options;
import japicmp.exception.JApiCmpException;
import japicmp.model.JApiClass;
import japicmp.output.OutputFilter;
import japicmp.output.OutputGenerator;
import japicmp.output.xml.XmlOutput;
import japicmp.output.xml.XmlOutputGeneratorOptions;
import japicmp.output.xml.model.JApiCmpXmlRoot;
import japicmp.util.StringHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class XmlOutputGenerator
extends OutputGenerator<XmlOutput> {
    private static final String XSD_FILENAME = "japicmp.xsd";
    private static final String XML_SCHEMA = "japicmp.xsd";
    private static final Logger LOGGER = Logger.getLogger(XmlOutputGenerator.class.getName());
    private final XmlOutputGeneratorOptions xmlOutputGeneratorOptions;

    @Deprecated
    public XmlOutputGenerator(List<JApiClass> jApiClasses, Options options, boolean createSchemaFile) {
        super(options, jApiClasses);
        this.xmlOutputGeneratorOptions = new XmlOutputGeneratorOptions();
        this.xmlOutputGeneratorOptions.setCreateSchemaFile(createSchemaFile);
    }

    public XmlOutputGenerator(List<JApiClass> jApiClasses, Options options, XmlOutputGeneratorOptions xmlOutputGeneratorOptions) {
        super(options, jApiClasses);
        this.xmlOutputGeneratorOptions = xmlOutputGeneratorOptions;
    }

    @Override
    public XmlOutput generate() {
        JApiCmpXmlRoot jApiCmpXmlRoot = this.createRootElement(this.jApiClasses, this.options);
        this.filterClasses(this.jApiClasses, this.options);
        return this.createXmlDocumentAndSchema(this.options, jApiCmpXmlRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> writeToFiles(Options options, XmlOutput xmlOutput) {
        ArrayList<File> filesWritten;
        block14: {
            filesWritten = new ArrayList<File>();
            try {
                if (!xmlOutput.getXmlOutputStream().isPresent() || !options.getXmlOutputFile().isPresent()) break block14;
                File xmlFile = new File(options.getXmlOutputFile().get());
                try (FileOutputStream fos = new FileOutputStream(xmlFile);){
                    ByteArrayOutputStream outputStream = xmlOutput.getXmlOutputStream().get();
                    outputStream.writeTo(fos);
                    filesWritten.add(xmlFile);
                }
                catch (IOException e) {
                    throw new JApiCmpException(JApiCmpException.Reason.IoException, "Failed to write XML file '" + xmlFile.getAbsolutePath() + "': " + e.getMessage(), e);
                }
            }
            finally {
                try {
                    xmlOutput.close();
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failed to close XML file: " + e.getLocalizedMessage(), e);
                }
            }
        }
        return filesWritten;
    }

    private XmlOutput createXmlDocumentAndSchema(Options options, JApiCmpXmlRoot jApiCmpXmlRoot) {
        XmlOutput xmlOutput = new XmlOutput();
        xmlOutput.setJApiCmpXmlRoot(jApiCmpXmlRoot);
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(JApiCmpXmlRoot.class);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", "UTF-8");
            marshaller.setProperty("jaxb.noNamespaceSchemaLocation", "japicmp.xsd");
            ByteArrayOutputStream xmlBaos = new ByteArrayOutputStream();
            marshaller.marshal((Object)jApiCmpXmlRoot, xmlBaos);
            if (options.getXmlOutputFile().isPresent()) {
                xmlOutput.setXmlOutputStream(Optional.of(xmlBaos));
                if (this.xmlOutputGeneratorOptions.isCreateSchemaFile()) {
                    final File xmlFile = new File(options.getXmlOutputFile().get());
                    SchemaOutputResolver outputResolver = new SchemaOutputResolver(){

                        @Override
                        public Result createOutput(String namespaceUri, String suggestedFileName) {
                            File schemaFile = xmlFile.getParentFile();
                            if (schemaFile == null) {
                                LOGGER.warning(String.format("File '%s' has no parent file. Using instead: '%s'.", xmlFile.getAbsolutePath(), "japicmp.xsd"));
                                schemaFile = new File("japicmp.xsd");
                            } else {
                                schemaFile = new File(schemaFile + File.separator + "japicmp.xsd");
                            }
                            StreamResult result = new StreamResult(schemaFile);
                            result.setSystemId(schemaFile.getAbsolutePath());
                            return result;
                        }
                    };
                    jaxbContext.generateSchema(outputResolver);
                }
            }
        }
        catch (JAXBException e) {
            throw new JApiCmpException(JApiCmpException.Reason.JaxbException, String.format("Marshalling of XML document failed: %s", e.getMessage()), e);
        }
        catch (IOException e) {
            throw new JApiCmpException(JApiCmpException.Reason.IoException, String.format("Marshalling of XML document failed: %s", e.getMessage()), e);
        }
        return xmlOutput;
    }

    private void filterClasses(List<JApiClass> jApiClasses, Options options) {
        OutputFilter outputFilter = new OutputFilter(options);
        outputFilter.filter(jApiClasses);
    }

    private JApiCmpXmlRoot createRootElement(List<JApiClass> jApiClasses, Options options) {
        JApiCmpXmlRoot jApiCmpXmlRoot = new JApiCmpXmlRoot();
        jApiCmpXmlRoot.setOldJar(options.joinOldArchives());
        jApiCmpXmlRoot.setNewJar(options.joinNewArchives());
        jApiCmpXmlRoot.setOldVersion(options.joinOldVersions());
        jApiCmpXmlRoot.setNewVersion(options.joinNewVersions());
        jApiCmpXmlRoot.setClasses(jApiClasses);
        jApiCmpXmlRoot.setAccessModifier(options.getAccessModifier().name());
        jApiCmpXmlRoot.setOnlyModifications(options.isOutputOnlyModifications());
        jApiCmpXmlRoot.setOnlyBinaryIncompatibleModifications(options.isOutputOnlyBinaryIncompatibleModifications());
        jApiCmpXmlRoot.setPackagesInclude(StringHelper.filtersAsString(options.getIncludes(), true));
        jApiCmpXmlRoot.setPackagesExclude(StringHelper.filtersAsString(options.getExcludes(), false));
        jApiCmpXmlRoot.setIgnoreMissingClasses(options.getIgnoreMissingClasses().isIgnoreAllMissingClasses());
        jApiCmpXmlRoot.setIgnoreMissingClassesByRegularExpressions(this.regExAsString(options.getIgnoreMissingClasses().getIgnoreMissingClassRegularExpression()));
        if (this.xmlOutputGeneratorOptions.getTitle().isPresent()) {
            jApiCmpXmlRoot.setTitle(this.xmlOutputGeneratorOptions.getTitle().get());
        }
        jApiCmpXmlRoot.setSemanticVersioning(this.xmlOutputGeneratorOptions.getSemanticVersioningInformation());
        return jApiCmpXmlRoot;
    }

    private String regExAsString(List<Pattern> ignoreMissingClassRegularExpression) {
        StringBuilder sb = new StringBuilder();
        for (Pattern pattern : ignoreMissingClassRegularExpression) {
            if (sb.length() > 0) {
                sb.append(";");
            }
            sb.append(pattern.toString());
        }
        return sb.toString();
    }
}

