/*
 * Decompiled with CFR 0.152.
 */
package japicmp.util;

import japicmp.cmp.JarArchiveComparatorOptions;
import japicmp.model.JApiAnnotation;
import japicmp.model.JApiChangeStatus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;

public class AnnotationHelper {
    public static <T> void computeAnnotationChanges(List<JApiAnnotation> annotations, Optional<T> oldClassOptional, Optional<T> newClassOptional, JarArchiveComparatorOptions options, AnnotationsAttributeCallback<T> annotationsAttributeCallback) {
        block6: {
            T newClass;
            AnnotationsAttribute newAnnotationsAttribute;
            JApiAnnotation jApiAnnotation;
            T oldClass;
            AnnotationsAttribute oldAnnotationsAttribute;
            block7: {
                JApiAnnotation jApiAnnotation2;
                Annotation foundAnnotation;
                if (options.isNoAnnotations()) break block6;
                if (!oldClassOptional.isPresent() || !newClassOptional.isPresent()) break block7;
                T oldClass2 = oldClassOptional.get();
                T newClass2 = newClassOptional.get();
                AnnotationsAttribute oldAnnotationsAttribute2 = annotationsAttributeCallback.getAnnotationsAttribute(oldClass2);
                AnnotationsAttribute newAnnotationsAttribute2 = annotationsAttributeCallback.getAnnotationsAttribute(newClass2);
                Map<String, Annotation> oldAnnotationMap = oldAnnotationsAttribute2 != null ? AnnotationHelper.buildAnnotationMap(oldAnnotationsAttribute2.getAnnotations()) : new HashMap<String, Annotation>();
                Map<String, Annotation> newAnnotationMap = newAnnotationsAttribute2 != null ? AnnotationHelper.buildAnnotationMap(newAnnotationsAttribute2.getAnnotations()) : new HashMap<String, Annotation>();
                for (Annotation annotation : oldAnnotationMap.values()) {
                    foundAnnotation = newAnnotationMap.get(annotation.getTypeName());
                    if (foundAnnotation != null) {
                        jApiAnnotation2 = new JApiAnnotation(annotation.getTypeName(), Optional.of(annotation), Optional.of(foundAnnotation), JApiChangeStatus.UNCHANGED);
                        annotations.add(jApiAnnotation2);
                        continue;
                    }
                    jApiAnnotation2 = new JApiAnnotation(annotation.getTypeName(), Optional.of(annotation), Optional.empty(), JApiChangeStatus.REMOVED);
                    annotations.add(jApiAnnotation2);
                }
                for (Annotation annotation : newAnnotationMap.values()) {
                    foundAnnotation = oldAnnotationMap.get(annotation.getTypeName());
                    if (foundAnnotation != null) continue;
                    jApiAnnotation2 = new JApiAnnotation(annotation.getTypeName(), Optional.empty(), Optional.of(annotation), JApiChangeStatus.NEW);
                    annotations.add(jApiAnnotation2);
                }
                break block6;
            }
            if (oldClassOptional.isPresent() && (oldAnnotationsAttribute = annotationsAttributeCallback.getAnnotationsAttribute(oldClass = oldClassOptional.get())) != null) {
                Map<String, Annotation> oldAnnotationMap = AnnotationHelper.buildAnnotationMap(oldAnnotationsAttribute.getAnnotations());
                for (Annotation annotation : oldAnnotationMap.values()) {
                    jApiAnnotation = new JApiAnnotation(annotation.getTypeName(), Optional.of(annotation), Optional.empty(), JApiChangeStatus.REMOVED);
                    annotations.add(jApiAnnotation);
                }
            }
            if (!newClassOptional.isPresent() || (newAnnotationsAttribute = annotationsAttributeCallback.getAnnotationsAttribute(newClass = newClassOptional.get())) == null) break block6;
            Map<String, Annotation> newAnnotationMap = AnnotationHelper.buildAnnotationMap(newAnnotationsAttribute.getAnnotations());
            for (Annotation annotation : newAnnotationMap.values()) {
                jApiAnnotation = new JApiAnnotation(annotation.getTypeName(), Optional.empty(), Optional.of(annotation), JApiChangeStatus.NEW);
                annotations.add(jApiAnnotation);
            }
        }
    }

    private static Map<String, Annotation> buildAnnotationMap(Annotation[] annotations) {
        HashMap<String, Annotation> map = new HashMap<String, Annotation>();
        for (Annotation annotation : annotations) {
            map.put(annotation.getTypeName(), annotation);
        }
        return map;
    }

    public static boolean hasAnnotation(ClassFile classFile, String annotationClassName) {
        List<AttributeInfo> attributes = classFile.getAttributes();
        return AnnotationHelper.hasAnnotation(attributes, annotationClassName);
    }

    public static boolean hasAnnotation(List attributes, String annotationClassName) {
        for (Object obj : attributes) {
            Annotation[] annotations;
            if (!(obj instanceof AnnotationsAttribute)) continue;
            AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)obj;
            for (Annotation annotation : annotations = annotationsAttribute.getAnnotations()) {
                if (!annotation.getTypeName().equals(annotationClassName)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface AnnotationsAttributeCallback<T> {
        public AnnotationsAttribute getAnnotationsAttribute(T var1);
    }
}

