/*
 * Decompiled with CFR 0.152.
 */
package japicmp.util;

import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiGenericTemplate;
import japicmp.model.JApiGenericType;
import japicmp.util.SignatureParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class GenericTemplateHelper {
    public static List<JApiGenericTemplate> computeGenericTemplateChanges(SignatureParserCallback callback) {
        ArrayList<JApiGenericTemplate> genericTemplates;
        block8: {
            block9: {
                block7: {
                    genericTemplates = new ArrayList<JApiGenericTemplate>();
                    if (!callback.isOldAndNewPresent()) break block7;
                    SignatureParser oldSignatureParser = callback.oldSignatureParser();
                    SignatureParser newSignatureParser = callback.newSignatureParser();
                    HashMap<String, SignatureParser.ParsedTemplate> oldGenericTemplatesMap = new HashMap<String, SignatureParser.ParsedTemplate>();
                    for (SignatureParser.ParsedTemplate parsedTemplate : oldSignatureParser.getTemplates()) {
                        if (oldGenericTemplatesMap.containsKey(parsedTemplate.getName())) continue;
                        oldGenericTemplatesMap.put(parsedTemplate.getName(), parsedTemplate);
                    }
                    for (SignatureParser.ParsedTemplate newParsedTemplate : newSignatureParser.getTemplates()) {
                        SignatureParser.ParsedTemplate oldParsedTemplate = (SignatureParser.ParsedTemplate)oldGenericTemplatesMap.get(newParsedTemplate.getName());
                        if (oldParsedTemplate != null) {
                            JApiChangeStatus changeStatus = JApiChangeStatus.UNCHANGED;
                            if (!newParsedTemplate.getType().equals(oldParsedTemplate.getType())) {
                                changeStatus = JApiChangeStatus.MODIFIED;
                            }
                            JApiGenericTemplate jApiGenericTemplate = new JApiGenericTemplate(changeStatus, newParsedTemplate.getName(), Optional.of(oldParsedTemplate.getType()), Optional.of(newParsedTemplate.getType()));
                            SignatureParser.copyGenericParameters(oldParsedTemplate, jApiGenericTemplate.getOldGenericTypes());
                            SignatureParser.copyGenericParameters(newParsedTemplate, jApiGenericTemplate.getNewGenericTypes());
                            SignatureParser.copyGenericTypeInterfaces(oldParsedTemplate, jApiGenericTemplate.getOldInterfaceTypes());
                            SignatureParser.copyGenericTypeInterfaces(newParsedTemplate, jApiGenericTemplate.getNewInterfaceTypes());
                            genericTemplates.add(jApiGenericTemplate);
                            oldGenericTemplatesMap.remove(newParsedTemplate.getName());
                            continue;
                        }
                        JApiGenericTemplate jApiGenericTemplate = new JApiGenericTemplate(JApiChangeStatus.NEW, newParsedTemplate.getName(), Optional.empty(), Optional.of(newParsedTemplate.getType()));
                        SignatureParser.copyGenericParameters(newParsedTemplate, jApiGenericTemplate.getNewGenericTypes());
                        SignatureParser.copyGenericTypeInterfaces(newParsedTemplate, jApiGenericTemplate.getNewInterfaceTypes());
                        genericTemplates.add(jApiGenericTemplate);
                    }
                    for (SignatureParser.ParsedTemplate oldParsedTemplate : oldGenericTemplatesMap.values()) {
                        JApiGenericTemplate jApiGenericTemplate = new JApiGenericTemplate(JApiChangeStatus.REMOVED, oldParsedTemplate.getName(), Optional.of(oldParsedTemplate.getType()), Optional.empty());
                        SignatureParser.copyGenericParameters(oldParsedTemplate, jApiGenericTemplate.getOldGenericTypes());
                        SignatureParser.copyGenericTypeInterfaces(oldParsedTemplate, jApiGenericTemplate.getOldInterfaceTypes());
                        genericTemplates.add(jApiGenericTemplate);
                    }
                    break block8;
                }
                if (!callback.isNewPresent()) break block9;
                SignatureParser newSignatureParser = callback.newSignatureParser();
                for (SignatureParser.ParsedTemplate newParsedTemplate : newSignatureParser.getTemplates()) {
                    JApiGenericTemplate jApiGenericTemplate = new JApiGenericTemplate(JApiChangeStatus.NEW, newParsedTemplate.getName(), Optional.empty(), Optional.of(newParsedTemplate.getType()));
                    SignatureParser.copyGenericParameters(newParsedTemplate, jApiGenericTemplate.getNewGenericTypes());
                    SignatureParser.copyGenericTypeInterfaces(newParsedTemplate, jApiGenericTemplate.getNewInterfaceTypes());
                    genericTemplates.add(jApiGenericTemplate);
                }
                break block8;
            }
            if (!callback.isOldPresent()) break block8;
            SignatureParser oldSignatureParser = callback.oldSignatureParser();
            for (SignatureParser.ParsedTemplate oldParsedTemplate : oldSignatureParser.getTemplates()) {
                JApiGenericTemplate jApiGenericTemplate = new JApiGenericTemplate(JApiChangeStatus.REMOVED, oldParsedTemplate.getName(), Optional.of(oldParsedTemplate.getType()), Optional.empty());
                SignatureParser.copyGenericParameters(oldParsedTemplate, jApiGenericTemplate.getOldGenericTypes());
                SignatureParser.copyGenericTypeInterfaces(oldParsedTemplate, jApiGenericTemplate.getOldInterfaceTypes());
                genericTemplates.add(jApiGenericTemplate);
            }
        }
        return genericTemplates;
    }

    public static boolean haveGenericTemplateInterfacesChanges(List<JApiGenericType> oldInterfaces, List<JApiGenericType> newInterfaces) {
        if (oldInterfaces.size() != newInterfaces.size()) {
            return true;
        }
        for (int i = 0; i < oldInterfaces.size(); ++i) {
            if (oldInterfaces.get(i).getType().equals(newInterfaces.get(i).getType())) continue;
            return true;
        }
        return false;
    }

    public static interface SignatureParserCallback {
        public boolean isOldAndNewPresent();

        public boolean isOldPresent();

        public boolean isNewPresent();

        public SignatureParser oldSignatureParser();

        public SignatureParser newSignatureParser();
    }
}

